/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.commons.UPnPService;
import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.sql.impl.OfflineTradersTable;
import com.l2jserver.gameserver.datatables.BotReportTable;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.GlobalVariablesManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.ItemAuctionManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Shutdown.class);
    private static Shutdown _counterInstance = null;
    private int _secondsShut;
    private int _shutdownMode;
    private static final int SIGTERM = 0;
    private static final int GM_SHUTDOWN = 1;
    private static final int GM_RESTART = 2;
    private static final int ABORT = 3;
    private static final String[] MODE_TEXT = new String[]{"SIGTERM", "shutting down", "restarting", "aborting"};

    private void SendServerQuit(int seconds) {
        SystemMessage sysm = SystemMessage.getSystemMessage(SystemMessageId.THE_SERVER_WILL_BE_COMING_DOWN_IN_S1_SECONDS);
        sysm.addInt(seconds);
        Broadcast.toAllOnlinePlayers(sysm);
    }

    public void startTelnetShutdown(String IP, int seconds, boolean restart) {
        LOG.warn("IP: {} issued shutdown command. {} in {} seconds!", IP, MODE_TEXT[this._shutdownMode], seconds);
        this._shutdownMode = restart ? 2 : 1;
        switch (seconds) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 30: 
            case 60: 
            case 120: 
            case 180: 
            case 240: 
            case 300: 
            case 360: 
            case 420: 
            case 480: 
            case 540: {
                break;
            }
            default: {
                this.SendServerQuit(seconds);
            }
        }
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
        _counterInstance = new Shutdown(seconds, restart);
        _counterInstance.start();
    }

    public void telnetAbort(String IP) {
        LOG.warn("IP: {} issued shutdown ABORT. {} has been stopped!", (Object)IP, (Object)MODE_TEXT[this._shutdownMode]);
        if (_counterInstance != null) {
            _counterInstance._abort();
            Broadcast.toAllOnlinePlayers("Server aborts " + MODE_TEXT[this._shutdownMode] + " and continues normal operation!", false);
        }
    }

    protected Shutdown() {
        this._secondsShut = -1;
        this._shutdownMode = 0;
    }

    public Shutdown(int seconds, boolean restart) {
        if (seconds < 0) {
            seconds = 0;
        }
        this._secondsShut = seconds;
        this._shutdownMode = restart ? 2 : 1;
    }

    @Override
    public void run() {
        if (this == Shutdown.getInstance()) {
            TimeCounter tc = new TimeCounter();
            TimeCounter tc1 = new TimeCounter();
            try {
                UPnPService.getInstance().removeAllPorts();
                LOG.info("UPnP Service: All ports mappings deleted ({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception e) {
                LOG.warn("Error while removing UPnP port mappings!", e);
            }
            try {
                if ((Configuration.customs().offlineTradeEnable() || Configuration.customs().offlineCraftEnable()) && Configuration.customs().restoreOffliners()) {
                    OfflineTradersTable.getInstance().storeOffliners();
                    LOG.info("Offline Traders Table: Offline shops stored({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
                }
            }
            catch (Exception e) {
                LOG.warn("Error saving offline shops!", e);
            }
            try {
                this.disconnectAllCharacters();
                LOG.info("All players disconnected and saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                GameTimeController.getInstance().stopTimer();
                LOG.info("Game Time Controller: Timer stopped({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ThreadPoolManager.getInstance().shutdown();
                LOG.info("Thread Pool Manager: Manager has been shut down({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LoginServerThread.getInstance().interrupt();
                LOG.info("Login Server Thread: Thread interrupted({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveData();
            tc.restartCounter();
            try {
                GameServer.gameServer.getSelectorThread().shutdown();
                LOG.info("Game Server: Selector thread has been shut down({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionFactory.getInstance().close();
            LOG.info("ConnectionFactory: Database connection has been shutdown({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            if (Shutdown.getInstance()._shutdownMode == 2) {
                Runtime.getRuntime().halt(2);
            } else {
                Runtime.getRuntime().halt(0);
            }
            LOG.info("The server has been successfully shut down in {}seconds.", (Object)TimeUnit.MILLISECONDS.toSeconds(tc1.getEstimatedTime()));
        } else {
            this.countdown();
            LOG.warn("GM shutdown countdown is over. {} NOW!", (Object)MODE_TEXT[this._shutdownMode]);
            switch (this._shutdownMode) {
                case 1: {
                    Shutdown.getInstance().setMode(1);
                    System.exit(0);
                    break;
                }
                case 2: {
                    Shutdown.getInstance().setMode(2);
                    System.exit(2);
                    break;
                }
                case 3: {
                    LoginServerThread.getInstance().setServerStatus(0);
                }
            }
        }
    }

    public void startShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        this._shutdownMode = restart ? 2 : 1;
        LOG.warn("GM: {}({}) issued shutdown command. {} in {} seconds!", activeChar.getName(), activeChar.getObjectId(), MODE_TEXT[this._shutdownMode], seconds);
        if (this._shutdownMode > 0) {
            switch (seconds) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 30: 
                case 60: 
                case 120: 
                case 180: 
                case 240: 
                case 300: 
                case 360: 
                case 420: 
                case 480: 
                case 540: {
                    break;
                }
                default: {
                    this.SendServerQuit(seconds);
                }
            }
        }
        if (_counterInstance != null) {
            _counterInstance._abort();
        }
        _counterInstance = new Shutdown(seconds, restart);
        _counterInstance.start();
    }

    public void abort(L2PcInstance activeChar) {
        LOG.warn("GM: {}({}) issued shutdown ABORT. {} has been stopped!", activeChar.getName(), activeChar.getObjectId(), MODE_TEXT[this._shutdownMode]);
        if (_counterInstance != null) {
            _counterInstance._abort();
            Broadcast.toAllOnlinePlayers("Server aborts " + MODE_TEXT[this._shutdownMode] + " and continues normal operation!", false);
        }
    }

    private void setMode(int mode) {
        this._shutdownMode = mode;
    }

    private void _abort() {
        this._shutdownMode = 3;
    }

    private void countdown() {
        try {
            while (this._secondsShut > 0) {
                switch (this._secondsShut) {
                    case 540: {
                        this.SendServerQuit(540);
                        break;
                    }
                    case 480: {
                        this.SendServerQuit(480);
                        break;
                    }
                    case 420: {
                        this.SendServerQuit(420);
                        break;
                    }
                    case 360: {
                        this.SendServerQuit(360);
                        break;
                    }
                    case 300: {
                        this.SendServerQuit(300);
                        break;
                    }
                    case 240: {
                        this.SendServerQuit(240);
                        break;
                    }
                    case 180: {
                        this.SendServerQuit(180);
                        break;
                    }
                    case 120: {
                        this.SendServerQuit(120);
                        break;
                    }
                    case 60: {
                        LoginServerThread.getInstance().setServerStatus(4);
                        this.SendServerQuit(60);
                        break;
                    }
                    case 30: {
                        this.SendServerQuit(30);
                        break;
                    }
                    case 10: {
                        this.SendServerQuit(10);
                        break;
                    }
                    case 5: {
                        this.SendServerQuit(5);
                        break;
                    }
                    case 4: {
                        this.SendServerQuit(4);
                        break;
                    }
                    case 3: {
                        this.SendServerQuit(3);
                        break;
                    }
                    case 2: {
                        this.SendServerQuit(2);
                        break;
                    }
                    case 1: {
                        this.SendServerQuit(1);
                    }
                }
                --this._secondsShut;
                int delay = 1000;
                Thread.sleep(delay);
                if (this._shutdownMode != 3) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void saveData() {
        switch (this._shutdownMode) {
            case 0: {
                LOG.info("SIGTERM received. Shutting down NOW!");
                break;
            }
            case 1: {
                LOG.info("GM shutdown received. Shutting down NOW!");
                break;
            }
            case 2: {
                LOG.info("GM restart received. Restarting NOW!");
            }
        }
        TimeCounter tc = new TimeCounter();
        if (!SevenSigns.getInstance().isSealValidationPeriod()) {
            SevenSignsFestival.getInstance().saveFestivalData(false);
            LOG.info("SevenSignsFestival: Festival data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        }
        SevenSigns.getInstance().saveSevenSignsData();
        LOG.info("SevenSigns: Seven Signs data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        SevenSigns.getInstance().saveSevenSignsStatus();
        LOG.info("SevenSigns: Seven Signs status saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        RaidBossSpawnManager.getInstance().cleanUp();
        LOG.info("RaidBossSpawnManager: All raidboss info saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        GrandBossManager.getInstance().cleanUp();
        LOG.info("GrandBossManager: All Grand Boss info saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        ItemAuctionManager.getInstance().shutdown();
        LOG.info("Item Auction Manager: All tasks stopped({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        Olympiad.getInstance().saveOlympiadStatus();
        LOG.info("Olympiad System: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        Hero.getInstance().shutdown();
        LOG.info("Hero System: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        ClanTable.getInstance().storeClanScore();
        LOG.info("Clan System: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        CursedWeaponsManager.getInstance().saveData();
        LOG.info("Cursed Weapons Manager: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        if (!Configuration.general().manorSaveAllActions()) {
            CastleManorManager.getInstance().storeMe();
            LOG.info("Castle Manor Manager: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        }
        ClanHallSiegeManager.getInstance().onServerShutDown();
        LOG.info("CHSiegeManager: Siegable hall attacker lists saved!");
        QuestManager.getInstance().save();
        LOG.info("Quest Manager: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        GlobalVariablesManager.getInstance().storeMe();
        LOG.info("Global Variables Manager: Variables saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        if (Configuration.general().saveDroppedItem()) {
            ItemsOnGroundManager.getInstance().saveInDb();
            LOG.info("Items On Ground Manager: Data saved({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
            ItemsOnGroundManager.getInstance().cleanUp();
            LOG.info("Items On Ground Manager: Cleaned up({}ms).", (Object)tc.getEstimatedTimeAndRestartCounter());
        }
        if (Configuration.general().enableBotReportButton()) {
            BotReportTable.getInstance().saveReportedCharData();
            LOG.info("Bot Report Table: Successfully saved reports to database!");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void disconnectAllCharacters() {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            try {
                L2GameClient client = player.getClient();
                if (client != null && !client.isDetached()) {
                    client.close(ServerClose.STATIC_PACKET);
                    client.setActiveChar(null);
                    player.setClient(null);
                }
                player.deleteMe();
            }
            catch (Exception e) {
                LOG.warn("Failed logout char {}", (Object)player, (Object)e);
            }
        }
    }

    public static Shutdown getInstance() {
        return SingletonHolder._instance;
    }

    private static final class TimeCounter {
        private long _startTime;

        protected TimeCounter() {
            this.restartCounter();
        }

        protected void restartCounter() {
            this._startTime = System.currentTimeMillis();
        }

        protected long getEstimatedTimeAndRestartCounter() {
            long toReturn = System.currentTimeMillis() - this._startTime;
            this.restartCounter();
            return toReturn;
        }

        protected long getEstimatedTime() {
            return System.currentTimeMillis() - this._startTime;
        }
    }

    private static class SingletonHolder {
        protected static final Shutdown _instance = new Shutdown();

        private SingletonHolder() {
        }
    }
}

