/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.FearTask;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.TerritoryTable;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.AttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.FactionCall;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.TargetType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2AttackableAI
extends L2CharacterAI {
    private static final Logger LOG = LoggerFactory.getLogger(L2AttackableAI.class);
    private static final int FEAR_TICKS = 5;
    private static final int RANDOM_WALK_RATE = 30;
    private static final int MAX_ATTACK_TIMEOUT = 1200;
    private Future<?> _aiTask;
    private int _attackTimeout = Integer.MAX_VALUE;
    private int _globalAggro = -10;
    private boolean _thinking;
    private int _chaosTime = 0;
    private int _lastBuffTick;
    private int _fearTime;
    private Future<?> _fearTask = null;

    public L2AttackableAI(L2Attackable creature) {
        super(creature);
    }

    private boolean autoAttackCondition(L2Character target) {
        if (target == null) {
            return false;
        }
        if (target.isInvul()) {
            if (target.isPlayer() && target.isGM()) {
                return false;
            }
            if (target.isSummon() && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target.isDoor()) {
            return false;
        }
        L2Attackable actor = this.getActor();
        if (target.isAlikeDead() || target.isPlayable() && !actor.isInsideRadius(target, actor.getAggroRange(), true, false)) {
            return false;
        }
        if (target.isPlayable() && !actor.isRaid() && !actor.canSeeThroughSilentMove() && ((L2Playable)target).isSilentMovingAffected()) {
            return false;
        }
        L2PcInstance player = target.getActingPlayer();
        if (player != null) {
            if (player.isGM() && !player.getAccessLevel().canTakeAggro()) {
                return false;
            }
            if (player.isRecentFakeDeath()) {
                return false;
            }
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                byte riftType = player.getParty().getDimensionalRift().getType();
                byte riftRoom = player.getParty().getDimensionalRift().getCurrentRoom();
                if (actor instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(actor.getX(), actor.getY(), actor.getZ())) {
                    return false;
                }
            }
        }
        if (actor instanceof L2GuardInstance) {
            if (player != null && player.getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)actor, player);
            }
            if (target instanceof L2MonsterInstance) {
                L2MonsterInstance monster = (L2MonsterInstance)target;
                if (Configuration.npc().guardAttackAggroMob()) {
                    return monster.isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)actor, target);
                }
            }
            return false;
        }
        if (actor instanceof L2FriendlyMobInstance) {
            L2PcInstance targetPlayer;
            if (target instanceof L2Npc) {
                return false;
            }
            if (target instanceof L2PcInstance && (targetPlayer = (L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)actor, target);
            }
            return false;
        }
        if (target instanceof L2Attackable) {
            L2Attackable attackable = (L2Attackable)target;
            if (!target.isAutoAttackable(actor)) {
                return false;
            }
            if (actor.isChaos() && actor.isInsideRadius(target, actor.getAggroRange(), false, false)) {
                if (attackable.isInMyClan(actor)) {
                    return false;
                }
                return GeoData.getInstance().canSeeTarget((L2Object)actor, target);
            }
        }
        if (target instanceof L2Npc) {
            return false;
        }
        if (!Configuration.npc().mobAggroInPeaceZone() && target.isInsideZone(ZoneId.PEACE)) {
            return false;
        }
        if (actor.isChampion() && Configuration.customs().championPassive()) {
            return false;
        }
        return actor.isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)actor, target);
    }

    public void startAITask() {
        if (this._aiTask == null && this._actor.isInActiveRegion()) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this::onEvtThink, 1000L, 1000L);
        }
    }

    @Override
    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
        super.stopAITask();
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE || intention == CtrlIntention.AI_INTENTION_ACTIVE) {
            L2Attackable actor = this.getActor();
            if (!actor.isAlikeDead()) {
                int range;
                Location loc;
                if (!actor.getKnownList().getKnownPlayers().isEmpty()) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                } else if (actor.getSpawn() != null && !actor.isInsideRadius(loc = actor.getSpawn().getLocation(actor), (range = Configuration.npc().getMaxDriftRange()) + range, true, false)) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                }
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                this.stopAITask();
                this._actor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        this.startAITask();
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        int currentTick = GameTimeController.getInstance().getGameTicks();
        this._attackTimeout = 1200 + currentTick;
        if (this._lastBuffTick + 30 < currentTick) {
            for (Skill buff : this.getActor().getTemplate().getAISkills(AISkillScope.BUFF)) {
                if (!L2AttackableAI.checkSkillCastConditions(this.getActor(), buff) || this._actor.isAffectedBySkill(buff.getId())) continue;
                this._actor.setTarget(this._actor);
                this._actor.doCast(buff);
                this._actor.setTarget(target);
                LOG.debug("{} used buff skill {} on {}", this, buff, this._actor);
                break;
            }
            this._lastBuffTick = currentTick;
        }
        super.onIntentionAttack(target);
    }

    @Override
    protected void onEvtAfraid(L2Character effector, boolean start) {
        if (this._fearTime > 0 && this._fearTask == null) {
            this._fearTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FearTask(this, effector, start), 0L, 5L, TimeUnit.SECONDS);
            this._actor.startAbnormalVisualEffect(true, AbnormalVisualEffect.TURN_FLEE);
        } else {
            super.onEvtAfraid(effector, start);
            if ((this._actor.isDead() || this._fearTime <= 0) && this._fearTask != null) {
                this._fearTask.cancel(true);
                this._fearTask = null;
                this._actor.stopAbnormalVisualEffect(true, AbnormalVisualEffect.TURN_FLEE);
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
            }
        }
    }

    protected void thinkCast() {
        if (this.checkTargetLost(this.getCastTarget())) {
            this.setCastTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(this.getCastTarget(), this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.clientStopMoving(null);
        this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        this._actor.doCast(this._skill);
    }

    protected void thinkActive() {
        L2Attackable actor = this.getActor();
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            L2Character hated;
            for (L2Object obj : actor.getKnownList().getKnownObjects().values()) {
                long hating;
                TerminateReturn term;
                L2PcInstance targetPlayer;
                if (!(obj instanceof L2Character)) continue;
                L2Character target = (L2Character)obj;
                if (obj instanceof L2StaticObjectInstance || actor instanceof L2FestivalMonsterInstance && obj instanceof L2PcInstance && !(targetPlayer = (L2PcInstance)obj).isFestivalParticipant() || !this.autoAttackCondition(target) || target.isPlayable() && (term = EventDispatcher.getInstance().notifyEvent(new AttackableHate(this.getActor(), target.getActingPlayer(), target.isSummon()), this.getActor(), TerminateReturn.class)) != null && term.terminate() || (hating = actor.getHating(target)) != 0L) continue;
                actor.addDamageHate(target, 0, 0L);
            }
            L2Character l2Character = hated = actor.isConfused() ? this.getAttackTarget() : actor.getMostHated();
            if (hated != null && !actor.isCoreAIDisabled()) {
                long aggro = actor.getHating(hated);
                if (aggro + (long)this._globalAggro > 0L) {
                    if (!actor.isRunning()) {
                        actor.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
                }
                return;
            }
        }
        if (actor.getCurrentHp() == (double)actor.getMaxHp() && actor.getCurrentMp() == (double)actor.getMaxMp() && !actor.getAttackByList().isEmpty() && Rnd.nextInt((int)500) == 0) {
            L2MonsterInstance monster;
            actor.clearAggroList();
            actor.getAttackByList().clear();
            if (actor instanceof L2MonsterInstance && (monster = (L2MonsterInstance)actor).hasMinions()) {
                monster.getMinionList().deleteReusedMinions();
            }
        }
        if (!actor.canReturnToSpawnPoint()) {
            return;
        }
        if (actor instanceof L2GuardInstance && !actor.isWalker()) {
            actor.returnHome();
        }
        if (actor instanceof L2FestivalMonsterInstance) {
            return;
        }
        L2Attackable leader = actor.getLeader();
        if (leader != null && !leader.isAlikeDead()) {
            int minRadius = 30;
            int offset = actor.isRaidMinion() ? 500 : 200;
            if (leader.isRunning()) {
                actor.setRunning();
            } else {
                actor.setWalking();
            }
            if (actor.calculateDistance(leader, false, true) > (double)(offset * offset)) {
                int x1 = Rnd.get((int)60, (int)(offset * 2));
                int y1 = Rnd.get((int)x1, (int)(offset * 2));
                y1 = (int)Math.sqrt(y1 * y1 - x1 * x1);
                x1 = x1 > offset + 30 ? leader.getX() + x1 - offset : leader.getX() - x1 + 30;
                y1 = y1 > offset + 30 ? leader.getY() + y1 - offset : leader.getY() - y1 + 30;
                int z1 = leader.getZ();
                this.moveTo(x1, y1, z1);
            } else if (Rnd.nextInt((int)30) == 0) {
                for (Skill sk : actor.getTemplate().getAISkills(AISkillScope.BUFF)) {
                    if (!this.cast(sk)) continue;
                    return;
                }
            }
        } else if (actor.getSpawn() != null && Rnd.nextInt((int)30) == 0 && !actor.isNoRndWalk()) {
            int x1 = 0;
            int y1 = 0;
            int z1 = 0;
            int range = Configuration.npc().getMaxDriftRange();
            if (actor.isWalker()) {
                return;
            }
            for (Skill sk : actor.getTemplate().getAISkills(AISkillScope.BUFF)) {
                if (!this.cast(sk)) continue;
                return;
            }
            if (actor.getSpawn().getX() == 0 && actor.getSpawn().getY() == 0 && actor.getSpawn().getSpawnTerritory() == null) {
                double distance2;
                Location location = TerritoryTable.getInstance().getRandomPoint(actor.getSpawn().getLocationId());
                if (location != null) {
                    x1 = location.getX();
                    y1 = location.getY();
                    z1 = location.getZ();
                }
                if ((distance2 = actor.calculateDistance(x1, y1, 0, false, true)) > (double)((range + range) * (range + range))) {
                    actor.setisReturningToSpawnPoint(true);
                    float delay = (float)Math.sqrt(distance2) / (float)range;
                    x1 = actor.getX() + (int)((float)(x1 - actor.getX()) / delay);
                    y1 = actor.getY() + (int)((float)(y1 - actor.getY()) / delay);
                }
                if (!actor.isReturningToSpawnPoint() && TerritoryTable.getInstance().getProcMax(actor.getSpawn().getLocationId()) > 0) {
                    return;
                }
            } else {
                x1 = actor.getSpawn().getX(actor);
                y1 = actor.getSpawn().getY(actor);
                z1 = actor.getSpawn().getZ(actor);
                if (!actor.isInsideRadius(x1, y1, 0, range, false, false)) {
                    actor.setisReturningToSpawnPoint(true);
                } else {
                    int deltaX = Rnd.nextInt((int)(range * 2));
                    int deltaY = Rnd.get((int)deltaX, (int)(range * 2));
                    deltaY = (int)Math.sqrt(deltaY * deltaY - deltaX * deltaX);
                    x1 = deltaX + x1 - range;
                    y1 = deltaY + y1 - range;
                    z1 = actor.getZ();
                }
            }
            Location moveLoc = GeoData.getInstance().moveCheck(actor.getX(), actor.getY(), actor.getZ(), x1, y1, z1, actor.getInstanceId());
            this.moveTo(moveLoc.getX(), moveLoc.getY(), moveLoc.getZ());
        }
    }

    protected void thinkAttack() {
        List<Skill> generalSkills;
        double distance2;
        Object skill;
        L2Attackable actor = this.getActor();
        if (actor.isCastingNow() || actor.isAttackingNow()) {
            return;
        }
        if (actor.isCoreAIDisabled()) {
            return;
        }
        if (actor.isOutOfControl()) {
            return;
        }
        L2Character mostHated = actor.getMostHated();
        if (mostHated == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return;
        }
        this.setAttackTarget(mostHated);
        actor.setTarget(mostHated);
        if (actor.isMovementDisabled()) {
            this.movementDisable();
            return;
        }
        L2Character originalAttackTarget = this.getAttackTarget();
        if (originalAttackTarget == null || originalAttackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getInstance().getGameTicks()) {
            actor.stopHating(originalAttackTarget);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            actor.setWalking();
            return;
        }
        if (actor.isSevenNpc()) {
            L2PcInstance target2 = originalAttackTarget.getActingPlayer();
            if (SevenSigns.getInstance().isSealValidationPeriod() || SevenSigns.getInstance().isCompResultsPeriod()) {
                if (!target2.isGM() && target2.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(target2.getObjectId()) != SevenSigns.getInstance().getCabalHighestScore()) {
                    target2.teleToLocation(TeleportWhereType.TOWN);
                    target2.setIsIn7sDungeon(false);
                    target2.sendMessage("You have been teleported to the nearest town due to the beginning of the Seal Validation period.");
                }
            } else if (!target2.isGM() && target2.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(target2.getObjectId()) == 0) {
                target2.teleToLocation(TeleportWhereType.TOWN);
                target2.setIsIn7sDungeon(false);
                target2.sendMessage("You have been teleported to the nearest town because you have not signed for any cabal.");
            }
        }
        int collision = actor.getTemplate().getCollisionRadius();
        Set<Integer> clans = this.getActor().getTemplate().getClans();
        if (clans != null && !clans.isEmpty()) {
            int factionRange = actor.getTemplate().getClanHelpRange() + collision;
            try {
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(factionRange)) {
                    if (!(obj instanceof L2Npc)) continue;
                    L2Npc called = (L2Npc)obj;
                    if (!this.getActor().getTemplate().isClan(called.getTemplate().getClans()) || !called.hasAI() || Math.abs(originalAttackTarget.getZ() - called.getZ()) >= 600 || !actor.getAttackByList().contains(originalAttackTarget) || called.getAI()._intention != CtrlIntention.AI_INTENTION_IDLE && called.getAI()._intention != CtrlIntention.AI_INTENTION_ACTIVE || called.getInstanceId() != actor.getInstanceId()) continue;
                    if (originalAttackTarget.isPlayable()) {
                        if (originalAttackTarget.isInParty() && originalAttackTarget.getParty().isInDimensionalRift()) {
                            byte riftType = originalAttackTarget.getParty().getDimensionalRift().getType();
                            byte riftRoom = originalAttackTarget.getParty().getDimensionalRift().getCurrentRoom();
                            if (actor instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(actor.getX(), actor.getY(), actor.getZ())) continue;
                        }
                        called.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, originalAttackTarget, 1);
                        EventDispatcher.getInstance().notifyEventAsync(new FactionCall(called, this.getActor(), originalAttackTarget.getActingPlayer(), originalAttackTarget.isSummon()), called);
                        continue;
                    }
                    if (!(called instanceof L2Attackable)) continue;
                    L2Attackable attackable = (L2Attackable)called;
                    if (this.getAttackTarget() == null || called.getAI()._intention == CtrlIntention.AI_INTENTION_ATTACK) continue;
                    attackable.addDamageHate(this.getAttackTarget(), 0, actor.getHating(this.getAttackTarget()));
                    called.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this.getAttackTarget());
                }
            }
            catch (NullPointerException e) {
                LOG.warn("{}: There has been a problem trying to think the attack!", (Object)this.getClass().getSimpleName(), (Object)e);
            }
        }
        int combinedCollision = collision + mostHated.getTemplate().getCollisionRadius();
        List<Skill> aiSuicideSkills = actor.getTemplate().getAISkills(AISkillScope.SUICIDE);
        if (!aiSuicideSkills.isEmpty() && (int)(actor.getCurrentHp() / (double)actor.getMaxHp() * 100.0) < 30 && Util.checkIfInRange(((Skill)(skill = aiSuicideSkills.get(Rnd.get((int)aiSuicideSkills.size())))).getAffectRange(), this.getActor(), mostHated, false) && actor.hasSkillChance() && this.cast((Skill)skill)) {
            LOG.debug("{} used suicide skill {}", (Object)this, skill);
            return;
        }
        if (!actor.isMovementDisabled() && Rnd.nextInt((int)100) <= 3) {
            for (L2Object nearby : actor.getKnownList().getKnownObjects().values()) {
                if (!(nearby instanceof L2Attackable) || !actor.isInsideRadius(nearby, collision, false, false) || nearby == mostHated) continue;
                int newX = combinedCollision + Rnd.get((int)40);
                newX = Rnd.nextBoolean() ? mostHated.getX() + newX : mostHated.getX() - newX;
                int newY = combinedCollision + Rnd.get((int)40);
                newY = Rnd.nextBoolean() ? mostHated.getY() + newY : mostHated.getY() - newY;
                if (!actor.isInsideRadius(newX, newY, 0, collision, false, false)) {
                    int newZ = actor.getZ() + 30;
                    if (GeoData.getInstance().canMove(actor.getX(), actor.getY(), actor.getZ(), newX, newY, newZ, actor.getInstanceId())) {
                        this.moveTo(newX, newY, newZ);
                    }
                }
                return;
            }
        }
        if (!actor.isMovementDisabled() && actor.getTemplate().getBaseAttackRange() >= 700 && Rnd.get((int)100) <= 15 && Math.sqrt(distance2 = actor.calculateDistance(mostHated, false, true)) <= (double)(60 + combinedCollision)) {
            int posX = actor.getX();
            int posY = actor.getY();
            int posZ = actor.getZ() + 30;
            posX = originalAttackTarget.getX() < posX ? (posX += 300) : (posX -= 300);
            posY = originalAttackTarget.getY() < posY ? (posY += 300) : (posY -= 300);
            if (GeoData.getInstance().canMove(actor.getX(), actor.getY(), actor.getZ(), posX, posY, posZ, actor.getInstanceId())) {
                this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(posX, posY, posZ, 0));
            }
            return;
        }
        if (actor.isRaid() || actor.isRaidMinion()) {
            ++this._chaosTime;
            if (actor instanceof L2RaidBossInstance) {
                if (!((L2MonsterInstance)actor).hasMinions()) {
                    if (this._chaosTime > Configuration.npc().getRaidChaosTime() && (double)Rnd.get((int)100) <= 100.0 - actor.getCurrentHp() * 100.0 / (double)actor.getMaxHp()) {
                        this.aggroReconsider();
                        this._chaosTime = 0;
                        return;
                    }
                } else if (this._chaosTime > Configuration.npc().getRaidChaosTime() && (double)Rnd.get((int)100) <= 100.0 - actor.getCurrentHp() * 200.0 / (double)actor.getMaxHp()) {
                    this.aggroReconsider();
                    this._chaosTime = 0;
                    return;
                }
            } else if (actor instanceof L2GrandBossInstance) {
                double chaosRate;
                if (this._chaosTime > Configuration.npc().getGrandChaosTime() && ((chaosRate = 100.0 - actor.getCurrentHp() * 300.0 / (double)actor.getMaxHp()) <= 10.0 && Rnd.get((int)100) <= 10 || chaosRate > 10.0 && (double)Rnd.get((int)100) <= chaosRate)) {
                    this.aggroReconsider();
                    this._chaosTime = 0;
                    return;
                }
            } else if (this._chaosTime > Configuration.npc().getMinionChaosTime() && (double)Rnd.get((int)100) <= 100.0 - actor.getCurrentHp() * 200.0 / (double)actor.getMaxHp()) {
                this.aggroReconsider();
                this._chaosTime = 0;
                return;
            }
        }
        if (!(generalSkills = actor.getTemplate().getAISkills(AISkillScope.GENERAL)).isEmpty()) {
            List<Skill> aiLongRangeSkills;
            List<Skill> aiShortRangeSkills;
            List<Skill> aiResSkills;
            List<Skill> aiHealSkills = actor.getTemplate().getAISkills(AISkillScope.HEAL);
            if (!aiHealSkills.isEmpty()) {
                L2Attackable leader;
                double percentage = actor.getCurrentHp() / (double)actor.getMaxHp() * 100.0;
                if (actor.isMinion() && (leader = actor.getLeader()) != null && !leader.isDead() && (double)Rnd.get((int)100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    for (Skill healSkill : aiHealSkills) {
                        if (healSkill.getTargetType() == TargetType.SELF || !L2AttackableAI.checkSkillCastConditions(actor, healSkill)) continue;
                        if (!(Util.checkIfInRange(healSkill.getCastRange() + collision + leader.getTemplate().getCollisionRadius(), actor, leader, false) || this.isParty(healSkill) || actor.isMovementDisabled())) {
                            this.moveToPawn(leader, healSkill.getCastRange() + collision + leader.getTemplate().getCollisionRadius());
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)actor, leader)) continue;
                        this.clientStopMoving(null);
                        L2Object target4 = actor.getTarget();
                        actor.setTarget(leader);
                        actor.doCast(healSkill);
                        actor.setTarget(target4);
                        LOG.debug("{} used heal skill {} on leader {}", this, healSkill, leader);
                        return;
                    }
                }
                if ((double)Rnd.get((int)100) < (100.0 - percentage) / 3.0) {
                    for (Skill skill2 : aiHealSkills) {
                        if (!L2AttackableAI.checkSkillCastConditions(actor, skill2)) continue;
                        this.clientStopMoving(null);
                        L2Object target3 = actor.getTarget();
                        actor.setTarget(actor);
                        actor.doCast(skill2);
                        actor.setTarget(target3);
                        LOG.debug("{} used heal skill {} on itself", (Object)this, (Object)skill2);
                        return;
                    }
                }
                for (Skill skill3 : aiHealSkills) {
                    if (!L2AttackableAI.checkSkillCastConditions(actor, skill3)) continue;
                    if (skill3.getTargetType() == TargetType.ONE) {
                        for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(skill3.getCastRange() + collision)) {
                            if (!(obj instanceof L2Attackable)) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (obj.isDead() || !targets.isInMyClan(actor)) continue;
                            percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                            if (!((double)Rnd.get((int)100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)actor, targets)) continue;
                            this.clientStopMoving(null);
                            L2Object target5 = actor.getTarget();
                            actor.setTarget(obj);
                            actor.doCast(skill3);
                            actor.setTarget(target5);
                            LOG.debug("{} used heal skill {} on {}", this, skill3, obj);
                            return;
                        }
                    }
                    if (!this.isParty(skill3)) continue;
                    this.clientStopMoving(null);
                    actor.doCast(skill3);
                    return;
                }
            }
            if (!(aiResSkills = actor.getTemplate().getAISkills(AISkillScope.RES)).isEmpty()) {
                L2Attackable leader;
                if (actor.isMinion() && (leader = actor.getLeader()) != null && leader.isDead()) {
                    for (Skill skill4 : aiResSkills) {
                        if (skill4.getTargetType() == TargetType.SELF || !L2AttackableAI.checkSkillCastConditions(actor, skill4)) continue;
                        if (!(Util.checkIfInRange(skill4.getCastRange() + collision + leader.getTemplate().getCollisionRadius(), actor, leader, false) || this.isParty(skill4) || actor.isMovementDisabled())) {
                            this.moveToPawn(leader, skill4.getCastRange() + collision + leader.getTemplate().getCollisionRadius());
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)actor, leader)) continue;
                        this.clientStopMoving(null);
                        L2Object target = actor.getTarget();
                        actor.setTarget(leader);
                        actor.doCast(skill4);
                        actor.setTarget(target);
                        LOG.debug("{} used resurrection skill {} on leader {}", this, skill4, leader);
                        return;
                    }
                }
                for (Skill sk : aiResSkills) {
                    if (!L2AttackableAI.checkSkillCastConditions(actor, sk)) continue;
                    if (sk.getTargetType() == TargetType.ONE) {
                        for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + collision)) {
                            if (!(obj instanceof L2Attackable)) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (!obj.isDead() || !actor.isInMyClan(targets) || Rnd.get((int)100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)actor, targets)) continue;
                            this.clientStopMoving(null);
                            L2Object target6 = actor.getTarget();
                            actor.setTarget(obj);
                            actor.doCast(sk);
                            actor.setTarget(target6);
                            LOG.debug("{} used heal skill {} on clan member {}", this, sk, obj);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    L2Object l2Object = actor.getTarget();
                    actor.setTarget(actor);
                    actor.doCast(sk);
                    actor.setTarget(l2Object);
                    LOG.debug("{} used heal skill {} on party", (Object)this, (Object)sk);
                    return;
                }
            }
            if (!(aiShortRangeSkills = actor.getTemplate().getAISkills(AISkillScope.SHORT_RANGE)).isEmpty()) {
                for (Skill skill5 : aiShortRangeSkills) {
                    Skill skill2;
                    if (!L2AttackableAI.checkSkillCastConditions(actor, skill5) || !Util.checkIfInRange((skill2 = aiShortRangeSkills.get(Rnd.get((int)aiShortRangeSkills.size()))).getCastRange(), this.getActor(), mostHated, false) || !actor.hasSkillChance() || !GeoData.getInstance().canSeeTarget((L2Object)actor, mostHated)) continue;
                    this.clientStopMoving(null);
                    actor.doCast(skill2);
                    LOG.debug("{} used short range skill {} on {}", this, skill2, actor.getTarget());
                    return;
                }
            }
            if (!(aiLongRangeSkills = actor.getTemplate().getAISkills(AISkillScope.LONG_RANGE)).isEmpty()) {
                for (Skill longSkill : aiLongRangeSkills) {
                    Skill skill3;
                    if (!L2AttackableAI.checkSkillCastConditions(actor, longSkill) || !Util.checkIfInRange((skill3 = aiLongRangeSkills.get(Rnd.get((int)aiLongRangeSkills.size()))).getCastRange(), this.getActor(), mostHated, false) || !actor.hasSkillChance() || !GeoData.getInstance().canSeeTarget((L2Object)actor, mostHated)) continue;
                    this.clientStopMoving(null);
                    actor.doCast(skill3);
                    LOG.debug("{} used long range skill {} on {}", this, skill3, actor.getTarget());
                    return;
                }
            }
        }
        double dist = actor.calculateDistance(mostHated, false, false);
        int dist2 = (int)dist - collision;
        int range = actor.getPhysicalAttackRange() + combinedCollision;
        if (actor.getTemplate().getBaseAttackRange() >= 700) {
            range = actor.getTemplate().getBaseAttackRange();
        }
        if (mostHated.isMoving()) {
            range += 50;
            if (actor.isMoving()) {
                range += 50;
            }
        }
        if (dist2 > range || !GeoData.getInstance().canSeeTarget((L2Object)actor, mostHated)) {
            if (actor.isMovementDisabled()) {
                this.targetReconsider();
            } else {
                L2Character l2Character = this.getAttackTarget();
                if (l2Character != null) {
                    if (l2Character.isMoving()) {
                        range -= 100;
                    }
                    this.moveToPawn(l2Character, Math.max(range, 5));
                }
            }
            return;
        }
        this.clientStopMoving(null);
        this._actor.doAttack(this.getAttackTarget());
    }

    private boolean cast(Skill sk) {
        L2Character target;
        L2Character attackTarget;
        L2Attackable actor = this.getActor();
        if (!L2AttackableAI.checkSkillCastConditions(actor, sk)) {
            return false;
        }
        if (this.getAttackTarget() == null && actor.getMostHated() != null) {
            this.setAttackTarget(actor.getMostHated());
        }
        if ((attackTarget = this.getAttackTarget()) == null) {
            return false;
        }
        double dist = actor.calculateDistance(attackTarget, false, false);
        double dist2 = dist - (double)attackTarget.getTemplate().getCollisionRadius();
        double range = actor.getPhysicalAttackRange() + actor.getTemplate().getCollisionRadius() + attackTarget.getTemplate().getCollisionRadius();
        double srange = sk.getCastRange() + actor.getTemplate().getCollisionRadius();
        if (attackTarget.isMoving()) {
            dist2 -= 30.0;
        }
        if (sk.isContinuous()) {
            if (!sk.isDebuff()) {
                if (!actor.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    actor.setTarget(actor);
                    actor.doCast(sk);
                    this._actor.setTarget(attackTarget);
                    return true;
                }
                if (sk.getTargetType() == TargetType.SELF) {
                    return false;
                }
                if (sk.getTargetType() == TargetType.ONE && (target = this.effectTargetReconsider(sk, true)) != null) {
                    this.clientStopMoving(null);
                    actor.setTarget(target);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
                if (this.canParty(sk)) {
                    this.clientStopMoving(null);
                    actor.setTarget(actor);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            } else if (GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
            } else if (!this.canAOE(sk) && sk.getTargetType() == TargetType.ONE && (target = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                actor.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.DISPEL, new L2EffectType[0])) {
            if (sk.getTargetType() == TargetType.ONE) {
                if (attackTarget.getEffectList().getFirstEffect(L2EffectType.BUFF) != null && GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
                target = this.effectTargetReconsider(sk, false);
                if (target != null) {
                    this.clientStopMoving(null);
                    actor.setTarget(target);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                // empty if block
            }
        }
        if (sk.hasEffectType(L2EffectType.HP, new L2EffectType[0])) {
            L2Attackable targets;
            Iterator<L2Character> leader;
            double percentage = actor.getCurrentHp() / (double)actor.getMaxHp() * 100.0;
            if (actor.isMinion() && sk.getTargetType() != TargetType.SELF && (leader = actor.getLeader()) != null && !((L2Character)((Object)leader)).isDead() && (double)Rnd.get((int)100) > ((L2Character)((Object)leader)).getCurrentHp() / (double)((L2Character)((Object)leader)).getMaxHp() * 100.0) {
                if (!(Util.checkIfInRange(sk.getCastRange() + actor.getTemplate().getCollisionRadius() + ((L2Character)((Object)leader)).getTemplate().getCollisionRadius(), actor, leader, false) || this.isParty(sk) || actor.isMovementDisabled())) {
                    this.moveToPawn((L2Object)((Object)leader), sk.getCastRange() + actor.getTemplate().getCollisionRadius() + ((L2Character)((Object)leader)).getTemplate().getCollisionRadius());
                }
                if (GeoData.getInstance().canSeeTarget((L2Object)actor, (L2Object)((Object)leader))) {
                    this.clientStopMoving(null);
                    actor.setTarget((L2Object)((Object)leader));
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            }
            if ((double)Rnd.get((int)100) < (100.0 - percentage) / 3.0) {
                this.clientStopMoving(null);
                actor.setTarget(actor);
                actor.doCast(sk);
                actor.setTarget(attackTarget);
                return true;
            }
            if (sk.getTargetType() == TargetType.ONE) {
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + actor.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable)) continue;
                    targets = (L2Attackable)obj;
                    if (obj.isDead() || !actor.isInMyClan(targets)) continue;
                    percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                    if (!((double)Rnd.get((int)100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)actor, targets)) continue;
                    this.clientStopMoving(null);
                    actor.setTarget(obj);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            }
            if (this.isParty(sk)) {
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange() + actor.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || !(targets = (L2Attackable)obj).isInMyClan(actor) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get((int)100) > 20) continue;
                    this.clientStopMoving(null);
                    actor.setTarget(actor);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            }
        }
        if (sk.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.MAGICAL_ATTACK, L2EffectType.HP_DRAIN)) {
            if (!this.canAura(sk)) {
                if (GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
                L2Character target2 = this.skillTargetReconsider(sk);
                if (target2 != null) {
                    this.clientStopMoving(null);
                    actor.setTarget(target2);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            } else {
                this.clientStopMoving(null);
                actor.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.SLEEP, new L2EffectType[0])) {
            if (sk.getTargetType() == TargetType.ONE) {
                if (!attackTarget.isDead() && dist2 <= srange && (dist2 > range || attackTarget.isMoving()) && !attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
                L2Character target3 = this.effectTargetReconsider(sk, false);
                if (target3 != null) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                // empty if block
            }
        }
        if (sk.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT, L2EffectType.MUTE, L2EffectType.FEAR)) {
            L2Character target4;
            if (GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
            } else if (!this.canAOE(sk) && sk.getTargetType() == TargetType.ONE && (target4 = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                actor.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.DMG_OVER_TIME, new L2EffectType[0])) {
            L2Character target5;
            if (GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    actor.doCast(sk);
                    return true;
                }
            } else if (!this.canAOE(sk) && sk.getTargetType() == TargetType.ONE && (target5 = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                actor.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.RESURRECTION, new L2EffectType[0])) {
            if (!this.isParty(sk)) {
                L2Attackable leader;
                if (actor.isMinion() && sk.getTargetType() != TargetType.SELF && (leader = actor.getLeader()) != null) {
                    if (leader.isDead() && !Util.checkIfInRange(sk.getCastRange() + actor.getTemplate().getCollisionRadius() + ((L2Character)leader).getTemplate().getCollisionRadius(), actor, leader, false) && !this.isParty(sk) && !actor.isMovementDisabled()) {
                        this.moveToPawn(leader, sk.getCastRange() + actor.getTemplate().getCollisionRadius() + ((L2Character)leader).getTemplate().getCollisionRadius());
                    }
                    if (GeoData.getInstance().canSeeTarget((L2Object)actor, leader)) {
                        this.clientStopMoving(null);
                        actor.setTarget(leader);
                        actor.doCast(sk);
                        actor.setTarget(attackTarget);
                        return true;
                    }
                }
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + actor.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable)) continue;
                    targets = (L2Attackable)obj;
                    if (!obj.isDead() || !actor.isInMyClan(targets) || Rnd.get((int)100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)actor, targets)) continue;
                    this.clientStopMoving(null);
                    actor.setTarget(obj);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            } else if (this.isParty(sk)) {
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange() + actor.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || !actor.isInMyClan(targets = (L2Attackable)obj) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get((int)100) > 20) continue;
                    this.clientStopMoving(null);
                    actor.setTarget(actor);
                    actor.doCast(sk);
                    actor.setTarget(attackTarget);
                    return true;
                }
            }
        }
        if (!this.canAura(sk)) {
            if (GeoData.getInstance().canSeeTarget((L2Object)actor, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                this.clientStopMoving(null);
                actor.doCast(sk);
                return true;
            }
            L2Character target6 = this.skillTargetReconsider(sk);
            if (target6 != null) {
                this.clientStopMoving(null);
                actor.setTarget(target6);
                actor.doCast(sk);
                actor.setTarget(attackTarget);
                return true;
            }
        } else {
            this.clientStopMoving(null);
            actor.doCast(sk);
            return true;
        }
        return false;
    }

    private void movementDisable() {
        L2Character target = this.getAttackTarget();
        if (target == null) {
            return;
        }
        L2Attackable actor = this.getActor();
        if (actor.getTarget() == null) {
            actor.setTarget(target);
        }
        double dist = actor.calculateDistance(target, false, false);
        int range = actor.getPhysicalAttackRange() + actor.getTemplate().getCollisionRadius() + target.getTemplate().getCollisionRadius();
        int random = Rnd.get((int)100);
        if (!target.isImmobilized() && random < 15 && this.tryCast(actor, target, AISkillScope.IMMOBILIZE, dist)) {
            return;
        }
        if (random < 20 && this.tryCast(actor, target, AISkillScope.COT, dist)) {
            return;
        }
        if (random < 30 && this.tryCast(actor, target, AISkillScope.DEBUFF, dist)) {
            return;
        }
        if (random < 40 && this.tryCast(actor, target, AISkillScope.NEGATIVE, dist)) {
            return;
        }
        if ((actor.isMovementDisabled() || actor.getAiType() == AIType.MAGE || actor.getAiType() == AIType.HEALER) && this.tryCast(actor, target, AISkillScope.ATTACK, dist)) {
            return;
        }
        if (this.tryCast(actor, target, AISkillScope.UNIVERSAL, dist)) {
            return;
        }
        if (dist <= (double)range && GeoData.getInstance().canSeeTarget((L2Object)actor, target)) {
            this._actor.doAttack(target);
            return;
        }
        this.targetReconsider();
    }

    private boolean tryCast(L2Attackable me, L2Character target, AISkillScope aiSkillScope, double dist) {
        for (Skill sk : me.getTemplate().getAISkills(aiSkillScope)) {
            if (!L2AttackableAI.checkSkillCastConditions(me, sk) || (double)(sk.getCastRange() + target.getTemplate().getCollisionRadius()) <= dist && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)me, target)) continue;
            this.clientStopMoving(null);
            me.doCast(sk);
            return true;
        }
        return false;
    }

    private static boolean checkSkillCastConditions(L2Attackable caster, Skill skill) {
        if (skill == null) {
            return false;
        }
        if (caster.isCastingNow() && !skill.isSimultaneousCast()) {
            return false;
        }
        if ((double)skill.getMpConsume2() >= caster.getCurrentMp()) {
            return false;
        }
        if (caster.isSkillDisabled(skill)) {
            return false;
        }
        return skill.isStatic() || (!skill.isMagic() || !caster.isMuted()) && !caster.isPhysicalMuted();
    }

    private L2Character effectTargetReconsider(Skill sk, boolean positive) {
        if (sk == null) {
            return null;
        }
        L2Attackable actor = this.getActor();
        if (!sk.hasEffectType(L2EffectType.DISPEL, new L2EffectType[0])) {
            if (!positive) {
                double dist2;
                double dist;
                int range = 0;
                for (L2Character creature : actor.getAttackByList()) {
                    block17: {
                        if (creature == null || creature.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, creature) || creature == this.getAttackTarget()) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist = actor.calculateDistance(creature, false, false);
                            dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                            range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + creature.getTemplate().getCollisionRadius();
                            if (!creature.isMoving()) break block17;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                    return creature;
                }
                for (L2Character creature : actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block18: {
                        if (creature.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, creature)) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist2 = dist = actor.calculateDistance(creature, false, false);
                            range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + creature.getTemplate().getCollisionRadius();
                            if (!creature.isMoving()) break block18;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(creature instanceof L2PcInstance) && !(creature instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                    return creature;
                }
            } else {
                int range = 0;
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                    double dist2;
                    block19: {
                        if (!(obj instanceof L2Attackable)) continue;
                        L2Attackable targets = (L2Attackable)obj;
                        if (obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || targets.isInMyClan(actor)) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            double dist = actor.calculateDistance(obj, false, false);
                            dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                            range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                            if (!obj.isMoving()) break block19;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || obj.isAffectedBySkill(sk.getId())) continue;
                    return obj;
                }
            }
        } else {
            int range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
            for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                double dist2;
                block20: {
                    if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                    try {
                        actor.setTarget(this.getAttackTarget());
                        double dist = actor.calculateDistance(obj, false, false);
                        dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                        range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                        if (!obj.isMoving()) break block20;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getEffectList().getFirstEffect(L2EffectType.BUFF) == null) continue;
                return obj;
            }
        }
        return null;
    }

    private L2Character skillTargetReconsider(Skill sk) {
        int range;
        double dist2;
        double dist;
        L2Attackable actor = this.getActor();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead()) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist = actor.calculateDistance(obj, false, false);
                    dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                    range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(dist2 <= (double)range)) continue;
                return obj;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            for (L2Object target : actor.getKnownList().getKnownObjects().values()) {
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist2 = dist = actor.calculateDistance(target, false, false);
                    range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(target instanceof L2Character)) continue;
                L2Character obj = (L2Character)target;
                if (!GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || dist2 > (double)range) continue;
                if (obj instanceof L2PcInstance) {
                    return obj;
                }
                if (obj instanceof L2Attackable) {
                    L2Attackable attackable = (L2Attackable)obj;
                    if (actor.isChaos()) {
                        if (attackable.isInMyClan(actor)) continue;
                        return obj;
                    }
                }
                if (!(obj instanceof L2Summon)) continue;
                return obj;
            }
        }
        return null;
    }

    private void targetReconsider() {
        L2Attackable actor = this.getActor();
        L2Character mostHated = actor.getMostHated();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                int range;
                double dist2;
                block8: {
                    if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != mostHated || obj == actor) continue;
                    try {
                        double dist = actor.calculateDistance(obj, false, false);
                        dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                        range = actor.getPhysicalAttackRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                        if (!obj.isMoving()) break block8;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(dist2 <= (double)range)) continue;
                actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            for (L2Object target : actor.getKnownList().getKnownObjects().values()) {
                if (!(target instanceof L2Character)) continue;
                L2Character obj = (L2Character)target;
                if (!GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != mostHated || obj == actor || obj == this.getAttackTarget()) continue;
                if (obj instanceof L2PcInstance) {
                    actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    L2Attackable attackable = (L2Attackable)obj;
                    if (!actor.isChaos() || attackable.isInMyClan(actor)) continue;
                    actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void aggroReconsider() {
        L2Attackable actor = this.getActor();
        L2Character mostHated = actor.getMostHated();
        if (actor.getHateList() != null) {
            int rand = Rnd.get((int)actor.getHateList().size());
            int count = 0;
            for (L2Character creature : actor.getHateList()) {
                if (count < rand) {
                    ++count;
                    continue;
                }
                if (creature == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, creature) || creature.isDead() || creature == this.getAttackTarget() || creature == actor) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (mostHated != null) {
                    actor.addDamageHate(creature, 0, actor.getHating(mostHated));
                } else {
                    actor.addDamageHate(creature, 0, 2000L);
                }
                actor.setTarget(creature);
                this.setAttackTarget(creature);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            for (L2Object target : actor.getKnownList().getKnownObjects().values()) {
                if (!(target instanceof L2Character)) continue;
                L2Character obj = (L2Character)target;
                if (!GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != mostHated || obj == actor) continue;
                if (obj instanceof L2PcInstance) {
                    actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    L2Attackable attackable = (L2Attackable)obj;
                    if (!actor.isChaos() || attackable.isInMyClan(actor)) continue;
                    actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                actor.addDamageHate(obj, 0, actor.getHating(mostHated));
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking) return;
        if (this.getActor().isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            switch (this.getIntention()) {
                case AI_INTENTION_ACTIVE: {
                    this.thinkActive();
                    return;
                }
                case AI_INTENTION_ATTACK: {
                    this.thinkAttack();
                    return;
                }
                case AI_INTENTION_CAST: {
                    this.thinkCast();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOG.warn("{}: {} - onEvtThink() for {} failed!", new Object[]{this.getClass().getSimpleName(), this, this.getIntention(), e});
            return;
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        L2Attackable actor = this.getActor();
        if (attacker == actor) {
            return;
        }
        this._attackTimeout = 1200 + GameTimeController.getInstance().getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        actor.addDamageHate(attacker, 0, 1L);
        if (!actor.isRunning()) {
            actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        } else if (actor.getMostHated() != this.getAttackTarget()) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
        if (actor instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)actor;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(actor, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(actor, attacker);
            }
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, long aggro) {
        L2Attackable actor = this.getActor();
        if (actor.isDead()) {
            return;
        }
        if (target != null) {
            actor.addDamageHate(target, 0, aggro);
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                if (!actor.isRunning()) {
                    actor.setRunning();
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
            }
            if (actor instanceof L2MonsterInstance) {
                L2MonsterInstance master = (L2MonsterInstance)actor;
                if (master.hasMinions()) {
                    master.getMinionList().onAssist(actor, target);
                }
                if ((master = master.getLeader()) != null && master.hasMinions()) {
                    master.getMinionList().onAssist(actor, target);
                }
            }
        }
    }

    @Override
    protected void onIntentionActive() {
        this._attackTimeout = Integer.MAX_VALUE;
        super.onIntentionActive();
    }

    public void setGlobalAggro(int value) {
        this._globalAggro = value;
    }

    @Override
    public final L2Attackable getActor() {
        return (L2Attackable)this._actor;
    }

    public int getFearTime() {
        return this._fearTime;
    }

    public void setFearTime(int fearTime) {
        this._fearTime = fearTime;
    }
}

