/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.bbs.repository.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.bbs.model.Forum;
import com.l2jserver.gameserver.bbs.model.ForumType;
import com.l2jserver.gameserver.bbs.model.ForumVisibility;
import com.l2jserver.gameserver.bbs.repository.ForumRepository;
import com.l2jserver.gameserver.bbs.service.ForumsBBSManager;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumRepositoryMySQLImpl
implements ForumRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ForumRepositoryMySQLImpl.class);
    private static final String SELECT_FORUMS = "SELECT forum_id, forum_name, forum_post, forum_type, forum_perm, forum_owner_id FROM forums WHERE forum_type = 0";
    private static final String SELECT_FORUM_CHILDREN = "SELECT forum_id, forum_name, forum_post, forum_type, forum_perm, forum_owner_id FROM forums WHERE forum_parent=?";
    private static final String INSERT_FORUM = "INSERT INTO forums (forum_name, forum_parent, forum_post, forum_type, forum_perm, forum_owner_id) VALUES (?,?,?,?,?,?)";

    @Override
    public Map<String, Forum> getForums() {
        HashMap<String, Forum> forums = new HashMap<String, Forum>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(SELECT_FORUMS);){
            while (rs.next()) {
                Forum forum = new Forum(rs.getInt("forum_id"), rs.getString("forum_name"), null, ForumType.values()[rs.getInt("forum_type")], ForumVisibility.values()[rs.getInt("forum_perm")], rs.getInt("forum_owner_id"));
                forums.put(forum.getName(), forum);
                DAOFactory.getInstance().getTopicRepository().load(forum);
                this.loadChildren(forum);
            }
        }
        catch (Exception ex) {
            LOG.warn("Data error on Forum (root)!", ex);
        }
        return forums;
    }

    private void loadChildren(Forum parent) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_FORUM_CHILDREN);){
            ps.setInt(1, parent.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ForumsBBSManager.getInstance().load(rs.getInt("forum_id"), rs.getString("forum_name"), parent, ForumType.values()[rs.getInt("forum_type")], ForumVisibility.values()[rs.getInt("forum_perm")], rs.getInt("forum_owner_id"));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Error loading child forums for forum Id {}!", (Object)parent.getId(), (Object)ex);
        }
    }

    @Override
    public void save(Forum forum) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_FORUM, 1);){
            ps.setString(1, forum.getName());
            ps.setInt(2, forum.getParent().getId());
            ps.setInt(3, forum.getPost());
            ps.setInt(4, forum.getType().ordinal());
            ps.setInt(5, forum.getVisibility().ordinal());
            ps.setInt(6, forum.getOwnerId());
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    forum.setId(rs.getInt(1));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error saving forum Id {} in database!", (Object)forum.getId(), (Object)ex);
        }
    }
}

