/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.bbs.repository.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.bbs.model.Forum;
import com.l2jserver.gameserver.bbs.model.Topic;
import com.l2jserver.gameserver.bbs.model.TopicType;
import com.l2jserver.gameserver.bbs.repository.TopicRepository;
import com.l2jserver.gameserver.bbs.service.TopicBBSManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicRepositoryMySQLImpl
implements TopicRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TopicRepositoryMySQLImpl.class);
    private static final String SELECT_TOPICS = "SELECT * FROM topic WHERE topic_forum_id=? ORDER BY topic_id DESC";
    private static final String DELETE_TOPIC = "DELETE FROM topic WHERE topic_id=? AND topic_forum_id=?";
    private static final String INSERT_TOPIC = "INSERT INTO topic (topic_id,topic_forum_id,topic_name,topic_date,topic_ownername,topic_ownerid,topic_type,topic_reply) values (?,?,?,?,?,?,?,?)";

    @Override
    public void load(Forum forum) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_TOPICS);){
            ps.setInt(1, forum.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Topic topic = new Topic(rs.getInt("topic_id"), rs.getInt("topic_forum_id"), rs.getString("topic_name"), rs.getLong("topic_date"), rs.getString("topic_ownername"), rs.getInt("topic_ownerid"), TopicType.values()[rs.getInt("topic_type")], rs.getInt("topic_reply"));
                    TopicBBSManager.getInstance().addTopic(topic);
                    forum.getTopics().put(topic.getId(), topic);
                    if (topic.getId() <= TopicBBSManager.getInstance().getMaxId(forum)) continue;
                    TopicBBSManager.getInstance().setMaxId(topic.getId(), forum);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not get from database topics for forum Id {}!", (Object)forum.getId(), (Object)ex);
        }
    }

    @Override
    public void save(Topic topic) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_TOPIC);){
            ps.setInt(1, topic.getId());
            ps.setInt(2, topic.getForumId());
            ps.setString(3, topic.getName());
            ps.setLong(4, topic.getDate());
            ps.setString(5, topic.getOwnerName());
            ps.setInt(6, topic.getOwnerId());
            ps.setInt(7, topic.getType().ordinal());
            ps.setInt(8, topic.getReply());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error while saving new Topic to database!", e);
        }
    }

    @Override
    public void delete(Topic topic, Forum forum) {
        TopicBBSManager.getInstance().delTopic(topic);
        forum.removeTopic(topic.getId());
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_TOPIC);){
            ps.setInt(1, topic.getId());
            ps.setInt(2, forum.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error while deleting topic ID {} from database!", (Object)topic.getId(), (Object)e);
        }
    }
}

