/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.config;

import com.l2jserver.gameserver.GameServer;
import com.l2jserver.gameserver.util.IXmlReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IPConfigData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(IPConfigData.class);
    private static final String IP_CONFIG_FILE = "./config/ipconfig.xml";
    private final List<String> _subnets = new ArrayList<String>(5);
    private final List<String> _hosts = new ArrayList<String>(5);

    public IPConfigData() {
        this.load();
    }

    @Override
    public void load() {
        GameServer.startTimedSection("Network Configuration");
        File f = new File(IP_CONFIG_FILE);
        if (f.exists()) {
            LOG.info("Using existing ipconfig.xml.");
            this.parseFile(new File(IP_CONFIG_FILE));
        } else {
            LOG.info("Using automatic network configuration.");
            this.autoIpConfig();
        }
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"gameserver".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"define".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                this._subnets.add(attrs.getNamedItem("subnet").getNodeValue());
                this._hosts.add(attrs.getNamedItem("address").getNodeValue());
                if (this._hosts.size() == this._subnets.size()) continue;
                LOG.warn("Failed to load {} file - subnets does not match server addresses.", (Object)IP_CONFIG_FILE);
            }
            Node att = n.getAttributes().getNamedItem("address");
            if (att == null) {
                LOG.warn("Failed to load {} file - default server address is missing.", (Object)IP_CONFIG_FILE);
                this._hosts.add("127.0.0.1");
            } else {
                this._hosts.add(att.getNodeValue());
            }
            this._subnets.add("0.0.0.0/0");
        }
    }

    protected void autoIpConfig() {
        String externalIp;
        try {
            URL autoIp = URI.create("http://ip1.dynupdate.no-ip.com:8245/").toURL();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(autoIp.openStream()));){
                externalIp = in.readLine();
            }
        }
        catch (IOException ex) {
            LOG.warn("Failed to connect to ip1.dynupdate.no-ip.com:8245 please check your internet connection using 127.0.0.1!");
            externalIp = "127.0.0.1";
        }
        try {
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            while (niList.hasMoreElements()) {
                NetworkInterface ni = niList.nextElement();
                if (!ni.isUp() || ni.isVirtual() || !ni.isLoopback() && (ni.getHardwareAddress() == null || ni.getHardwareAddress().length != 6)) continue;
                for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                    if (ia.getAddress() instanceof Inet6Address) continue;
                    String hostAddress = ia.getAddress().getHostAddress();
                    short subnetPrefixLength = ia.getNetworkPrefixLength();
                    int subnetMaskInt = IntStream.rangeClosed(1, subnetPrefixLength).reduce((r, e) -> (r << 1) + 1).orElse(0) << 32 - subnetPrefixLength;
                    int hostAddressInt = Arrays.stream(hostAddress.split("\\.")).mapToInt(Integer::parseInt).reduce((r, e) -> (r << 8) + e).orElse(0);
                    int subnetAddressInt = hostAddressInt & subnetMaskInt;
                    String subnetAddress = (subnetAddressInt >> 24 & 0xFF) + "." + (subnetAddressInt >> 16 & 0xFF) + "." + (subnetAddressInt >> 8 & 0xFF) + "." + (subnetAddressInt & 0xFF);
                    String subnet = subnetAddress + "/" + subnetPrefixLength;
                    if (this._subnets.contains(subnet) || subnet.equals("0.0.0.0/0")) continue;
                    this._subnets.add(subnet);
                    this._hosts.add(hostAddress);
                    LOG.info("Adding new subnet: " + subnet + " address: " + hostAddress);
                }
            }
            this._hosts.add(externalIp);
            this._subnets.add("0.0.0.0/0");
            LOG.info("Adding new subnet: 0.0.0.0/0 address: {}", (Object)externalIp);
        }
        catch (SocketException e2) {
            LOG.error("Configuration failed please manually configure ipconfig.xml", e2);
            System.exit(0);
        }
    }

    public List<String> getSubnets() {
        if (this._subnets.isEmpty()) {
            return List.of("0.0.0.0/0");
        }
        return this._subnets;
    }

    public List<String> getHosts() {
        if (this._hosts.isEmpty()) {
            return List.of("127.0.0.1");
        }
        return this._hosts;
    }
}

