/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.config;

import com.l2jserver.gameserver.config.converter.MapIntegerFloatConverter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Reloadable;

@Config.Sources(value={"file:${L2J_HOME}/custom/game/config/rates.properties", "file:./config/rates.properties", "classpath:config/rates.properties"})
@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.HotReload(value=20L, unit=TimeUnit.MINUTES, type=Config.HotReloadType.ASYNC)
public interface RatesConfiguration
extends Reloadable {
    @Config.Key(value="DeathDropAmountMultiplier")
    public double getDeathDropAmountMultiplier();

    @Config.Key(value="CorpseDropAmountMultiplier")
    public double getCorpseDropAmountMultiplier();

    @Config.Key(value="HerbDropAmountMultiplier")
    public double getHerbDropAmountMultiplier();

    @Config.Key(value="RaidDropAmountMultiplier")
    public double getRaidDropAmountMultiplier();

    @Config.Key(value="DeathDropChanceMultiplier")
    public double getDeathDropChanceMultiplier();

    @Config.Key(value="CorpseDropChanceMultiplier")
    public double getCorpseDropChanceMultiplier();

    @Config.Key(value="HerbDropChanceMultiplier")
    public double getHerbDropChanceMultiplier();

    @Config.Key(value="RaidDropChanceMultiplier")
    public double getRaidDropChanceMultiplier();

    @Config.Key(value="DropAmountMultiplierByItemId")
    @Config.ConverterClass(value=MapIntegerFloatConverter.class)
    public Map<Integer, Float> getDropAmountMultiplierByItemId();

    @Config.Key(value="DropChanceMultiplierByItemId")
    @Config.ConverterClass(value=MapIntegerFloatConverter.class)
    public Map<Integer, Float> getDropChanceMultiplierByItemId();

    @Config.Key(value="RateXp")
    public float getRateXp();

    @Config.Key(value="RateSp")
    public float getRateSp();

    @Config.Key(value="RatePartyXp")
    public float getRatePartyXp();

    @Config.Key(value="RatePartySp")
    public float getRatePartySp();

    @Config.Key(value="RateDropManor")
    public int getRateDropManor();

    @Config.Key(value="RateKarmaLost")
    public double getRateKarmaLost();

    @Config.Key(value="RateKarmaExpLost")
    public double getRateKarmaExpLost();

    @Config.Key(value="RateSiegeGuardsPrice")
    public double getRateSiegeGuardsPrice();

    @Config.Key(value="RateExtractable")
    public float getRateExtractable();

    @Config.Key(value="RateHellboundTrustIncrease")
    public float getRateHellboundTrustIncrease();

    @Config.Key(value="RateHellboundTrustDecrease")
    public float getRateHellboundTrustDecrease();

    @Config.Key(value="QuestDropChanceMultiplier")
    public float getQuestDropChanceMultiplier();

    @Config.Key(value="QuestDropAmountMultiplier")
    public float getQuestDropAmountMultiplier();

    @Config.Key(value="RateQuestRewardXP")
    public float getRateQuestRewardXP();

    @Config.Key(value="RateQuestRewardSP")
    public float getRateQuestRewardSP();

    @Config.Key(value="RateQuestRewardAdena")
    public float getRateQuestRewardAdena();

    @Config.Key(value="UseQuestRewardMultipliers")
    public boolean useQuestRewardMultipliers();

    @Config.Key(value="RateQuestReward")
    public float getRateQuestReward();

    @Config.Key(value="RateQuestRewardPotion")
    public float getRateQuestRewardPotion();

    @Config.Key(value="RateQuestRewardScroll")
    public float getRateQuestRewardScroll();

    @Config.Key(value="RateQuestRewardRecipe")
    public float getRateQuestRewardRecipe();

    @Config.Key(value="RateQuestRewardMaterial")
    public float getRateQuestRewardMaterial();

    @Config.Key(value="PlayerDropLimit")
    public int getPlayerDropLimit();

    @Config.Key(value="PlayerRateDrop")
    public int getPlayerRateDrop();

    @Config.Key(value="PlayerRateDropItem")
    public int getPlayerRateDropItem();

    @Config.Key(value="PlayerRateDropEquip")
    public int getPlayerRateDropEquip();

    @Config.Key(value="PlayerRateDropEquipWeapon")
    public int getPlayerRateDropEquipWeapon();

    @Config.Key(value="KarmaDropLimit")
    public int getKarmaDropLimit();

    @Config.Key(value="KarmaRateDrop")
    public int getKarmaRateDrop();

    @Config.Key(value="KarmaRateDropItem")
    public int getKarmaRateDropItem();

    @Config.Key(value="KarmaRateDropEquip")
    public int getKarmaRateDropEquip();

    @Config.Key(value="KarmaRateDropEquipWeapon")
    public int getKarmaRateDropEquipWeapon();

    @Config.Key(value="PetXpRate")
    public double getPetXpRate();

    @Config.Key(value="PetFoodRate")
    public int getPetFoodRate();

    @Config.Key(value="SinEaterXpRate")
    public double getSinEaterXpRate();
}

