/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.FriendDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FriendDAOMySQLImpl
implements FriendDAO {
    private static final Logger LOG = LoggerFactory.getLogger(FriendDAOMySQLImpl.class);
    private static final String SELECT = "SELECT friendId FROM character_friends WHERE charId=? AND relation=0 AND friendId<>charId";

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    player.addFriend(rs.getInt("friendId"));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error found in {} FriendList: ", (Object)player, (Object)e);
        }
    }
}

