/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.ItemDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDAOMySQLImpl
implements ItemDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ItemDAOMySQLImpl.class);
    private static final String SELECT = "SELECT object_id FROM `items` WHERE `owner_id`=? AND (`loc`='PET' OR `loc`='PET_EQUIP') LIMIT 1;";

    @Override
    public void loadPetInventory(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                player.setPetInvItems(rs.next() && rs.getInt("object_id") > 0);
            }
        }
        catch (Exception e) {
            LOG.error("Could not check Items in Pet Inventory for {}, {}", (Object)player, (Object)e);
        }
    }
}

