/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.PetDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetDAOMySQLImpl
implements PetDAO {
    private static final Logger LOG = LoggerFactory.getLogger(PetDAOMySQLImpl.class);
    private static final String SELECT = "SELECT item_obj_id, name, level, curHp, curMp, exp, sp, fed FROM pets WHERE item_obj_id=?";
    private static final String UPDATE_FOOD = "UPDATE pets SET fed=? WHERE item_obj_id=?";
    private static final String DELETE = "DELETE FROM pets WHERE item_obj_id=?";
    private static final String INSERT = "INSERT INTO pets (name,level,curHp,curMp,exp,sp,fed,ownerId,restore,item_obj_id) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "UPDATE pets SET name=?,level=?,curHp=?,curMp=?,exp=?,sp=?,fed=?,ownerId=?,restore=? WHERE item_obj_id=?";

    @Override
    public void updateFood(L2PcInstance player, int petId) {
        if (player.getControlItemId() != 0 && petId != 0) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(UPDATE_FOOD);){
                ps.setInt(1, player.getCurrentFeed());
                ps.setInt(2, player.getControlItemId());
                ps.executeUpdate();
                player.setControlItemId(0);
            }
            catch (Exception e) {
                LOG.error("Failed to store Pet [NpcId: {}] data {}", (Object)petId, (Object)e);
            }
        }
    }

    @Override
    public void delete(L2PetInstance pet) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, pet.getControlObjectId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Failed to delete pet {}!", (Object)pet, (Object)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public L2PetInstance load(L2ItemInstance control, L2NpcTemplate template, L2PcInstance owner) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void insert(L2PetInstance pet) {
        PetDAOMySQLImpl.insertOrUpdate(pet, INSERT);
    }

    @Override
    public void update(L2PetInstance pet) {
        PetDAOMySQLImpl.insertOrUpdate(pet, UPDATE);
    }

    private static void insertOrUpdate(L2PetInstance pet, String query) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setString(1, pet.getName());
            ps.setInt(2, pet.getLevel());
            ps.setDouble(3, pet.getStatus().getCurrentHp());
            ps.setDouble(4, pet.getStatus().getCurrentMp());
            ps.setLong(5, pet.getExp());
            ps.setInt(6, pet.getSp());
            ps.setInt(7, pet.getCurrentFed());
            ps.setInt(8, pet.getOwner().getObjectId());
            ps.setBoolean(9, pet.isRestoreSummon());
            ps.setInt(10, pet.getControlObjectId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.error("Failed to store pet {} data!", (Object)pet, (Object)e);
        }
    }
}

