/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.PremiumItemDAO;
import com.l2jserver.gameserver.model.L2PremiumItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PremiumItemDAOMySQLImpl
implements PremiumItemDAO {
    private static final Logger LOG = LoggerFactory.getLogger(PremiumItemDAOMySQLImpl.class);
    private static final String GET_PREMIUM_ITEMS = "SELECT itemNum, itemId, itemCount, itemSender FROM character_premium_items WHERE charId=?";

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(GET_PREMIUM_ITEMS);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int itemNum = rs.getInt("itemNum");
                    int itemId = rs.getInt("itemId");
                    long itemCount = rs.getLong("itemCount");
                    String itemSender = rs.getString("itemSender");
                    player.getPremiumItemList().put(itemNum, new L2PremiumItem(itemId, itemCount, itemSender));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Could not restore premium items!", ex);
        }
    }

    @Override
    public void update(L2PcInstance player, int itemNum, long newCount) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE character_premium_items SET itemCount=? WHERE charId=? AND itemNum=? ");){
            ps.setLong(1, newCount);
            ps.setInt(2, player.getObjectId());
            ps.setInt(3, itemNum);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Could not update premium items!", ex);
        }
    }

    @Override
    public void delete(L2PcInstance player, int itemNum) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_premium_items WHERE charId=? AND itemNum=? ");){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, itemNum);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Could not delete premium item!" + String.valueOf(ex));
        }
    }
}

