/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.RecipeBookDAO;
import com.l2jserver.gameserver.data.xml.impl.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeBookDAOMySQLImpl
implements RecipeBookDAO {
    private static final Logger LOG = LoggerFactory.getLogger(RecipeBookDAOMySQLImpl.class);
    private static final String INSERT = "INSERT INTO character_recipebook (charId, id, classIndex, type) values(?,?,?,?)";
    private static final String DELETE = "DELETE FROM character_recipebook WHERE charId=? AND id=? AND classIndex=?";
    private static final String SELECT_COMMON = "SELECT id, type, classIndex FROM character_recipebook WHERE charId=?";
    private static final String SELECT = "SELECT id FROM character_recipebook WHERE charId=? AND classIndex=? AND type = 1";

    @Override
    public void insert(L2PcInstance player, int recipeId, boolean isDwarf) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, recipeId);
            ps.setInt(3, isDwarf ? player.getClassIndex() : 0);
            ps.setInt(4, isDwarf ? 1 : 0);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("Error inserting recipe Id {} from player {}!", recipeId, player, ex);
        }
    }

    @Override
    public void delete(L2PcInstance player, int recipeId, boolean isDwarf) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, recipeId);
            ps.setInt(3, isDwarf ? player.getClassIndex() : 0);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("Error deleting recipe Id {} from player {}!", recipeId, player, ex);
        }
    }

    @Override
    public void load(L2PcInstance player, boolean loadCommon) {
        String sql = loadCommon ? SELECT_COMMON : SELECT;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(sql);){
            ps.setInt(1, player.getObjectId());
            if (!loadCommon) {
                ps.setInt(2, player.getClassIndex());
            }
            try (ResultSet rs = ps.executeQuery();){
                player.getDwarvenRecipeBookClear();
                RecipeData rd = RecipeData.getInstance();
                while (rs.next()) {
                    L2RecipeList recipe = rd.getRecipeList(rs.getInt("id"));
                    if (loadCommon) {
                        if (rs.getInt(2) == 1) {
                            if (rs.getInt(3) != player.getClassIndex()) continue;
                            player.registerDwarvenRecipeList(recipe, false);
                            continue;
                        }
                        player.registerCommonRecipeList(recipe, false);
                        continue;
                    }
                    player.registerDwarvenRecipeList(recipe, false);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Could not restore recipe book data!", ex);
        }
    }
}

