/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.RecommendationBonusDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendationBonusDAOMySQLImpl
implements RecommendationBonusDAO {
    private static final Logger LOG = LoggerFactory.getLogger(RecommendationBonusDAOMySQLImpl.class);
    private static final String SELECT = "SELECT rec_have,rec_left,time_left FROM character_reco_bonus WHERE charId=? LIMIT 1";
    private static final String INSERT = "INSERT INTO character_reco_bonus (charId,rec_have,rec_left,time_left) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE rec_have=?, rec_left=?, time_left=?";

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    player.getRecSystem().setHave(rs.getInt("rec_have"));
                    player.getRecSystem().setLeft(rs.getInt("rec_left"));
                    player.getRecSystem().setBonusTime(rs.getInt("time_left"));
                } else {
                    player.getRecSystem().setBonusTime(3600);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not restore Recommendations for {}, {}", (Object)player, (Object)e);
        }
    }

    @Override
    public void insert(L2PcInstance player, int recomTime) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, player.getRecSystem().getHave());
            ps.setInt(3, player.getRecSystem().getLeft());
            ps.setLong(4, recomTime);
            ps.setInt(5, player.getRecSystem().getHave());
            ps.setInt(6, player.getRecSystem().getLeft());
            ps.setLong(7, recomTime);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Could not update Recommendations for player: {}", (Object)player, (Object)e);
        }
    }
}

