/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.ServitorSkillSaveDAO;
import com.l2jserver.gameserver.data.sql.impl.SummonEffectsTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServitorSkillSaveDAOMySQLImpl
implements ServitorSkillSaveDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ServitorSkillSaveDAOMySQLImpl.class);
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_summon_skills_save (ownerId,ownerClassIndex,summonSkillId,skill_id,skill_level,remaining_time,buff_index) VALUES (?,?,?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT skill_id,skill_level,remaining_time,buff_index FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=? ORDER BY buff_index";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=?";

    @Override
    public void insert(L2ServitorInstance servitor, boolean storeEffects) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE_SKILL_SAVE);){
            con.setAutoCommit(false);
            ps.setInt(1, servitor.getOwner().getObjectId());
            ps.setInt(2, servitor.getOwner().getClassIndex());
            ps.setInt(3, servitor.getReferenceSkill());
            ps.execute();
            int buff_index = 0;
            LinkedList<Integer> storedSkills = new LinkedList<Integer>();
            if (storeEffects) {
                try (PreparedStatement ps2 = con.prepareStatement(ADD_SKILL_SAVE);){
                    for (BuffInfo info : servitor.getEffectList().getEffects()) {
                        Skill skill;
                        if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Configuration.character().storeDances() || storedSkills.contains(skill.getReuseHashCode())) continue;
                        storedSkills.add(skill.getReuseHashCode());
                        ps2.setInt(1, servitor.getOwner().getObjectId());
                        ps2.setInt(2, servitor.getOwner().getClassIndex());
                        ps2.setInt(3, servitor.getReferenceSkill());
                        ps2.setInt(4, skill.getId());
                        ps2.setInt(5, skill.getLevel());
                        ps2.setInt(6, info.getTime());
                        ps2.setInt(7, ++buff_index);
                        ps2.addBatch();
                        SummonEffectsTable.getInstance().addServitorEffect(servitor.getOwner(), servitor.getReferenceSkill(), skill, info.getTime());
                    }
                    ps2.executeBatch();
                }
            }
            con.commit();
        }
        catch (Exception e) {
            LOG.error("Could not store summon effect data for owner {},  class index {}, skill {}!", servitor.getOwner().getObjectId(), servitor.getOwner().getClassIndex(), servitor.getReferenceSkill(), e);
        }
    }

    @Override
    public void load(L2ServitorInstance servitor) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            PreparedStatement ps;
            if (!SummonEffectsTable.getInstance().containsSkill(servitor.getOwner(), servitor.getReferenceSkill())) {
                ps = con.prepareStatement(RESTORE_SKILL_SAVE);
                try {
                    ps.setInt(1, servitor.getOwner().getObjectId());
                    ps.setInt(2, servitor.getOwner().getClassIndex());
                    ps.setInt(3, servitor.getReferenceSkill());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            int effectCurTime = rs.getInt("remaining_time");
                            Skill skill = SkillData.getInstance().getSkill(rs.getInt("skill_id"), rs.getInt("skill_level"));
                            if (skill == null || !skill.hasEffects(EffectScope.GENERAL)) continue;
                            SummonEffectsTable.getInstance().addServitorEffect(servitor.getOwner(), servitor.getReferenceSkill(), skill, effectCurTime);
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            ps = con.prepareStatement(DELETE_SKILL_SAVE);
            try {
                ps.setInt(1, servitor.getOwner().getObjectId());
                ps.setInt(2, servitor.getOwner().getClassIndex());
                ps.setInt(3, servitor.getReferenceSkill());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not restore {} active effect data!", (Object)servitor, (Object)e);
        }
    }
}

