/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.ShortcutDAO;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutDAOMySQLImpl
implements ShortcutDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ShortcutDAOMySQLImpl.class);
    private static final String DELETE = "DELETE FROM character_shortcuts WHERE charId=? AND class_index=?";

    @Override
    public boolean delete(L2PcInstance player, int classIndex) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, classIndex);
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Could not modify sub class for {} to class index {}, {}", player, classIndex, e);
            return false;
        }
        return true;
    }
}

