/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SummonEffectsTable {
    private final Map<Integer, Map<Integer, Map<Integer, Map<Integer, SummonEffect>>>> _servitorEffects = new HashMap<Integer, Map<Integer, Map<Integer, Map<Integer, SummonEffect>>>>();
    private final Map<Integer, Map<Integer, SummonEffect>> _petEffects = new HashMap<Integer, Map<Integer, SummonEffect>>();

    private Map<Integer, Map<Integer, SummonEffect>> getServitorEffects(L2PcInstance owner) {
        Map<Integer, Map<Integer, Map<Integer, SummonEffect>>> servitorMap = this._servitorEffects.get(owner.getObjectId());
        if (servitorMap == null) {
            return null;
        }
        return servitorMap.get(owner.getClassIndex());
    }

    private Map<Integer, SummonEffect> getServitorEffects(L2PcInstance owner, int referenceSkill) {
        return this.containsOwner(owner) ? this.getServitorEffects(owner).get(referenceSkill) : null;
    }

    private boolean containsOwner(L2PcInstance owner) {
        return this._servitorEffects.getOrDefault(owner.getObjectId(), Collections.emptyMap()).containsKey(owner.getClassIndex());
    }

    private void removeEffects(Map<Integer, SummonEffect> map, int skillId) {
        if (map != null) {
            map.remove(skillId);
        }
    }

    private void applyEffects(L2Summon summon, Map<Integer, SummonEffect> map) {
        if (map == null) {
            return;
        }
        for (SummonEffect se : map.values()) {
            if (se == null) continue;
            se.getSkill().applyEffects(summon, summon, false, se.getEffectCurTime());
        }
    }

    public boolean containsSkill(L2PcInstance owner, int referenceSkill) {
        return this.containsOwner(owner) && this.getServitorEffects(owner).containsKey(referenceSkill);
    }

    public void clearServitorEffects(L2PcInstance owner, int referenceSkill) {
        if (this.containsOwner(owner)) {
            this.getServitorEffects(owner).getOrDefault(referenceSkill, Collections.emptyMap()).clear();
        }
    }

    public void addServitorEffect(L2PcInstance owner, int referenceSkill, Skill skill, int effectCurTime) {
        this._servitorEffects.putIfAbsent(owner.getObjectId(), new HashMap());
        this._servitorEffects.get(owner.getObjectId()).putIfAbsent(owner.getClassIndex(), new HashMap());
        this.getServitorEffects(owner).putIfAbsent(referenceSkill, new ConcurrentHashMap());
        this.getServitorEffects(owner).get(referenceSkill).put(skill.getId(), new SummonEffect(skill, effectCurTime));
    }

    public void removeServitorEffects(L2PcInstance owner, int referenceSkill, int skillId) {
        this.removeEffects(this.getServitorEffects(owner, referenceSkill), skillId);
    }

    public void applyServitorEffects(L2ServitorInstance servitor, L2PcInstance owner, int referenceSkill) {
        this.applyEffects(servitor, this.getServitorEffects(owner, referenceSkill));
    }

    public void addPetEffect(int controlObjectId, Skill skill, int effectCurTime) {
        this._petEffects.computeIfAbsent(controlObjectId, k -> new ConcurrentHashMap()).put(skill.getId(), new SummonEffect(skill, effectCurTime));
    }

    public boolean containsPetId(int controlObjectId) {
        return this._petEffects.containsKey(controlObjectId);
    }

    public void applyPetEffects(L2PetInstance l2PetInstance, int controlObjectId) {
        this.applyEffects(l2PetInstance, this._petEffects.get(controlObjectId));
    }

    public void clearPetEffects(int controlObjectId) {
        Map<Integer, SummonEffect> effects = this._petEffects.get(controlObjectId);
        if (effects != null) {
            effects.clear();
        }
    }

    public void removePetEffects(int controlObjectId, int skillId) {
        this.removeEffects(this._petEffects.get(controlObjectId), skillId);
    }

    public static SummonEffectsTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SummonEffect {
        Skill _skill;
        int _effectCurTime;

        public SummonEffect(Skill skill, int effectCurTime) {
            this._skill = skill;
            this._effectCurTime = effectCurTime;
        }

        public Skill getSkill() {
            return this._skill;
        }

        public int getEffectCurTime() {
            return this._effectCurTime;
        }
    }

    private static class SingletonHolder {
        protected static final SummonEffectsTable INSTANCE = new SummonEffectsTable();

        private SingletonHolder() {
        }
    }
}

