/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2Territory;
import com.l2jserver.gameserver.model.Location;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerritoryTable {
    private static final Logger LOG = LoggerFactory.getLogger(TerritoryTable.class);
    private static final Map<Integer, L2Territory> _territory = new HashMap<Integer, L2Territory>();

    protected TerritoryTable() {
        this.load();
    }

    public Location getRandomPoint(int terr) {
        return _territory.get(terr).getRandomPoint();
    }

    public int getProcMax(int terr) {
        return _territory.get(terr).getProcMax();
    }

    public void load() {
        _territory.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM locations WHERE loc_id>0");){
            while (rs.next()) {
                int terrId = rs.getInt("loc_id");
                L2Territory terr = _territory.get(terrId);
                if (terr == null) {
                    terr = new L2Territory(terrId);
                    _territory.put(terrId, terr);
                }
                terr.add(rs.getInt("loc_x"), rs.getInt("loc_y"), rs.getInt("loc_zmin"), rs.getInt("loc_zmax"), rs.getInt("proc"));
            }
            LOG.info("Loaded {} territories from database.", (Object)_territory.size());
        }
        catch (Exception ex) {
            LOG.error("Failed to load territories from database!", ex);
        }
    }

    public static TerritoryTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final TerritoryTable INSTANCE = new TerritoryTable();

        private SingletonHolder() {
        }
    }
}

