/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.enchant.AbstractEnchantItem;
import com.l2jserver.gameserver.model.items.enchant.EnchantScroll;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantItemData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantItemData.class);
    private final Map<Integer, EnchantScroll> _scrolls = new HashMap<Integer, EnchantScroll>();
    private final Map<Integer, EnchantSupportItem> _supports = new HashMap<Integer, EnchantSupportItem>();

    public EnchantItemData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._scrolls.clear();
        this._supports.clear();
        this.parseDatapackFile("data/enchantItemData.xml");
        LOG.info("Loaded {} enchant scrolls.", (Object)this._scrolls.size());
        LOG.info("Loaded {} support items.", (Object)this._supports.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                AbstractEnchantItem item;
                Node att;
                StatsSet set;
                NamedNodeMap attrs;
                if ("enchant".equalsIgnoreCase(d.getNodeName())) {
                    attrs = d.getAttributes();
                    set = new StatsSet();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    try {
                        item = new EnchantScroll(set);
                        for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"item".equalsIgnoreCase(cd.getNodeName())) continue;
                            ((EnchantScroll)item).addItem(this.parseInteger(cd.getAttributes(), "id"));
                        }
                        this._scrolls.put(item.getId(), (EnchantScroll)item);
                    }
                    catch (NullPointerException e) {
                        LOG.warn("Nonexistent enchant scroll: {} defined in enchant data!", (Object)set.getString("id"));
                    }
                    catch (IllegalAccessError e) {
                        LOG.warn("Wrong enchant scroll item type: {} defined in enchant data!", (Object)set.getString("id"));
                    }
                    continue;
                }
                if (!"support".equalsIgnoreCase(d.getNodeName())) continue;
                attrs = d.getAttributes();
                set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                try {
                    item = new EnchantSupportItem(set);
                    this._supports.put(item.getId(), (EnchantSupportItem)item);
                    continue;
                }
                catch (NullPointerException e) {
                    LOG.warn("Nonexistent enchant support item: {} defined in enchant data!", (Object)set.getString("id"));
                    continue;
                }
                catch (IllegalAccessError e) {
                    LOG.warn("Wrong enchant support item type: {} defined in enchant data!", (Object)set.getString("id"));
                }
            }
        }
    }

    public final EnchantScroll getEnchantScroll(L2ItemInstance scroll) {
        return this._scrolls.get(scroll.getId());
    }

    public final EnchantSupportItem getSupportItem(L2ItemInstance item) {
        return this._supports.get(item.getId());
    }

    public static EnchantItemData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemData _instance = new EnchantItemData();

        private SingletonHolder() {
        }
    }
}

