/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KarmaData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(KarmaData.class);
    private final Map<Integer, Double> _karmaTable = new HashMap<Integer, Double>();

    public KarmaData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._karmaTable.clear();
        this.parseDatapackFile("data/stats/chars/pcKarmaIncrease.xml");
        LOG.info("Loaded {} karma modifiers.", (Object)this._karmaTable.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"pcKarmaIncrease".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"increase".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                this._karmaTable.put(this.parseInteger(attrs, "lvl"), this.parseDouble(attrs, "val"));
            }
        }
    }

    public double getMultiplier(int level) {
        return this._karmaTable.get(level);
    }

    public static KarmaData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final KarmaData INSTANCE = new KarmaData();

        private SingletonHolder() {
        }
    }
}

