/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.holders.MinionHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NpcData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(NpcData.class);
    private final Map<Integer, L2NpcTemplate> _npcs = new ConcurrentHashMap<Integer, L2NpcTemplate>();
    private final Map<String, Integer> _clans = new ConcurrentHashMap<String, Integer>();
    private MinionData _minionData;

    protected NpcData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._minionData = new MinionData();
        this.parseDatapackDirectory("data/stats/npcs", false);
        LOG.info("Loaded {} NPCs.", (Object)this._npcs.size());
        if (Configuration.general().customNpcData()) {
            int npcCount = this._npcs.size();
            this.parseDatapackDirectory("data/stats/npcs/custom", true);
            LOG.info("Loaded {} custom NPCs.", (Object)(this._npcs.size() - npcCount));
        }
        this._minionData = null;
    }

    @Override
    public void parseDocument(Document doc, File f) {
        for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node listNode = node.getFirstChild(); listNode != null; listNode = listNode.getNextSibling()) {
                if (!"npc".equalsIgnoreCase(listNode.getNodeName())) continue;
                NamedNodeMap attrs = listNode.getAttributes();
                StatsSet set = new StatsSet();
                int npcId = this.parseInteger(attrs, "id");
                HashMap<String, Object> parameters = null;
                HashMap<Integer, Skill> skills = null;
                HashSet<Integer> clans = null;
                HashSet<Integer> ignoreClanNpcIds = null;
                EnumMap<DropListScope, List<IDropItem>> dropLists = null;
                set.set("id", npcId);
                set.set("displayId", this.parseInteger(attrs, "displayId"));
                set.set("level", this.parseByte(attrs, "level"));
                set.set("type", this.parseString(attrs, "type"));
                set.set("name", this.parseString(attrs, "name"));
                set.set("usingServerSideName", this.parseBoolean(attrs, "usingServerSideName"));
                set.set("title", this.parseString(attrs, "title"));
                set.set("usingServerSideTitle", this.parseBoolean(attrs, "usingServerSideTitle"));
                block119: for (Node npcNode = listNode.getFirstChild(); npcNode != null; npcNode = npcNode.getNextSibling()) {
                    attrs = npcNode.getAttributes();
                    switch (npcNode.getNodeName().toLowerCase()) {
                        case "parameters": {
                            if (parameters == null) {
                                parameters = new HashMap<String, Object>();
                            }
                            block120: for (Node parametersNode = npcNode.getFirstChild(); parametersNode != null; parametersNode = parametersNode.getNextSibling()) {
                                attrs = parametersNode.getAttributes();
                                switch (parametersNode.getNodeName().toLowerCase()) {
                                    case "param": {
                                        parameters.put(this.parseString(attrs, "name"), this.parseString(attrs, "value"));
                                        continue block120;
                                    }
                                    case "skill": {
                                        parameters.put(this.parseString(attrs, "name"), new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "level")));
                                        continue block120;
                                    }
                                    case "minions": {
                                        ArrayList<MinionHolder> minions = new ArrayList<MinionHolder>(1);
                                        for (Object minionsNode = parametersNode.getFirstChild(); minionsNode != null; minionsNode = minionsNode.getNextSibling()) {
                                            if (!minionsNode.getNodeName().equalsIgnoreCase("npc")) continue;
                                            attrs = minionsNode.getAttributes();
                                            minions.add(new MinionHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "count"), this.parseInteger(attrs, "respawnTime").intValue(), this.parseInteger(attrs, "weightPoint")));
                                        }
                                        if (minions.isEmpty()) continue block120;
                                        parameters.put(this.parseString(parametersNode.getAttributes(), "name"), minions);
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "race": 
                        case "sex": {
                            set.set(npcNode.getNodeName(), npcNode.getTextContent().toUpperCase());
                            continue block119;
                        }
                        case "equipment": {
                            set.set("chestId", this.parseInteger(attrs, "chest"));
                            set.set("rhandId", this.parseInteger(attrs, "rhand"));
                            set.set("lhandId", this.parseInteger(attrs, "lhand"));
                            set.set("weaponEnchant", this.parseInteger(attrs, "weaponEnchant"));
                            continue block119;
                        }
                        case "acquire": {
                            set.set("expRate", this.parseDouble(attrs, "expRate"));
                            set.set("sp", this.parseDouble(attrs, "sp"));
                            set.set("raidPoints", this.parseDouble(attrs, "raidPoints"));
                            continue block119;
                        }
                        case "stats": {
                            set.set("baseSTR", this.parseInteger(attrs, "str"));
                            set.set("baseINT", this.parseInteger(attrs, "int"));
                            set.set("baseDEX", this.parseInteger(attrs, "dex"));
                            set.set("baseWIT", this.parseInteger(attrs, "wit"));
                            set.set("baseCON", this.parseInteger(attrs, "con"));
                            set.set("baseMEN", this.parseInteger(attrs, "men"));
                            block122: for (Node statsNode = npcNode.getFirstChild(); statsNode != null; statsNode = statsNode.getNextSibling()) {
                                attrs = statsNode.getAttributes();
                                switch (statsNode.getNodeName().toLowerCase()) {
                                    case "vitals": {
                                        set.set("baseHpMax", this.parseDouble(attrs, "hp"));
                                        set.set("baseHpReg", this.parseDouble(attrs, "hpRegen"));
                                        set.set("baseMpMax", this.parseDouble(attrs, "mp"));
                                        set.set("baseMpReg", this.parseDouble(attrs, "mpRegen"));
                                        continue block122;
                                    }
                                    case "attack": {
                                        set.set("basePAtk", this.parseDouble(attrs, "physical"));
                                        set.set("baseMAtk", this.parseDouble(attrs, "magical"));
                                        set.set("baseRndDam", this.parseInteger(attrs, "random"));
                                        set.set("baseCritRate", this.parseInteger(attrs, "critical"));
                                        set.set("accuracy", this.parseDouble(attrs, "accuracy"));
                                        set.set("basePAtkSpd", this.parseInteger(attrs, "attackSpeed"));
                                        set.set("reuseDelay", this.parseInteger(attrs, "reuseDelay"));
                                        set.set("baseAtkType", this.parseString(attrs, "type"));
                                        set.set("baseAtkRange", this.parseInteger(attrs, "range"));
                                        set.set("distance", this.parseInteger(attrs, "distance"));
                                        set.set("width", this.parseInteger(attrs, "width"));
                                        continue block122;
                                    }
                                    case "defence": {
                                        set.set("basePDef", this.parseDouble(attrs, "physical"));
                                        set.set("baseMDef", this.parseDouble(attrs, "magical"));
                                        set.set("evasion", this.parseInteger(attrs, "evasion"));
                                        set.set("baseShldDef", this.parseInteger(attrs, "shield"));
                                        set.set("baseShldRate", this.parseInteger(attrs, "shieldRate"));
                                        continue block122;
                                    }
                                    case "attribute": {
                                        block123: for (Node attributeNode = statsNode.getFirstChild(); attributeNode != null; attributeNode = attributeNode.getNextSibling()) {
                                            attrs = attributeNode.getAttributes();
                                            switch (attributeNode.getNodeName().toLowerCase()) {
                                                case "attack": {
                                                    String attackAttributeType = this.parseString(attrs, "type");
                                                    switch (attackAttributeType.toUpperCase()) {
                                                        case "FIRE": {
                                                            set.set("baseFire", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "WATER": {
                                                            set.set("baseWater", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "WIND": {
                                                            set.set("baseWind", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "EARTH": {
                                                            set.set("baseEarth", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "DARK": {
                                                            set.set("baseDark", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "HOLY": {
                                                            set.set("baseHoly", this.parseInteger(attrs, "value"));
                                                        }
                                                    }
                                                    continue block123;
                                                }
                                                case "defence": {
                                                    set.set("baseFireRes", this.parseInteger(attrs, "fire"));
                                                    set.set("baseWaterRes", this.parseInteger(attrs, "water"));
                                                    set.set("baseWindRes", this.parseInteger(attrs, "wind"));
                                                    set.set("baseEarthRes", this.parseInteger(attrs, "earth"));
                                                    set.set("baseHolyRes", this.parseInteger(attrs, "holy"));
                                                    set.set("baseDarkRes", this.parseInteger(attrs, "dark"));
                                                    set.set("baseElementRes", this.parseInteger(attrs, "default"));
                                                }
                                            }
                                        }
                                        continue block122;
                                    }
                                    case "speed": {
                                        block124: for (Node speedNode = statsNode.getFirstChild(); speedNode != null; speedNode = speedNode.getNextSibling()) {
                                            attrs = speedNode.getAttributes();
                                            switch (speedNode.getNodeName().toLowerCase()) {
                                                case "walk": {
                                                    set.set("baseWalkSpd", this.parseDouble(attrs, "ground"));
                                                    set.set("baseSwimWalkSpd", this.parseDouble(attrs, "swim"));
                                                    set.set("baseFlyWalkSpd", this.parseDouble(attrs, "fly"));
                                                    continue block124;
                                                }
                                                case "run": {
                                                    set.set("baseRunSpd", this.parseDouble(attrs, "ground"));
                                                    set.set("baseSwimRunSpd", this.parseDouble(attrs, "swim"));
                                                    set.set("baseFlyRunSpd", this.parseDouble(attrs, "fly"));
                                                }
                                            }
                                        }
                                        continue block122;
                                    }
                                    case "hittime": {
                                        set.set("hitTime", npcNode.getTextContent());
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "status": {
                            set.set("unique", this.parseBoolean(attrs, "unique"));
                            set.set("attackable", this.parseBoolean(attrs, "attackable"));
                            set.set("targetable", this.parseBoolean(attrs, "targetable"));
                            set.set("undying", this.parseBoolean(attrs, "undying"));
                            set.set("showName", this.parseBoolean(attrs, "showName"));
                            set.set("flying", this.parseBoolean(attrs, "flying"));
                            set.set("canMove", this.parseBoolean(attrs, "canMove"));
                            set.set("noSleepMode", this.parseBoolean(attrs, "noSleepMode"));
                            set.set("passableDoor", this.parseBoolean(attrs, "passableDoor"));
                            set.set("hasSummoner", this.parseBoolean(attrs, "hasSummoner"));
                            set.set("canBeSown", this.parseBoolean(attrs, "canBeSown"));
                            continue block119;
                        }
                        case "skilllist": {
                            skills = new HashMap<Integer, Skill>();
                            for (Node skillListNode = npcNode.getFirstChild(); skillListNode != null; skillListNode = skillListNode.getNextSibling()) {
                                if (!"skill".equalsIgnoreCase(skillListNode.getNodeName())) continue;
                                attrs = skillListNode.getAttributes();
                                int skillId = this.parseInteger(attrs, "id");
                                int skillLevel = this.parseInteger(attrs, "level");
                                Skill skill = SkillData.getInstance().getSkill(skillId, skillLevel);
                                if (skill != null) {
                                    skills.put(skill.getId(), skill);
                                    continue;
                                }
                                LOG.warn("{} skill not found. NPC Id {}, skill Id {}, skill level: {}!", f, npcId, skillId, skillLevel);
                            }
                            continue block119;
                        }
                        case "shots": {
                            set.set("soulShot", this.parseInteger(attrs, "soul"));
                            set.set("spiritShot", this.parseInteger(attrs, "spirit"));
                            set.set("shotShotChance", this.parseInteger(attrs, "shotChance"));
                            set.set("spiritShotChance", this.parseInteger(attrs, "spiritChance"));
                            continue block119;
                        }
                        case "corpsetime": {
                            set.set("corpseTime", npcNode.getTextContent());
                            continue block119;
                        }
                        case "excrteffect": {
                            set.set("exCrtEffect", npcNode.getTextContent());
                            continue block119;
                        }
                        case "snpcprophprate": {
                            set.set("sNpcPropHpRate", npcNode.getTextContent());
                            continue block119;
                        }
                        case "ai": {
                            set.set("aiType", this.parseString(attrs, "type"));
                            set.set("aggroRange", this.parseInteger(attrs, "aggroRange"));
                            set.set("clanHelpRange", this.parseInteger(attrs, "clanHelpRange"));
                            set.set("isChaos", this.parseBoolean(attrs, "isChaos"));
                            set.set("isAggressive", this.parseBoolean(attrs, "isAggressive"));
                            block126: for (Node aiNode = npcNode.getFirstChild(); aiNode != null; aiNode = aiNode.getNextSibling()) {
                                attrs = aiNode.getAttributes();
                                switch (aiNode.getNodeName().toLowerCase()) {
                                    case "skill": {
                                        set.set("minSkillChance", this.parseInteger(attrs, "minChance"));
                                        set.set("maxSkillChance", this.parseInteger(attrs, "maxChance"));
                                        set.set("primarySkillId", this.parseInteger(attrs, "primaryId"));
                                        set.set("shortRangeSkillId", this.parseInteger(attrs, "shortRangeId"));
                                        set.set("shortRangeSkillChance", this.parseInteger(attrs, "shortRangeChance"));
                                        set.set("longRangeSkillId", this.parseInteger(attrs, "longRangeId"));
                                        set.set("longRangeSkillChance", this.parseInteger(attrs, "longRangeChance"));
                                        continue block126;
                                    }
                                    case "clanlist": {
                                        block127: for (Node clanListNode = aiNode.getFirstChild(); clanListNode != null; clanListNode = clanListNode.getNextSibling()) {
                                            attrs = clanListNode.getAttributes();
                                            switch (clanListNode.getNodeName().toLowerCase()) {
                                                case "clan": {
                                                    if (clans == null) {
                                                        clans = new HashSet<Integer>(1);
                                                    }
                                                    clans.add(this.getOrCreateClanId(clanListNode.getTextContent()));
                                                    continue block127;
                                                }
                                                case "ignorenpcid": {
                                                    if (ignoreClanNpcIds == null) {
                                                        ignoreClanNpcIds = new HashSet<Integer>(1);
                                                    }
                                                    ignoreClanNpcIds.add(Integer.parseInt(clanListNode.getTextContent()));
                                                }
                                            }
                                        }
                                        continue block126;
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "droplists": {
                            for (Node dropListsNode = npcNode.getFirstChild(); dropListsNode != null; dropListsNode = dropListsNode.getNextSibling()) {
                                DropListScope dropListScope = null;
                                try {
                                    dropListScope = Enum.valueOf(DropListScope.class, dropListsNode.getNodeName().toUpperCase());
                                }
                                catch (Exception skillLevel) {
                                    // empty catch block
                                }
                                if (dropListScope == null) continue;
                                if (dropLists == null) {
                                    dropLists = new EnumMap<DropListScope, List<IDropItem>>(DropListScope.class);
                                }
                                ArrayList<IDropItem> dropList = new ArrayList<IDropItem>();
                                this.parseDropList(f, dropListsNode, dropListScope, dropList);
                                dropLists.put(dropListScope, Collections.unmodifiableList(dropList));
                            }
                            continue block119;
                        }
                        case "collision": {
                            block129: for (Node collisionNode = npcNode.getFirstChild(); collisionNode != null; collisionNode = collisionNode.getNextSibling()) {
                                attrs = collisionNode.getAttributes();
                                switch (collisionNode.getNodeName().toLowerCase()) {
                                    case "radius": {
                                        set.set("collisionRadius", this.parseDouble(attrs, "normal"));
                                        set.set("collisionRadiusGrown", this.parseDouble(attrs, "grown"));
                                        continue block129;
                                    }
                                    case "height": {
                                        set.set("collisionHeight", this.parseDouble(attrs, "normal"));
                                        set.set("collisionHeightGrown", this.parseDouble(attrs, "grown"));
                                    }
                                }
                            }
                            continue block119;
                        }
                    }
                }
                L2NpcTemplate template = this._npcs.get(npcId);
                if (template == null) {
                    template = new L2NpcTemplate(set);
                    this._npcs.put(template.getId(), template);
                } else {
                    template.set(set);
                }
                if (this._minionData._tempMinions.containsKey(npcId)) {
                    if (parameters == null) {
                        parameters = new HashMap();
                    }
                    parameters.putIfAbsent("Privates", this._minionData._tempMinions.get(npcId));
                }
                if (parameters != null) {
                    template.setParameters(new StatsSet(Collections.unmodifiableMap(parameters)));
                } else {
                    template.setParameters(StatsSet.EMPTY_STATSET);
                }
                if (skills != null) {
                    EnumMap<AISkillScope, List> aiSkillLists = null;
                    for (Skill skill : skills.values()) {
                        AISkillScope shortOrLongRangeScope;
                        if (skill.isPassive()) continue;
                        if (aiSkillLists == null) {
                            aiSkillLists = new EnumMap<AISkillScope, List>(AISkillScope.class);
                        }
                        ArrayList<AISkillScope> aiSkillScopes = new ArrayList<AISkillScope>();
                        AISkillScope aISkillScope = shortOrLongRangeScope = skill.getCastRange() <= 150 ? AISkillScope.SHORT_RANGE : AISkillScope.LONG_RANGE;
                        if (skill.isSuicideAttack()) {
                            aiSkillScopes.add(AISkillScope.SUICIDE);
                        } else {
                            aiSkillScopes.add(AISkillScope.GENERAL);
                            if (skill.isContinuous()) {
                                if (!skill.isDebuff()) {
                                    aiSkillScopes.add(AISkillScope.BUFF);
                                } else {
                                    aiSkillScopes.add(AISkillScope.DEBUFF);
                                    aiSkillScopes.add(AISkillScope.COT);
                                    aiSkillScopes.add(shortOrLongRangeScope);
                                }
                            } else if (skill.hasEffectType(L2EffectType.DISPEL, new L2EffectType[0])) {
                                aiSkillScopes.add(AISkillScope.NEGATIVE);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.HP, new L2EffectType[0])) {
                                aiSkillScopes.add(AISkillScope.HEAL);
                            } else if (skill.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.MAGICAL_ATTACK, L2EffectType.HP_DRAIN)) {
                                aiSkillScopes.add(AISkillScope.ATTACK);
                                aiSkillScopes.add(AISkillScope.UNIVERSAL);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.SLEEP, new L2EffectType[0])) {
                                aiSkillScopes.add(AISkillScope.IMMOBILIZE);
                            } else if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT)) {
                                aiSkillScopes.add(AISkillScope.IMMOBILIZE);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.MUTE, L2EffectType.FEAR)) {
                                aiSkillScopes.add(AISkillScope.COT);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.DMG_OVER_TIME, new L2EffectType[0])) {
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.RESURRECTION, new L2EffectType[0])) {
                                aiSkillScopes.add(AISkillScope.RES);
                            } else {
                                aiSkillScopes.add(AISkillScope.UNIVERSAL);
                            }
                        }
                        for (AISkillScope aiSkillScope : aiSkillScopes) {
                            List aiSkills = aiSkillLists.computeIfAbsent(aiSkillScope, k -> new ArrayList());
                            aiSkills.add(skill);
                        }
                    }
                    template.setSkills(skills);
                    template.setAISkillLists(aiSkillLists);
                } else {
                    template.setSkills(null);
                    template.setAISkillLists(null);
                }
                template.setClans(clans);
                template.setIgnoreClanNpcIds(ignoreClanNpcIds);
                template.setDropLists(dropLists);
            }
        }
    }

    private void parseDropList(File f, Node dropListNode, DropListScope dropListScope, List<IDropItem> drops) {
        for (Node dropNode = dropListNode.getFirstChild(); dropNode != null; dropNode = dropNode.getNextSibling()) {
            NamedNodeMap attrs = dropNode.getAttributes();
            if ("group".equals(dropNode.getNodeName().toLowerCase())) {
                GroupedGeneralDropItem dropItem = dropListScope.newGroupedDropItem(this.parseDouble(attrs, "chance"));
                ArrayList<IDropItem> groupedDropList = new ArrayList<IDropItem>(2);
                for (Node groupNode = dropNode.getFirstChild(); groupNode != null; groupNode = groupNode.getNextSibling()) {
                    this.parseDropListItem(groupNode, dropListScope, groupedDropList);
                }
                ArrayList<GeneralDropItem> items = new ArrayList<GeneralDropItem>(groupedDropList.size());
                for (IDropItem item : groupedDropList) {
                    if (item instanceof GeneralDropItem) {
                        items.add((GeneralDropItem)item);
                        continue;
                    }
                    LOG.warn("{} grouped general drop item supports only general drop item.", (Object)f);
                }
                dropItem.setItems(items);
                drops.add(dropItem);
                continue;
            }
            this.parseDropListItem(dropNode, dropListScope, drops);
        }
    }

    private void parseDropListItem(Node dropListItem, DropListScope dropListScope, List<IDropItem> drops) {
        IDropItem dropItem;
        NamedNodeMap attrs = dropListItem.getAttributes();
        if ("item".equals(dropListItem.getNodeName().toLowerCase()) && (dropItem = dropListScope.newDropItem(this.parseInteger(attrs, "id"), this.parseLong(attrs, "min"), this.parseLong(attrs, "max"), this.parseDouble(attrs, "chance"))) != null) {
            drops.add(dropItem);
        }
    }

    private int getOrCreateClanId(String clanName) {
        Integer id = this._clans.get(clanName.toUpperCase());
        if (id == null) {
            id = this._clans.size();
            this._clans.put(clanName.toUpperCase(), id);
        }
        return id;
    }

    public int getClanId(String clanName) {
        Integer id = this._clans.get(clanName.toUpperCase());
        return id != null ? id : -1;
    }

    public L2NpcTemplate getTemplate(int id) {
        return this._npcs.get(id);
    }

    public L2NpcTemplate getTemplateByName(String name) {
        for (L2NpcTemplate npcTemplate : this._npcs.values()) {
            if (!npcTemplate.getName().equalsIgnoreCase(name)) continue;
            return npcTemplate;
        }
        return null;
    }

    public List<L2NpcTemplate> getTemplates(Predicate<L2NpcTemplate> filter) {
        return this._npcs.values().stream().filter(filter).toList();
    }

    public List<L2NpcTemplate> getAllOfLevel(int ... lvls) {
        return this.getTemplates(template -> Util.contains(lvls, template.getLevel()));
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int ... lvls) {
        return this.getTemplates(template -> Util.contains(lvls, template.getLevel()) && template.isType("L2Monster"));
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String text) {
        return this.getTemplates(template -> template.isType("L2Npc") && template.getName().startsWith(text));
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String ... classTypes) {
        return this.getTemplates(template -> Util.contains(classTypes, template.getType(), true));
    }

    public static NpcData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class MinionData
    implements IXmlReader {
        private static final Logger LOG = LoggerFactory.getLogger(MinionData.class);
        public final Map<Integer, List<MinionHolder>> _tempMinions = new HashMap<Integer, List<MinionHolder>>();

        protected MinionData() {
            this.load();
        }

        @Override
        public void load() {
            this._tempMinions.clear();
            this.parseDatapackFile("data/minionData.xml");
            LOG.info("Loaded {} minions data.", (Object)this._tempMinions.size());
        }

        @Override
        public void parseDocument(Document doc) {
            for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equals(node.getNodeName())) continue;
                for (Node listNode = node.getFirstChild(); listNode != null; listNode = listNode.getNextSibling()) {
                    if (!"npc".equals(listNode.getNodeName())) continue;
                    ArrayList<MinionHolder> minions = new ArrayList<MinionHolder>(1);
                    NamedNodeMap attrs = listNode.getAttributes();
                    int id = this.parseInteger(attrs, "id");
                    for (Node npcNode = listNode.getFirstChild(); npcNode != null; npcNode = npcNode.getNextSibling()) {
                        if (!"minion".equals(npcNode.getNodeName())) continue;
                        attrs = npcNode.getAttributes();
                        minions.add(new MinionHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "count"), this.parseInteger(attrs, "respawnTime").intValue(), 0));
                    }
                    this._tempMinions.put(id, minions);
                }
            }
        }
    }

    private static class SingletonHolder {
        protected static final NpcData INSTANCE = new NpcData();

        private SingletonHolder() {
        }
    }
}

