/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.util.IXmlReader;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SecondaryAuthData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(SecondaryAuthData.class);
    private final Set<String> _forbiddenPasswords = new HashSet<String>();
    private boolean _enabled = false;
    private int _maxAttempts = 5;
    private int _banTime = 480;
    private String _recoveryLink = "";

    protected SecondaryAuthData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._forbiddenPasswords.clear();
        this.parseFile(new File("config/SecondaryAuth.xml"));
        LOG.info("Loaded {} forbidden passwords.", (Object)this._forbiddenPasswords.size());
    }

    @Override
    public void parseDocument(Document doc) {
        try {
            for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
                for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                    if ("enabled".equalsIgnoreCase(list_node.getNodeName())) {
                        this._enabled = Boolean.parseBoolean(list_node.getTextContent());
                        continue;
                    }
                    if ("maxAttempts".equalsIgnoreCase(list_node.getNodeName())) {
                        this._maxAttempts = Integer.parseInt(list_node.getTextContent());
                        continue;
                    }
                    if ("banTime".equalsIgnoreCase(list_node.getNodeName())) {
                        this._banTime = Integer.parseInt(list_node.getTextContent());
                        continue;
                    }
                    if ("recoveryLink".equalsIgnoreCase(list_node.getNodeName())) {
                        this._recoveryLink = list_node.getTextContent();
                        continue;
                    }
                    if (!"forbiddenPasswords".equalsIgnoreCase(list_node.getNodeName())) continue;
                    for (Node forbiddenPasswords_node = list_node.getFirstChild(); forbiddenPasswords_node != null; forbiddenPasswords_node = forbiddenPasswords_node.getNextSibling()) {
                        if (!"password".equalsIgnoreCase(forbiddenPasswords_node.getNodeName())) continue;
                        this._forbiddenPasswords.add(forbiddenPasswords_node.getTextContent());
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to load secondary auth data from xml.", ex);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int getMaxAttempts() {
        return this._maxAttempts;
    }

    public int getBanTime() {
        return this._banTime;
    }

    public String getRecoveryLink() {
        return this._recoveryLink;
    }

    public Set<String> getForbiddenPasswords() {
        return this._forbiddenPasswords;
    }

    public boolean isForbiddenPassword(String password) {
        return this._forbiddenPasswords.contains(password);
    }

    public static SecondaryAuthData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final SecondaryAuthData INSTANCE = new SecondaryAuthData();

        private SingletonHolder() {
        }
    }
}

