/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.SocialClass;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.PlayerSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SkillTreesData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(SkillTreesData.class);
    private final Map<ClassId, Map<Integer, L2SkillLearn>> _classSkillTrees = new LinkedHashMap<ClassId, Map<Integer, L2SkillLearn>>();
    private final Map<ClassId, Map<Integer, L2SkillLearn>> _transferSkillTrees = new LinkedHashMap<ClassId, Map<Integer, L2SkillLearn>>();
    private final Map<Integer, L2SkillLearn> _collectSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _fishingSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _pledgeSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _subClassSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _subPledgeSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _transformSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _commonSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _nobleSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _heroSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _gameMasterSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private final Map<Integer, L2SkillLearn> _gameMasterAuraSkillTree = new LinkedHashMap<Integer, L2SkillLearn>();
    private Map<Integer, int[]> _skillsByClassIdHashCodes;
    private Map<Integer, int[]> _skillsByRaceHashCodes;
    private int[] _allSkillsHashCodes;
    private boolean _loading = true;
    private final Map<ClassId, ClassId> _parentClassMap = new LinkedHashMap<ClassId, ClassId>();

    protected SkillTreesData() {
        this.load();
    }

    @Override
    public void load() {
        this._loading = true;
        this._classSkillTrees.clear();
        this._collectSkillTree.clear();
        this._fishingSkillTree.clear();
        this._pledgeSkillTree.clear();
        this._subClassSkillTree.clear();
        this._subPledgeSkillTree.clear();
        this._transferSkillTrees.clear();
        this._transformSkillTree.clear();
        this._nobleSkillTree.clear();
        this._heroSkillTree.clear();
        this._gameMasterSkillTree.clear();
        this._gameMasterAuraSkillTree.clear();
        this.parseDatapackDirectory("data/skillTrees/", false);
        this.generateCheckArrays();
        this._loading = false;
        this.report();
    }

    @Override
    public void parseDocument(Document doc) {
        ClassId classId = null;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                int cId;
                if (!"skillTree".equalsIgnoreCase(d.getNodeName())) continue;
                HashMap<Integer, L2SkillLearn> classSkillTree = new HashMap<Integer, L2SkillLearn>();
                HashMap<Integer, L2SkillLearn> trasferSkillTree = new HashMap<Integer, L2SkillLearn>();
                String type = d.getAttributes().getNamedItem("type").getNodeValue();
                Node attr = d.getAttributes().getNamedItem("classId");
                if (attr != null) {
                    cId = Integer.parseInt(attr.getNodeValue());
                    classId = ClassId.values()[cId];
                } else {
                    cId = -1;
                }
                attr = d.getAttributes().getNamedItem("parentClassId");
                if (attr != null) {
                    int parentClassId = Integer.parseInt(attr.getNodeValue());
                    if (cId > -1 && cId != parentClassId && parentClassId > -1 && !this._parentClassMap.containsKey(classId)) {
                        this._parentClassMap.put(classId, ClassId.values()[parentClassId]);
                    }
                }
                block46: for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"skill".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet learnSkillSet = new StatsSet();
                    NamedNodeMap attrs = c.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        attr = attrs.item(i);
                        learnSkillSet.set(attr.getNodeName(), attr.getNodeValue());
                    }
                    L2SkillLearn skillLearn = new L2SkillLearn(learnSkillSet);
                    block48: for (Node b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                        attrs = b.getAttributes();
                        switch (b.getNodeName()) {
                            case "item": {
                                skillLearn.addRequiredItem(new ItemHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "count").intValue()));
                                continue block48;
                            }
                            case "preRequisiteSkill": {
                                skillLearn.addPreReqSkill(new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "lvl")));
                                continue block48;
                            }
                            case "race": {
                                skillLearn.addRace(Race.valueOf(b.getTextContent()));
                                continue block48;
                            }
                            case "residenceId": {
                                skillLearn.addResidenceId(Integer.valueOf(b.getTextContent()));
                                continue block48;
                            }
                            case "socialClass": {
                                skillLearn.setSocialClass(Enum.valueOf(SocialClass.class, b.getTextContent()));
                                continue block48;
                            }
                            case "subClassConditions": {
                                skillLearn.addSubclassConditions(this.parseInteger(attrs, "slot"), this.parseInteger(attrs, "lvl"));
                            }
                        }
                    }
                    int skillHashCode = SkillData.getSkillHashCode(skillLearn.getSkillId(), skillLearn.getSkillLevel());
                    switch (type) {
                        case "classSkillTree": {
                            if (cId != -1) {
                                classSkillTree.put(skillHashCode, skillLearn);
                                continue block46;
                            }
                            this._commonSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "transferSkillTree": {
                            trasferSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "collectSkillTree": {
                            this._collectSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "fishingSkillTree": {
                            this._fishingSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "pledgeSkillTree": {
                            this._pledgeSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "subClassSkillTree": {
                            this._subClassSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "subPledgeSkillTree": {
                            this._subPledgeSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "transformSkillTree": {
                            this._transformSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "nobleSkillTree": {
                            this._nobleSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "heroSkillTree": {
                            this._heroSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "gameMasterSkillTree": {
                            this._gameMasterSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        case "gameMasterAuraSkillTree": {
                            this._gameMasterAuraSkillTree.put(skillHashCode, skillLearn);
                            continue block46;
                        }
                        default: {
                            LOG.warn("Unknown Skill Tree type: {}!", (Object)type);
                        }
                    }
                }
                if (type.equals("transferSkillTree")) {
                    this._transferSkillTrees.put(classId, trasferSkillTree);
                    continue;
                }
                if (!type.equals("classSkillTree") || cId <= -1) continue;
                if (!this._classSkillTrees.containsKey(classId)) {
                    this._classSkillTrees.put(classId, classSkillTree);
                    continue;
                }
                this._classSkillTrees.get(classId).putAll(classSkillTree);
            }
        }
    }

    public Map<Integer, L2SkillLearn> getCompleteClassSkillTree(ClassId classId) {
        LinkedHashMap<Integer, L2SkillLearn> skillTree = new LinkedHashMap<Integer, L2SkillLearn>(this._commonSkillTree);
        LinkedList<ClassId> classSequence = new LinkedList<ClassId>();
        while (classId != null) {
            classSequence.addFirst(classId);
            classId = this._parentClassMap.get(classId);
        }
        for (ClassId cid : classSequence) {
            Map<Integer, L2SkillLearn> classSkillTree = this._classSkillTrees.get(cid);
            if (classSkillTree == null) continue;
            skillTree.putAll(classSkillTree);
        }
        return skillTree;
    }

    public Map<Integer, L2SkillLearn> getTransferSkillTree(ClassId classId) {
        if (classId.level() >= 3) {
            return this.getTransferSkillTree(classId.getParent());
        }
        return this._transferSkillTrees.get(classId);
    }

    public Map<Integer, L2SkillLearn> getCommonSkillTree() {
        return this._commonSkillTree;
    }

    public Map<Integer, L2SkillLearn> getCollectSkillTree() {
        return this._collectSkillTree;
    }

    public Map<Integer, L2SkillLearn> getFishingSkillTree() {
        return this._fishingSkillTree;
    }

    public Map<Integer, L2SkillLearn> getPledgeSkillTree() {
        return this._pledgeSkillTree;
    }

    public Map<Integer, L2SkillLearn> getSubClassSkillTree() {
        return this._subClassSkillTree;
    }

    public Map<Integer, L2SkillLearn> getSubPledgeSkillTree() {
        return this._subPledgeSkillTree;
    }

    public Map<Integer, L2SkillLearn> getTransformSkillTree() {
        return this._transformSkillTree;
    }

    public Map<Integer, Skill> getNobleSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : this._nobleSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getHeroSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : this._heroSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getGMSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : this._gameMasterSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public Map<Integer, Skill> getGMAuraSkillTree() {
        HashMap<Integer, Skill> tree = new HashMap<Integer, Skill>();
        SkillData st = SkillData.getInstance();
        for (Map.Entry<Integer, L2SkillLearn> e : this._gameMasterAuraSkillTree.entrySet()) {
            tree.put(e.getKey(), st.getSkill(e.getValue().getSkillId(), e.getValue().getSkillLevel()));
        }
        return tree;
    }

    public List<L2SkillLearn> getAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet) {
        return this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, player);
    }

    private List<L2SkillLearn> getAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet, ISkillsHolder holder) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Map<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(classId);
        if (skills.isEmpty()) {
            LOG.warn("{}: Skilltree for class {} is not defined!", (Object)this.getClass().getSimpleName(), (Object)classId);
            return result;
        }
        for (L2SkillLearn skill : skills.values()) {
            if (skill.getSkillId() == CommonSkill.DIVINE_INSPIRATION.getId() && !Configuration.character().autoLearnDivineInspiration() && includeAutoGet && !player.isGM() || (!includeAutoGet || !skill.isAutoGet()) && !skill.isLearnedByNpc() && (!includeByFs || !skill.isLearnedByFS()) || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = holder.getKnownSkill(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public Collection<Skill> getAllAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet) {
        PlayerSkillHolder holder = new PlayerSkillHolder(player);
        List<L2SkillLearn> learnable = this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, holder);
        while (learnable.size() > 0) {
            for (L2SkillLearn s : learnable) {
                Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                holder.addSkill(sk);
            }
            learnable = this.getAvailableSkills(player, classId, includeByFs, includeAutoGet, holder);
        }
        return holder.getSkills().values();
    }

    public List<L2SkillLearn> getAvailableAutoGetSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Map<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(player.getClassId());
        if (skills.isEmpty()) {
            LOG.warn("{}: Skill Tree for class ID {} is not defined!", (Object)this.getClass().getSimpleName(), (Object)player.getClassId());
            return result;
        }
        Race race = player.getRace();
        for (L2SkillLearn skill : skills.values()) {
            if (!skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)race) || !skill.isAutoGet() || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() >= skill.getSkillLevel()) continue;
                result.add(skill);
                continue;
            }
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableFishingSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Race playerRace = player.getRace();
        for (L2SkillLearn skill : this._fishingSkillTree.values()) {
            if (!skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)playerRace) || !skill.isLearnedByNpc() || player.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableCollectSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : this._collectSkillTree.values()) {
            Skill oldSkill = player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableTransferSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        ClassId classId = player.getClassId();
        if (classId.level() == 3) {
            classId = classId.getParent();
        }
        if (!this._transferSkillTrees.containsKey(classId)) {
            return result;
        }
        for (L2SkillLearn skill : this._transferSkillTrees.get(classId).values()) {
            if (player.getKnownSkill(skill.getSkillId()) != null) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableTransformSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        Race race = player.getRace();
        for (L2SkillLearn skill : this._transformSkillTree.values()) {
            if (player.getLevel() < skill.getGetLevel() || !skill.getRaces().isEmpty() && !skill.getRaces().contains((Object)race)) continue;
            Skill oldSkill = player.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailablePledgeSkills(L2Clan clan) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : this._pledgeSkillTree.values()) {
            if (skill.isResidentialSkill() || clan.getLevel() < skill.getGetLevel()) continue;
            Skill oldSkill = clan.getSkills().get(skill.getSkillId());
            if (oldSkill != null) {
                if (oldSkill.getLevel() + 1 != skill.getSkillLevel()) continue;
                result.add(skill);
                continue;
            }
            if (skill.getSkillLevel() != 1) continue;
            result.add(skill);
        }
        return result;
    }

    public Map<Integer, L2SkillLearn> getMaxPledgeSkills(L2Clan clan, boolean includeSquad) {
        Skill oldSkill;
        HashMap<Integer, L2SkillLearn> result = new HashMap<Integer, L2SkillLearn>();
        for (L2SkillLearn skill : this._pledgeSkillTree.values()) {
            if (skill.isResidentialSkill() || clan.getLevel() < skill.getGetLevel() || (oldSkill = clan.getSkills().get(skill.getSkillId())) != null && oldSkill.getLevel() >= skill.getSkillLevel()) continue;
            result.put(skill.getSkillId(), skill);
        }
        if (includeSquad) {
            for (L2SkillLearn skill : this._subPledgeSkillTree.values()) {
                if (clan.getLevel() < skill.getGetLevel() || (oldSkill = clan.getSkills().get(skill.getSkillId())) != null && oldSkill.getLevel() >= skill.getSkillLevel()) continue;
                result.put(skill.getSkillId(), skill);
            }
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableSubPledgeSkills(L2Clan clan) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : this._subPledgeSkillTree.values()) {
            if (clan.getLevel() < skill.getGetLevel() || !clan.isLearnableSubSkill(skill.getSkillId(), skill.getSkillLevel())) continue;
            result.add(skill);
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableSubClassSkills(L2PcInstance player) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : this._subClassSkillTree.values()) {
            if (player.getLevel() < skill.getGetLevel()) continue;
            for (SubClass subClass : player.getSubClasses().values()) {
                List<L2SkillLearn.SubClassData> subClassConds = skill.getSubClassConditions();
                if (subClassConds.isEmpty() || subClass.getClassIndex() > subClassConds.size() || subClass.getClassIndex() != subClassConds.get(subClass.getClassIndex() - 1).getSlot() || subClassConds.get(subClass.getClassIndex() - 1).getLvl() > subClass.getLevel()) continue;
                Skill oldSkill = player.getSkills().get(skill.getSkillId());
                if (oldSkill != null) {
                    if (oldSkill.getLevel() != skill.getSkillLevel() - 1) continue;
                    result.add(skill);
                    continue;
                }
                if (skill.getSkillLevel() != 1) continue;
                result.add(skill);
            }
        }
        return result;
    }

    public List<L2SkillLearn> getAvailableResidentialSkills(int residenceId) {
        ArrayList<L2SkillLearn> result = new ArrayList<L2SkillLearn>();
        for (L2SkillLearn skill : this._pledgeSkillTree.values()) {
            if (!skill.isResidentialSkill() || !skill.getResidenceIds().contains(residenceId)) continue;
            result.add(skill);
        }
        return result;
    }

    public L2SkillLearn getSkillLearn(AcquireSkillType skillType, int id, int lvl, L2PcInstance player) {
        return switch (skillType) {
            case AcquireSkillType.CLASS -> this.getClassSkill(id, lvl, player.getLearningClass());
            case AcquireSkillType.TRANSFORM -> this.getTransformSkill(id, lvl);
            case AcquireSkillType.FISHING -> this.getFishingSkill(id, lvl);
            case AcquireSkillType.PLEDGE -> this.getPledgeSkill(id, lvl);
            case AcquireSkillType.SUBPLEDGE -> this.getSubPledgeSkill(id, lvl);
            case AcquireSkillType.TRANSFER -> this.getTransferSkill(id, lvl, player.getClassId());
            case AcquireSkillType.SUBCLASS -> this.getSubClassSkill(id, lvl);
            case AcquireSkillType.COLLECT -> this.getCollectSkill(id, lvl);
            default -> null;
        };
    }

    public L2SkillLearn getTransformSkill(int id, int lvl) {
        return this._transformSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getClassSkill(int id, int lvl, ClassId classId) {
        return this.getCompleteClassSkillTree(classId).get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getFishingSkill(int id, int lvl) {
        return this._fishingSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getPledgeSkill(int id, int lvl) {
        return this._pledgeSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getSubPledgeSkill(int id, int lvl) {
        return this._subPledgeSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getTransferSkill(int id, int lvl, ClassId classId) {
        ClassId parentId;
        if (classId.getParent() != null && this._transferSkillTrees.get(parentId = classId.getParent()) != null) {
            return this._transferSkillTrees.get(parentId).get(SkillData.getSkillHashCode(id, lvl));
        }
        return null;
    }

    public L2SkillLearn getSubClassSkill(int id, int lvl) {
        return this._subClassSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCommonSkill(int id, int lvl) {
        return this._commonSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCollectSkill(int id, int lvl) {
        return this._collectSkillTree.get(SkillData.getSkillHashCode(id, lvl));
    }

    public int getMinLevelForNewSkill(L2PcInstance player, Map<Integer, L2SkillLearn> skillTree) {
        int minLevel = 0;
        if (skillTree.isEmpty()) {
            LOG.warn("{}: SkillTree is not defined for getMinLevelForNewSkill!", (Object)this.getClass().getSimpleName());
        } else {
            for (L2SkillLearn s : skillTree.values()) {
                if (!s.isLearnedByNpc() || player.getLevel() >= s.getGetLevel() || minLevel != 0 && minLevel <= s.getGetLevel()) continue;
                minLevel = s.getGetLevel();
            }
        }
        return minLevel;
    }

    public boolean isHeroSkill(int skillId, int skillLevel) {
        if (this._heroSkillTree.containsKey(SkillData.getSkillHashCode(skillId, skillLevel))) {
            return true;
        }
        for (L2SkillLearn skill : this._heroSkillTree.values()) {
            if (skill.getSkillId() != skillId || skillLevel != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isGMSkill(int skillId, int skillLevel) {
        if (skillLevel <= 0) {
            return this._gameMasterSkillTree.values().stream().anyMatch(s -> s.getSkillId() == skillId) || this._gameMasterAuraSkillTree.values().stream().anyMatch(s -> s.getSkillId() == skillId);
        }
        int hashCode = SkillData.getSkillHashCode(skillId, skillLevel);
        return this._gameMasterSkillTree.containsKey(hashCode) || this._gameMasterAuraSkillTree.containsKey(hashCode);
    }

    public boolean isClanSkill(int skillId, int skillLevel) {
        int hashCode = SkillData.getSkillHashCode(skillId, skillLevel);
        return this._pledgeSkillTree.containsKey(hashCode) || this._subPledgeSkillTree.containsKey(hashCode);
    }

    public void addSkills(L2PcInstance gmchar, boolean auraSkills) {
        Collection<L2SkillLearn> skills = auraSkills ? this._gameMasterAuraSkillTree.values() : this._gameMasterSkillTree.values();
        SkillData st = SkillData.getInstance();
        for (L2SkillLearn sl : skills) {
            gmchar.addSkill(st.getSkill(sl.getSkillId(), sl.getSkillLevel()), false);
        }
    }

    private void generateCheckArrays() {
        int[] array;
        int i;
        Set<ClassId> keySet = this._classSkillTrees.keySet();
        this._skillsByClassIdHashCodes = new HashMap<Integer, int[]>(keySet.size());
        for (ClassId classId : keySet) {
            i = 0;
            Map<Integer, L2SkillLearn> tempMap = this.getCompleteClassSkillTree(classId);
            array = new int[tempMap.size()];
            for (int h : tempMap.keySet()) {
                array[i++] = h;
            }
            tempMap.clear();
            Arrays.sort(array);
            this._skillsByClassIdHashCodes.put(classId.ordinal(), array);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        this._skillsByRaceHashCodes = new HashMap<Integer, int[]>(Race.values().length);
        for (Race r : Race.values()) {
            for (L2SkillLearn s : this._fishingSkillTree.values()) {
                if (!s.getRaces().contains((Object)r)) continue;
                list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            for (L2SkillLearn s : this._transformSkillTree.values()) {
                if (!s.getRaces().contains((Object)r)) continue;
                list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            i = 0;
            array = new int[list.size()];
            Iterator<L2SkillLearn> iterator = list.iterator();
            while (iterator.hasNext()) {
                int s = (Integer)((Object)iterator.next());
                array[i++] = s;
            }
            Arrays.sort(array);
            this._skillsByRaceHashCodes.put(r.ordinal(), array);
            list.clear();
        }
        for (L2SkillLearn s : this._commonSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : this._fishingSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : this._transformSkillTree.values()) {
            if (!s.getRaces().isEmpty()) continue;
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : this._collectSkillTree.values()) {
            list.add(SkillData.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        this._allSkillsHashCodes = new int[list.size()];
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int hashcode = (Integer)iterator.next();
            this._allSkillsHashCodes[++var6_13] = hashcode;
        }
        Arrays.sort(this._allSkillsHashCodes);
    }

    public boolean isSkillAllowed(L2PcInstance player, Skill skill) {
        if (skill.isExcludedFromCheck()) {
            return true;
        }
        if (player.isGM() && skill.isGMSkill()) {
            return true;
        }
        if (this._loading) {
            return true;
        }
        int maxLvl = SkillData.getInstance().getMaxLevel(skill.getId());
        int hashCode = SkillData.getSkillHashCode(skill.getId(), Math.min(skill.getLevel(), maxLvl));
        if (Arrays.binarySearch(this._skillsByClassIdHashCodes.get(player.getClassId().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(this._skillsByRaceHashCodes.get(player.getRace().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(this._allSkillsHashCodes, hashCode) >= 0) {
            return true;
        }
        return this.getTransferSkill(skill.getId(), Math.min(skill.getLevel(), maxLvl), player.getClassId()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private void report() {
        void var4_11;
        void var3_7;
        int classSkillTreeCount = 0;
        for (Map<Integer, L2SkillLearn> map : this._classSkillTrees.values()) {
            classSkillTreeCount += map.size();
        }
        int trasferSkillTreeCount = 0;
        for (Map<Integer, L2SkillLearn> map : this._transferSkillTrees.values()) {
            trasferSkillTreeCount += map.size();
        }
        boolean bl = false;
        for (L2SkillLearn l2SkillLearn : this._fishingSkillTree.values()) {
            if (!l2SkillLearn.getRaces().contains((Object)Race.DWARF)) continue;
            ++var3_7;
        }
        boolean bl2 = false;
        for (L2SkillLearn pledgeSkill : this._pledgeSkillTree.values()) {
            if (!pledgeSkill.isResidentialSkill()) continue;
            ++var4_11;
        }
        LOG.info("Loaded {} Class Skills for {} Class Skill Trees.", (Object)classSkillTreeCount, (Object)this._classSkillTrees.size());
        LOG.info("Loaded {} Sub-Class Skills.", (Object)this._subClassSkillTree.size());
        LOG.info("Loaded {} Transfer Skills for {} Transfer Skill Trees.", (Object)trasferSkillTreeCount, (Object)this._transferSkillTrees.size());
        LOG.info("Loaded {} Fishing Skills, {} Dwarven only Fishing Skills.", (Object)this._fishingSkillTree.size(), (Object)((int)var3_7));
        LOG.info("Loaded {} Collect Skills.", (Object)this._collectSkillTree.size());
        LOG.info("Loaded {} Pledge Skills, {} for Pledge and {} Residential.", this._pledgeSkillTree.size(), this._pledgeSkillTree.size() - var4_11, (int)var4_11);
        LOG.info("Loaded {} Sub-Pledge Skills.", (Object)this._subPledgeSkillTree.size());
        LOG.info("Loaded {} Transform Skills.", (Object)this._transformSkillTree.size());
        LOG.info("Loaded {} Noble Skills.", (Object)this._nobleSkillTree.size());
        LOG.info("Loaded {} Hero Skills.", (Object)this._heroSkillTree.size());
        LOG.info("Loaded {} Game Master Skills.", (Object)this._gameMasterSkillTree.size());
        LOG.info("Loaded {} Game Master Aura Skills.", (Object)this._gameMasterAuraSkillTree.size());
        int n = this._commonSkillTree.size();
        if (n > 0) {
            LOG.info("Loaded {} Common Skills to all classes.", (Object)n);
        }
    }

    public static SkillTreesData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final SkillTreesData INSTANCE = new SkillTreesData();

        private SingletonHolder() {
        }
    }
}

