/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.transform.Transform;
import com.l2jserver.gameserver.model.actor.transform.TransformLevelData;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.holders.AdditionalItemHolder;
import com.l2jserver.gameserver.model.holders.AdditionalSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class TransformData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(TransformData.class);
    private final Map<Integer, Transform> _transformData = new HashMap<Integer, Transform>();

    protected TransformData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._transformData.clear();
        this.parseDatapackDirectory("data/stats/transformations", false);
        LOG.info("Loaded {} transform templates.", (Object)this._transformData.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"transform".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                Transform transform = new Transform(set);
                for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    boolean isMale = "Male".equalsIgnoreCase(cd.getNodeName());
                    if (!"Male".equalsIgnoreCase(cd.getNodeName()) && !"Female".equalsIgnoreCase(cd.getNodeName())) continue;
                    TransformTemplate templateData = null;
                    block31: for (Node z = cd.getFirstChild(); z != null; z = z.getNextSibling()) {
                        switch (z.getNodeName()) {
                            case "common": {
                                Node s;
                                block32: for (s = z.getFirstChild(); s != null; s = s.getNextSibling()) {
                                    switch (s.getNodeName()) {
                                        case "base": 
                                        case "stats": 
                                        case "defense": 
                                        case "magicDefense": 
                                        case "collision": 
                                        case "moving": {
                                            attrs = s.getAttributes();
                                            for (int i = 0; i < attrs.getLength(); ++i) {
                                                Node att = attrs.item(i);
                                                set.set(att.getNodeName(), att.getNodeValue());
                                            }
                                            continue block32;
                                        }
                                    }
                                }
                                templateData = new TransformTemplate(set);
                                transform.setTemplate(isMale, templateData);
                                continue block31;
                            }
                            case "skills": {
                                int skillLevel;
                                Node s;
                                if (templateData == null) {
                                    templateData = new TransformTemplate(set);
                                    transform.setTemplate(isMale, templateData);
                                }
                                for (s = z.getFirstChild(); s != null; s = s.getNextSibling()) {
                                    if (!"skill".equals(s.getNodeName())) continue;
                                    attrs = s.getAttributes();
                                    int skillId = this.parseInteger(attrs, "id");
                                    skillLevel = this.parseInteger(attrs, "level");
                                    templateData.addSkill(new SkillHolder(skillId, skillLevel));
                                }
                                continue block31;
                            }
                            case "actions": {
                                if (templateData == null) {
                                    templateData = new TransformTemplate(set);
                                    transform.setTemplate(isMale, templateData);
                                }
                                set.set("actions", z.getTextContent());
                                int[] actions = set.getIntArray("actions", " ");
                                templateData.setBasicActionList(new ExBasicActionList(actions));
                                continue block31;
                            }
                            case "additionalSkills": {
                                int skillLevel;
                                Node s;
                                if (templateData == null) {
                                    templateData = new TransformTemplate(set);
                                    transform.setTemplate(isMale, templateData);
                                }
                                for (s = z.getFirstChild(); s != null; s = s.getNextSibling()) {
                                    if (!"skill".equals(s.getNodeName())) continue;
                                    attrs = s.getAttributes();
                                    int skillId = this.parseInteger(attrs, "id");
                                    skillLevel = this.parseInteger(attrs, "level");
                                    int minLevel = this.parseInteger(attrs, "minLevel");
                                    templateData.addAdditionalSkill(new AdditionalSkillHolder(skillId, skillLevel, minLevel));
                                }
                                continue block31;
                            }
                            case "items": {
                                Node s;
                                if (templateData == null) {
                                    templateData = new TransformTemplate(set);
                                    transform.setTemplate(isMale, templateData);
                                }
                                for (s = z.getFirstChild(); s != null; s = s.getNextSibling()) {
                                    if (!"item".equals(s.getNodeName())) continue;
                                    attrs = s.getAttributes();
                                    int itemId = this.parseInteger(attrs, "id");
                                    boolean allowed = this.parseBoolean(attrs, "allowed");
                                    templateData.addAdditionalItem(new AdditionalItemHolder(itemId, allowed));
                                }
                                continue block31;
                            }
                            case "levels": {
                                if (templateData == null) {
                                    templateData = new TransformTemplate(set);
                                    transform.setTemplate(isMale, templateData);
                                }
                                StatsSet levelsSet = new StatsSet();
                                for (Node s = z.getFirstChild(); s != null; s = s.getNextSibling()) {
                                    if (!"level".equals(s.getNodeName())) continue;
                                    attrs = s.getAttributes();
                                    for (int i = 0; i < attrs.getLength(); ++i) {
                                        Node att = attrs.item(i);
                                        levelsSet.set(att.getNodeName(), att.getNodeValue());
                                    }
                                }
                                templateData.addLevelData(new TransformLevelData(levelsSet));
                            }
                        }
                    }
                }
                this._transformData.put(transform.getId(), transform);
            }
        }
    }

    public Transform getTransform(int id) {
        return this._transformData.get(id);
    }

    public boolean transformPlayer(int id, L2PcInstance player) {
        Transform transform = this.getTransform(id);
        if (transform != null) {
            player.transform(transform);
        }
        return transform != null;
    }

    public static TransformData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TransformData _instance = new TransformData();

        private SingletonHolder() {
        }
    }
}

