/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemHPBonusData;
import com.l2jserver.gameserver.engines.DocumentEngine;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.item.ItemCreate;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.util.GMAudit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTable {
    private static final Logger LOG = LoggerFactory.getLogger(ItemTable.class);
    private static final Logger LOG_ITEM = LoggerFactory.getLogger("item");
    public static final Map<String, Integer> SLOTS = new HashMap<String, Integer>();
    private L2Item[] _allTemplates;
    private final Map<Integer, L2EtcItem> _etcItems = new HashMap<Integer, L2EtcItem>();
    private final Map<Integer, L2Armor> _armors = new HashMap<Integer, L2Armor>();
    private final Map<Integer, L2Weapon> _weapons = new HashMap<Integer, L2Weapon>();

    public static ItemTable getInstance() {
        return SingletonHolder._instance;
    }

    protected ItemTable() {
        this.load();
    }

    private void load() {
        long start = System.currentTimeMillis();
        int highest = 0;
        this._armors.clear();
        this._etcItems.clear();
        this._weapons.clear();
        for (L2Item item : DocumentEngine.getInstance().loadItems()) {
            if (highest < item.getId()) {
                highest = item.getId();
            }
            if (item instanceof L2EtcItem) {
                L2EtcItem etc = (L2EtcItem)item;
                this._etcItems.put(item.getId(), etc);
                continue;
            }
            if (item instanceof L2Armor) {
                L2Armor armor = (L2Armor)item;
                this._armors.put(item.getId(), armor);
                continue;
            }
            this._weapons.put(item.getId(), (L2Weapon)item);
        }
        this.buildFastLookupTable(highest);
        LOG.info("Loaded {} Etc items.", (Object)this._etcItems.size());
        LOG.info("Loaded {} Armor items.", (Object)this._armors.size());
        LOG.info("Loaded {} Weapon items.", (Object)this._weapons.size());
        LOG.info("Loaded {} items total in {}ms.", (Object)(this._etcItems.size() + this._armors.size() + this._weapons.size()), (Object)(System.currentTimeMillis() - start));
    }

    private void buildFastLookupTable(int size) {
        L2Item item;
        LOG.info("Highest item Id used {}.", (Object)size);
        this._allTemplates = new L2Item[size + 1];
        Iterator<L2Item> iterator = this._armors.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = iterator.next();
        }
        iterator = this._weapons.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = (L2Weapon)iterator.next();
        }
        iterator = this._etcItems.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = (L2EtcItem)iterator.next();
        }
    }

    public L2Item getTemplate(int id) {
        if (id >= this._allTemplates.length || id < 0) {
            return null;
        }
        return this._allTemplates[id];
    }

    public L2ItemInstance createItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        int objectId = IdFactory.getInstance().getNextId();
        L2ItemInstance item = new L2ItemInstance(objectId, itemId);
        if (process.equalsIgnoreCase("loot")) {
            L2EventMonsterInstance eventMonster;
            L2Attackable raid;
            if (reference instanceof L2Attackable && (raid = (L2Attackable)reference).isRaid()) {
                if (raid.getFirstCommandChannelAttacked() != null && !Configuration.character().autoLootRaids()) {
                    item.setOwnerId(raid.getFirstCommandChannelAttacked().getLeaderObjectId());
                    ScheduledFuture<?> itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), Configuration.character().getRaidLootRightsInterval());
                    item.setItemLootSchedule(itemLootShedule);
                }
            } else if (!Configuration.character().autoLoot() || reference instanceof L2EventMonsterInstance && (eventMonster = (L2EventMonsterInstance)reference).eventDropOnGround()) {
                item.setOwnerId(actor.getObjectId());
                ScheduledFuture<?> itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), 15000L);
                item.setItemLootSchedule(itemLootShedule);
            }
        }
        if (Configuration.general().debug()) {
            LOG.info("Item created object Id {} and item Id {}.", (Object)item.getObjectId(), (Object)itemId);
        }
        L2World.getInstance().storeObject(item);
        if (item.isStackable() && count > 1L) {
            item.setCount(count);
        }
        if (Configuration.general().logItems() && !process.equals("Reset") && (!Configuration.general().logItemsSmallLog() || Configuration.general().logItemsSmallLog() && (item.isEquipable() || item.getId() == 57)) && item.getItemType() != EtcItemType.ARROW && item.getItemType() != EtcItemType.SHOT) {
            LOG_ITEM.info("CREATED {} by {}, referenced by {}.", item, actor, reference);
        }
        if (actor != null && actor.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                L2Object object = (L2Object)reference;
                referenceName = object.getName() != null ? object.getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
            if (Configuration.general().gmAudit()) {
                GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + itemId + " count: " + count + " name: " + item.getItemName() + " objId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
        EventDispatcher.getInstance().notifyEventAsync(new ItemCreate(process, item, actor, reference), item.getItem());
        return item;
    }

    public L2ItemInstance createItem(String process, int itemId, int count, L2PcInstance actor) {
        return this.createItem(process, itemId, count, actor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            long old = item.getCount();
            item.setCount(0L);
            item.setOwnerId(0);
            item.setItemLocation(ItemLocation.VOID);
            item.setLastChange(3);
            L2World.getInstance().removeObject(item);
            IdFactory.getInstance().releaseId(item.getObjectId());
            if (Configuration.general().logItems() && (!Configuration.general().logItemsSmallLog() || Configuration.general().logItemsSmallLog() && (item.isEquipable() || item.getId() == 57)) && item.getItemType() != EtcItemType.ARROW && item.getItemType() != EtcItemType.SHOT) {
                LOG_ITEM.info("DELETED {} amount {} by {}, referenced by {}.", item, old, actor, reference);
            }
            if (actor != null && actor.isGM()) {
                String targetName;
                String referenceName = "no-reference";
                if (reference instanceof L2Object) {
                    L2Object object = (L2Object)reference;
                    referenceName = object.getName() != null ? object.getName() : "no-name";
                } else if (reference instanceof String) {
                    referenceName = (String)reference;
                }
                String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
                if (Configuration.general().gmAudit()) {
                    GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + item.getId() + " count: " + item.getCount() + " itemObjId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
                }
            }
            if (item.getItem().isPetItem()) {
                try (Connection con = ConnectionFactory.getInstance().getConnection();
                     PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");){
                    statement.setInt(1, item.getObjectId());
                    statement.execute();
                }
                catch (Exception ex) {
                    LOG.warn("Could not delete pet object Id {}!", (Object)item.getObjectId(), (Object)ex);
                }
            }
        }
    }

    public void reload() {
        this.load();
        EnchantItemHPBonusData.getInstance().load();
    }

    public Set<Integer> getAllArmorsId() {
        return this._armors.keySet();
    }

    public Set<Integer> getAllWeaponsId() {
        return this._weapons.keySet();
    }

    public int getArraySize() {
        return this._allTemplates.length;
    }

    static {
        SLOTS.put("shirt", 1);
        SLOTS.put("lbracelet", 0x200000);
        SLOTS.put("rbracelet", 0x100000);
        SLOTS.put("talisman", 0x400000);
        SLOTS.put("chest", 1024);
        SLOTS.put("fullarmor", 32768);
        SLOTS.put("head", 64);
        SLOTS.put("hair", 65536);
        SLOTS.put("hairall", 524288);
        SLOTS.put("underwear", 1);
        SLOTS.put("back", 8192);
        SLOTS.put("neck", 8);
        SLOTS.put("legs", 2048);
        SLOTS.put("feet", 4096);
        SLOTS.put("gloves", 512);
        SLOTS.put("chest,legs", 3072);
        SLOTS.put("belt", 0x10000000);
        SLOTS.put("rhand", 128);
        SLOTS.put("lhand", 256);
        SLOTS.put("lrhand", 16384);
        SLOTS.put("rear;lear", 6);
        SLOTS.put("rfinger;lfinger", 48);
        SLOTS.put("wolf", -100);
        SLOTS.put("greatwolf", -104);
        SLOTS.put("hatchling", -101);
        SLOTS.put("strider", -102);
        SLOTS.put("babypet", -103);
        SLOTS.put("none", 0);
        SLOTS.put("onepiece", 32768);
        SLOTS.put("hair2", 262144);
        SLOTS.put("dhair", 524288);
        SLOTS.put("alldress", 131072);
        SLOTS.put("deco1", 0x400000);
        SLOTS.put("waist", 0x10000000);
    }

    private static class SingletonHolder {
        protected static final ItemTable _instance = new ItemTable();

        private SingletonHolder() {
        }
    }

    protected static class ResetOwner
    implements Runnable {
        L2ItemInstance _item;

        public ResetOwner(L2ItemInstance item) {
            this._item = item;
        }

        @Override
        public void run() {
            this._item.setOwnerId(0);
            this._item.setItemLootSchedule(null);
        }
    }
}

