/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.idfactory;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.util.file.filter.PrimeFinder;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitSetIDFactory
extends IdFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BitSetIDFactory.class);
    private BitSet _freeIds;
    private AtomicInteger _freeIdCount;
    private AtomicInteger _nextFreeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BitSetIDFactory() {
        Class<BitSetIDFactory> clazz = BitSetIDFactory.class;
        synchronized (BitSetIDFactory.class) {
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new BitSetCapacityCheck(), 30000L, 30000L);
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOG.info("{} Ids available.", (Object)this._freeIds.size());
            return;
        }
    }

    public void initialize() {
        try {
            this._freeIds = new BitSet(PrimeFinder.nextPrime(100000));
            this._freeIds.clear();
            this._freeIdCount = new AtomicInteger(0x6FFFFFFF);
            Integer[] integerArray = this.extractUsedObjectIDTable();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int usedObjectId = integerArray[i];
                int objectID = usedObjectId - 0x10000000;
                if (objectID < 0) {
                    LOG.warn("Object Id {} in DB is less than minimum ID of {}!", (Object)usedObjectId, (Object)0x10000000);
                    continue;
                }
                this._freeIds.set(usedObjectId - 0x10000000);
                this._freeIdCount.decrementAndGet();
            }
            this._nextFreeId = new AtomicInteger(this._freeIds.nextClearBit(0));
            this._initialized = true;
        }
        catch (Exception ex) {
            this._initialized = false;
            LOG.error("Could not be initialized properly!", ex);
        }
    }

    @Override
    public synchronized void releaseId(int objectId) {
        if (objectId - 0x10000000 > -1) {
            this._freeIds.clear(objectId - 0x10000000);
            this._freeIdCount.incrementAndGet();
        } else {
            LOG.warn("Release objectID {} failed (< {}).", (Object)objectId, (Object)0x10000000);
        }
    }

    @Override
    public synchronized int getNextId() {
        int newID = this._nextFreeId.get();
        this._freeIds.set(newID);
        this._freeIdCount.decrementAndGet();
        int nextFree = this._freeIds.nextClearBit(newID);
        if (nextFree < 0) {
            nextFree = this._freeIds.nextClearBit(0);
        }
        if (nextFree < 0) {
            if (this._freeIds.size() < 0x6FFFFFFF) {
                this.increaseBitSetCapacity();
            } else {
                throw new NullPointerException("Ran out of valid Id's.");
            }
        }
        this._nextFreeId.set(nextFree);
        return newID + 0x10000000;
    }

    @Override
    public synchronized int size() {
        return this._freeIdCount.get();
    }

    protected synchronized int usedIdCount() {
        return this.size() - 0x10000000;
    }

    protected synchronized boolean reachingBitSetCapacity() {
        return PrimeFinder.nextPrime(this.usedIdCount() * 11 / 10) > this._freeIds.size();
    }

    protected synchronized void increaseBitSetCapacity() {
        BitSet newBitSet = new BitSet(PrimeFinder.nextPrime(this.usedIdCount() * 11 / 10));
        newBitSet.or(this._freeIds);
        this._freeIds = newBitSet;
    }

    protected class BitSetCapacityCheck
    implements Runnable {
        protected BitSetCapacityCheck() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BitSetIDFactory bitSetIDFactory = BitSetIDFactory.this;
            synchronized (bitSetIDFactory) {
                if (BitSetIDFactory.this.reachingBitSetCapacity()) {
                    BitSetIDFactory.this.increaseBitSetCapacity();
                }
            }
        }
    }
}

