/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class AntiFeedManager {
    public static final int GAME_ID = 0;
    public static final int OLYMPIAD_ID = 1;
    public static final int TVT_ID = 2;
    public static final int L2EVENT_ID = 3;
    private final Map<Integer, Long> _lastDeathTimes = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Map<Integer, AtomicInteger>> _eventIPs = new ConcurrentHashMap<Integer, Map<Integer, AtomicInteger>>();

    protected AntiFeedManager() {
    }

    public void setLastDeathTime(int objectId) {
        this._lastDeathTimes.put(objectId, System.currentTimeMillis());
    }

    public boolean check(L2Character attacker, L2Character target) {
        if (!Configuration.customs().antiFeedEnable()) {
            return true;
        }
        if (target == null) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (Configuration.customs().getAntiFeedInterval() > 0 && this._lastDeathTimes.containsKey(targetPlayer.getObjectId()) && System.currentTimeMillis() - this._lastDeathTimes.get(targetPlayer.getObjectId()) < TimeUnit.SECONDS.toMillis(Configuration.customs().getAntiFeedInterval())) {
            return false;
        }
        if (Configuration.customs().antiFeedDualbox() && attacker != null) {
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer == null) {
                return false;
            }
            L2GameClient targetClient = targetPlayer.getClient();
            L2GameClient attackerClient = attackerPlayer.getClient();
            if (targetClient == null || attackerClient == null || targetClient.isDetached() || attackerClient.isDetached()) {
                return !Configuration.customs().antiFeedDisconnectedAsDualbox();
            }
            return !targetClient.getConnectionAddress().equals(attackerClient.getConnectionAddress());
        }
        return true;
    }

    public void clear() {
        this._lastDeathTimes.clear();
    }

    public void registerEvent(int eventId) {
        this._eventIPs.putIfAbsent(eventId, new ConcurrentHashMap());
    }

    public boolean tryAddPlayer(int eventId, L2PcInstance player, int max) {
        return this.tryAddClient(eventId, player.getClient(), max);
    }

    public boolean tryAddClient(int eventId, L2GameClient client, int max) {
        if (client == null) {
            return false;
        }
        Map<Integer, AtomicInteger> event = this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        AtomicInteger connectionCount = event.computeIfAbsent(addrHash, k -> new AtomicInteger());
        int whiteListCount = Configuration.customs().getDualboxCheckWhitelist().getOrDefault(addrHash, 0);
        if (whiteListCount < 0 || connectionCount.get() + 1 <= max + whiteListCount) {
            connectionCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public boolean removePlayer(int eventId, L2PcInstance player) {
        return this.removeClient(eventId, player.getClient());
    }

    public boolean removeClient(int eventId, L2GameClient client) {
        if (client == null) {
            return false;
        }
        Map<Integer, AtomicInteger> event = this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        return event.computeIfPresent(addrHash, (k, v) -> {
            if (v.decrementAndGet() == 0) {
                return null;
            }
            return v;
        }) != null;
    }

    public void onDisconnect(L2GameClient client) {
        if (client == null) {
            return;
        }
        this._eventIPs.forEach((k, v) -> this.removeClient((int)k, client));
    }

    public void clear(int eventId) {
        Map<Integer, AtomicInteger> event = this._eventIPs.get(eventId);
        if (event != null) {
            event.clear();
        }
    }

    public int getLimit(L2PcInstance player, int max) {
        return this.getLimit(player.getClient(), max);
    }

    public int getLimit(L2GameClient client, int max) {
        if (client == null) {
            return max;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = max;
        if (Configuration.customs().getDualboxCheckWhitelist().containsKey(addrHash)) {
            limit += Configuration.customs().getDualboxCheckWhitelist().get(addrHash).intValue();
        }
        return limit;
    }

    public static AntiFeedManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AntiFeedManager _instance = new AntiFeedManager();

        private SingletonHolder() {
        }
    }
}

