/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.entity.Fort;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FortSiegeGuardManager {
    private static final Logger LOG = LoggerFactory.getLogger(FortSiegeGuardManager.class);
    private final Fort _fort;
    private final Map<Integer, List<L2Spawn>> _siegeGuards = new HashMap<Integer, List<L2Spawn>>();

    public FortSiegeGuardManager(Fort fort) {
        this._fort = fort;
    }

    public void spawnSiegeGuard() {
        try {
            List<L2Spawn> monsterList = this._siegeGuards.get(this.getFort().getResidenceId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.doSpawn();
                    if (spawnDat.getRespawnDelay() == 0) {
                        spawnDat.stopRespawn();
                        continue;
                    }
                    spawnDat.startRespawn();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error spawning siege guards for fort {}: {}", this.getFort().getName(), e.getMessage(), e);
        }
    }

    public void unspawnSiegeGuard() {
        try {
            List<L2Spawn> monsterList = this._siegeGuards.get(this.getFort().getResidenceId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.stopRespawn();
                    if (spawnDat.getLastSpawn() == null) continue;
                    spawnDat.getLastSpawn().doDie(spawnDat.getLastSpawn());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error despawning siege guards for fort {}: {}", this.getFort().getName(), e.getMessage(), e);
        }
    }

    void loadSiegeGuard() {
        this._siegeGuards.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT npcId, x, y, z, heading, respawnDelay FROM fort_siege_guards WHERE fortId = ?");){
            int fortId = this.getFort().getResidenceId();
            ps.setInt(1, fortId);
            try (ResultSet rs = ps.executeQuery();){
                ArrayList<L2Spawn> siegeGuardSpawns = new ArrayList<L2Spawn>();
                while (rs.next()) {
                    L2Spawn spawn = new L2Spawn(rs.getInt("npcId"));
                    spawn.setAmount(1);
                    spawn.setX(rs.getInt("x"));
                    spawn.setY(rs.getInt("y"));
                    spawn.setZ(rs.getInt("z"));
                    spawn.setHeading(rs.getInt("heading"));
                    spawn.setRespawnDelay(rs.getInt("respawnDelay"));
                    spawn.setLocationId(0);
                    siegeGuardSpawns.add(spawn);
                }
                this._siegeGuards.put(fortId, siegeGuardSpawns);
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading siege guard for fort {}: {}", this.getFort().getName(), e.getMessage(), e);
        }
    }

    public Fort getFort() {
        return this._fort;
    }

    public Map<Integer, List<L2Spawn>> getSiegeGuardSpawn() {
        return this._siegeGuards;
    }
}

