/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.instancemanager.tasks.PenaltyRemoveTask;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameAddPlayer;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangeTeam;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameRemovePlayer;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class HandysBlockCheckerManager {
    private static final ArenaParticipantsHolder[] _arenaPlayers = new ArenaParticipantsHolder[4];
    private static final Map<Integer, Integer> _arenaVotes = new HashMap<Integer, Integer>();
    private static final Map<Integer, Boolean> _arenaStatus = new HashMap<Integer, Boolean>();
    protected static Set<Integer> _registrationPenalty = Collections.synchronizedSet(new HashSet());

    public synchronized int getArenaVotes(int arenaId) {
        return _arenaVotes.get(arenaId);
    }

    public synchronized void increaseArenaVotes(int arena) {
        ArenaParticipantsHolder holder;
        int newVotes = _arenaVotes.get(arena) + 1;
        if (newVotes > (holder = _arenaPlayers[arena]).getAllPlayers().size() / 2 && !holder.getEvent().isStarted()) {
            this.clearArenaVotes(arena);
            if (holder.getBlueTeamSize() == 0 || holder.getRedTeamSize() == 0) {
                return;
            }
            if (Configuration.general().isHBCEFairPlay()) {
                holder.checkAndShuffle();
            }
            ThreadPoolManager.getInstance().executeGeneral(new BlockCheckerEngine.StartEvent(holder.getEvent()));
        } else {
            _arenaVotes.put(arena, newVotes);
        }
    }

    public synchronized void clearArenaVotes(int arena) {
        _arenaVotes.put(arena, 0);
    }

    protected HandysBlockCheckerManager() {
        _arenaStatus.put(0, false);
        _arenaStatus.put(1, false);
        _arenaStatus.put(2, false);
        _arenaStatus.put(3, false);
        _arenaVotes.put(0, 0);
        _arenaVotes.put(1, 0);
        _arenaVotes.put(2, 0);
        _arenaVotes.put(3, 0);
    }

    public ArenaParticipantsHolder getHolder(int arena) {
        return _arenaPlayers[arena];
    }

    public void startUpParticipantsQueue() {
        for (int i = 0; i < 4; ++i) {
            HandysBlockCheckerManager._arenaPlayers[i] = new ArenaParticipantsHolder(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlayerToArena(L2PcInstance player, int arenaId) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arenaId];
        synchronized (arenaParticipantsHolder) {
            boolean isRed;
            for (int i = 0; i < 4; ++i) {
                if (!_arenaPlayers[i].getAllPlayers().contains(player)) continue;
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_MATCH_WAITING_LIST);
                msg.addCharName(player);
                player.sendPacket(msg);
                return false;
            }
            if (player.isCursedWeaponEquipped()) {
                player.sendPacket(SystemMessageId.CANNOT_REGISTER_PROCESSING_CURSED_WEAPON);
                return false;
            }
            if (player.isOnEvent() || player.isInOlympiadMode()) {
                player.sendMessage("Couldnt register you due other event participation");
                return false;
            }
            if (OlympiadManager.getInstance().isRegistered(player)) {
                OlympiadManager.getInstance().unRegisterNoble(player);
                player.sendPacket(SystemMessageId.COLISEUM_OLYMPIAD_KRATEIS_APPLICANTS_CANNOT_PARTICIPATE);
            }
            if (_registrationPenalty.contains(player.getObjectId())) {
                player.sendPacket(SystemMessageId.CANNOT_REQUEST_REGISTRATION_10_SECS_AFTER);
                return false;
            }
            if (holder.getBlueTeamSize() < holder.getRedTeamSize()) {
                holder.addPlayer(player, 1);
                isRed = false;
            } else {
                holder.addPlayer(player, 0);
                isRed = true;
            }
            holder.broadCastPacketToTeam(new ExCubeGameAddPlayer(player, isRed));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(L2PcInstance player, int arenaId, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arenaId];
        synchronized (arenaParticipantsHolder) {
            int teamSize;
            boolean isRed = team == 0;
            holder.removePlayer(player, team);
            holder.broadCastPacketToTeam(new ExCubeGameRemovePlayer(player, isRed));
            int n = teamSize = isRed ? holder.getRedTeamSize() : holder.getBlueTeamSize();
            if (teamSize == 0) {
                holder.getEvent().endEventAbnormally();
            }
            _registrationPenalty.add(player.getObjectId());
            this.schedulePenaltyRemoval(player.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePlayerToTeam(L2PcInstance player, int arena, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arena];
        synchronized (arenaParticipantsHolder) {
            boolean isFromRed = holder.getRedPlayers().contains(player);
            if (isFromRed && holder.getBlueTeamSize() == 6) {
                player.sendMessage("The team is full");
                return;
            }
            if (!isFromRed && holder.getRedTeamSize() == 6) {
                player.sendMessage("The team is full");
                return;
            }
            int futureTeam = isFromRed ? 1 : 0;
            holder.addPlayer(player, futureTeam);
            if (isFromRed) {
                holder.removePlayer(player, 0);
            } else {
                holder.removePlayer(player, 1);
            }
            holder.broadCastPacketToTeam(new ExCubeGameChangeTeam(player, isFromRed));
        }
    }

    public synchronized void clearPaticipantQueueByArenaId(int arenaId) {
        _arenaPlayers[arenaId].clearPlayers();
    }

    public boolean arenaIsBeingUsed(int arenaId) {
        if (arenaId < 0 || arenaId > 3) {
            return false;
        }
        return _arenaStatus.get(arenaId);
    }

    public void setArenaBeingUsed(int arenaId) {
        _arenaStatus.put(arenaId, true);
    }

    public void setArenaFree(int arenaId) {
        _arenaStatus.put(arenaId, false);
    }

    public void onDisconnect(L2PcInstance player) {
        int arena = player.getBlockCheckerArena();
        int team = this.getHolder(arena).getPlayerTeam(player);
        HandysBlockCheckerManager.getInstance().removePlayer(player, arena, team);
        if (player.getTeam() != Team.NONE) {
            long count;
            player.stopAllEffects();
            player.setTeam(Team.NONE);
            PcInventory inv = player.getInventory();
            if (inv.getItemByItemId(13787) != null) {
                count = inv.getInventoryItemCount(13787, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
            }
            if (inv.getItemByItemId(13788) != null) {
                count = inv.getInventoryItemCount(13788, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
            }
            player.setInsideZone(ZoneId.PVP, false);
            player.teleToLocation(-57478, -60367, -2370);
        }
    }

    public void removePenalty(int objectId) {
        _registrationPenalty.remove(objectId);
    }

    private void schedulePenaltyRemoval(int objId) {
        ThreadPoolManager.getInstance().scheduleGeneral(new PenaltyRemoveTask(objId), 10000L);
    }

    public static HandysBlockCheckerManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HandysBlockCheckerManager _instance = new HandysBlockCheckerManager();

        private SingletonHolder() {
        }
    }
}

