/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionInstance;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ItemAuctionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ItemAuctionManager.class);
    private final Map<Integer, ItemAuctionInstance> _managerInstances = new HashMap<Integer, ItemAuctionInstance>();
    private final AtomicInteger _auctionIds = new AtomicInteger(1);

    protected ItemAuctionManager() {
        if (!Configuration.general().itemAuctionEnabled()) {
            LOG.info("Auction Manager disabled by config.");
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT auctionId FROM item_auction ORDER BY auctionId DESC LIMIT 0, 1");){
            if (rs.next()) {
                this._auctionIds.set(rs.getInt(1) + 1);
            }
        }
        catch (Exception e) {
            LOG.error("Failed loading auctions!", e);
        }
        File file = new File(Configuration.server().getDatapackRoot(), "data/ItemAuctions.xml");
        if (!file.exists()) {
            LOG.warn("Missing ItemAuctions.xml!");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node na = doc.getFirstChild(); na != null; na = na.getNextSibling()) {
                if (!"list".equalsIgnoreCase(na.getNodeName())) continue;
                for (Node nb = na.getFirstChild(); nb != null; nb = nb.getNextSibling()) {
                    if (!"instance".equalsIgnoreCase(nb.getNodeName())) continue;
                    NamedNodeMap nab = nb.getAttributes();
                    int instanceId = Integer.parseInt(nab.getNamedItem("id").getNodeValue());
                    if (this._managerInstances.containsKey(instanceId)) {
                        throw new Exception("Dublicated instanceId " + instanceId);
                    }
                    ItemAuctionInstance instance = new ItemAuctionInstance(instanceId, this._auctionIds, nb);
                    this._managerInstances.put(instanceId, instance);
                }
            }
            LOG.info("Loaded " + this._managerInstances.size() + " auction manager instance(s).");
        }
        catch (Exception e) {
            LOG.error("Failed loading auctions from xml!", e);
        }
    }

    public void shutdown() {
        for (ItemAuctionInstance instance : this._managerInstances.values()) {
            instance.shutdown();
        }
    }

    public ItemAuctionInstance getManagerInstance(int instanceId) {
        return this._managerInstances.get(instanceId);
    }

    public int getNextAuctionId() {
        return this._auctionIds.getAndIncrement();
    }

    public static void deleteAuction(int auctionId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            try (PreparedStatement ps = con.prepareStatement("DELETE FROM item_auction WHERE auctionId=?");){
                ps.setInt(1, auctionId);
                ps.execute();
            }
            ps = con.prepareStatement("DELETE FROM item_auction_bid WHERE auctionId=?");
            try {
                ps.setInt(1, auctionId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed deleting auction ID {}!", (Object)auctionId, (Object)e);
        }
    }

    public static ItemAuctionManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ItemAuctionManager INSTANCE = new ItemAuctionManager();

        private SingletonHolder() {
        }
    }
}

