/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.tasks.MessageDeletionTask;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailManager {
    private static final Logger LOG = LoggerFactory.getLogger(MailManager.class);
    private final Map<Integer, Message> _messages = new ConcurrentHashMap<Integer, Message>();

    protected MailManager() {
        this.load();
    }

    private void load() {
        int count = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT * FROM messages ORDER BY expiration");){
            while (rs.next()) {
                Message msg = new Message(rs);
                int msgId = msg.getId();
                this._messages.put(msgId, msg);
                ++count;
                long expiration = msg.getExpiration();
                if (expiration < System.currentTimeMillis()) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), 10000L);
                    continue;
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), expiration - System.currentTimeMillis());
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading from database!", ex);
        }
        LOG.info("Successfully loaded {} messages.", (Object)count);
    }

    public Message getMessage(int msgId) {
        return this._messages.get(msgId);
    }

    public Collection<Message> getMessages() {
        return this._messages.values();
    }

    public boolean hasUnreadPost(L2PcInstance player) {
        int objectId = player.getObjectId();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || !msg.isUnread()) continue;
            return true;
        }
        return false;
    }

    public int getInboxSize(int objectId) {
        int size = 0;
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            ++size;
        }
        return size;
    }

    public int getOutboxSize(int objectId) {
        int size = 0;
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            ++size;
        }
        return size;
    }

    public List<Message> getInbox(int objectId) {
        ArrayList<Message> inbox = new ArrayList<Message>();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            inbox.add(msg);
        }
        return inbox;
    }

    public List<Message> getOutbox(int objectId) {
        ArrayList<Message> outbox = new ArrayList<Message>();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            outbox.add(msg);
        }
        return outbox;
    }

    public void sendMessage(Message msg) {
        this._messages.put(msg.getId(), msg);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = Message.getStatement(msg, con);){
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error saving message Id {}!", (Object)msg.getId(), (Object)ex);
        }
        L2PcInstance receiver = L2World.getInstance().getPlayer(msg.getReceiverId());
        if (receiver != null) {
            receiver.sendPacket(ExNoticePostArrived.valueOf(true));
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msg.getId()), msg.getExpiration() - System.currentTimeMillis());
    }

    public void markAsReadInDb(int msgId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isUnread=FALSE WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error marking as read message Id {}!", (Object)msgId, (Object)ex);
        }
    }

    public void markAsDeletedBySenderInDb(int msgId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isDeletedBySender=TRUE WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error marking as deleted by sender message Id {}!", (Object)msgId, (Object)ex);
        }
    }

    public void markAsDeletedByReceiverInDb(int msgId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isDeletedByReceiver=TRUE WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error marking as deleted by receiver message Id {}!", (Object)msgId, (Object)ex);
        }
    }

    public void removeAttachmentsInDb(int msgId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET hasAttachments=FALSE WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error removing attachments in message Id {}!", (Object)msgId, (Object)ex);
        }
    }

    public void deleteMessageInDb(int msgId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM messages WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.warn("There has been an error deleting message Id {}!", (Object)msgId, (Object)ex);
        }
        this._messages.remove(msgId);
        IdFactory.getInstance().releaseId(msgId);
    }

    public static MailManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final MailManager INSTANCE = new MailManager();

        private SingletonHolder() {
        }
    }
}

