/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2MapRegion;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.model.zone.type.L2RespawnZone;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MapRegionManager
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(MapRegionManager.class);
    private static final Map<String, L2MapRegion> REGIONS = new HashMap<String, L2MapRegion>();
    private static final String DEFAULT_RESPAWN = "talking_island_town";

    protected MapRegionManager() {
        this.load();
    }

    @Override
    public void load() {
        REGIONS.clear();
        this.parseDatapackDirectory("data/mapregion", false);
        LOG.info("Loaded {} map regions.", (Object)REGIONS.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"region".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                String name = attrs.getNamedItem("name").getNodeValue();
                String town = attrs.getNamedItem("town").getNodeValue();
                int locId = this.parseInteger(attrs, "locId");
                int castle = this.parseInteger(attrs, "castle");
                int bbs = this.parseInteger(attrs, "bbs");
                L2MapRegion region = new L2MapRegion(name, town, locId, castle, bbs);
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    attrs = c.getAttributes();
                    if ("respawnPoint".equalsIgnoreCase(c.getNodeName())) {
                        int spawnX = this.parseInteger(attrs, "X");
                        int spawnY = this.parseInteger(attrs, "Y");
                        int spawnZ = this.parseInteger(attrs, "Z");
                        boolean other = this.parseBoolean(attrs, "isOther", false);
                        boolean chaotic = this.parseBoolean(attrs, "isChaotic", false);
                        boolean banish = this.parseBoolean(attrs, "isBanish", false);
                        if (other) {
                            region.addOtherSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        if (chaotic) {
                            region.addChaoticSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        if (banish) {
                            region.addBanishSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        region.addSpawn(spawnX, spawnY, spawnZ);
                        continue;
                    }
                    if ("map".equalsIgnoreCase(c.getNodeName())) {
                        region.addMap(this.parseInteger(attrs, "X"), this.parseInteger(attrs, "Y"));
                        continue;
                    }
                    if (!"banned".equalsIgnoreCase(c.getNodeName())) continue;
                    region.addBannedRace(attrs.getNamedItem("race").getNodeValue(), attrs.getNamedItem("point").getNodeValue());
                }
                REGIONS.put(name, region);
            }
        }
    }

    public L2MapRegion getMapRegion(int locX, int locY) {
        for (L2MapRegion region : REGIONS.values()) {
            if (!region.isZoneInRegion(this.getMapRegionX(locX), this.getMapRegionY(locY))) continue;
            return region;
        }
        return null;
    }

    public int getMapRegionLocId(int locX, int locY) {
        L2MapRegion region = this.getMapRegion(locX, locY);
        if (region != null) {
            return region.getLocId();
        }
        return 0;
    }

    public L2MapRegion getMapRegion(L2Object obj) {
        return this.getMapRegion(obj.getX(), obj.getY());
    }

    public int getMapRegionLocId(L2Object obj) {
        return this.getMapRegionLocId(obj.getX(), obj.getY());
    }

    public int getMapRegionX(int posX) {
        return (posX >> 15) + 9 + 11;
    }

    public int getMapRegionY(int posY) {
        return (posY >> 15) + 10 + 8;
    }

    public String getClosestTownName(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return "Aden Castle Town";
        }
        return region.getTown();
    }

    public int getAreaCastle(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return 0;
        }
        return region.getCastle();
    }

    public Location getTeleToLocation(L2Character activeChar, TeleportWhereType teleportWhere) {
        if (activeChar.isPlayer()) {
            Location loc;
            Instance inst;
            Castle castle;
            L2PcInstance player = activeChar.getActingPlayer();
            if (player.getClan() != null && !player.isFlyingMounted() && !player.isFlying()) {
                L2ClanHallZone zone;
                ClanHall clanhall;
                if (teleportWhere == TeleportWhereType.CLANHALL && (clanhall = ClanHallManager.getInstance().getAbstractHallByOwner(player.getClan())) != null && (zone = clanhall.getZone()) != null && !player.isFlyingMounted()) {
                    if (player.getKarma() > 0) {
                        return zone.getChaoticSpawnLoc();
                    }
                    return zone.getSpawnLoc();
                }
                if (teleportWhere == TeleportWhereType.CASTLE) {
                    castle = CastleManager.getInstance().getCastleByOwner(player.getClan());
                    if (!(castle != null || (castle = CastleManager.getInstance().getCastle(player)) != null && castle.getSiege().isInProgress() && castle.getSiege().getDefenderClan(player.getClan()) != null)) {
                        castle = null;
                    }
                    if (castle != null && castle.getResidenceId() > 0) {
                        if (player.getKarma() > 0) {
                            return castle.getResidenceZone().getChaoticSpawnLoc();
                        }
                        return castle.getResidenceZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.FORTRESS) {
                    Fort fort = FortManager.getInstance().getFortByOwner(player.getClan());
                    if (!(fort != null || (fort = FortManager.getInstance().getFort(player)) != null && fort.getSiege().isInProgress() && fort.getOwnerClan() == player.getClan())) {
                        fort = null;
                    }
                    if (fort != null && fort.getResidenceId() > 0) {
                        if (player.getKarma() > 0) {
                            return fort.getResidenceZone().getChaoticSpawnLoc();
                        }
                        return fort.getResidenceZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.SIEGEFLAG) {
                    SiegableHall sHall;
                    List<L2Npc> flags;
                    castle = CastleManager.getInstance().getCastle(player);
                    Fort fort = FortManager.getInstance().getFort(player);
                    ClanHall clanhall2 = ClanHallManager.getInstance().getNearbyAbstractHall(activeChar.getX(), activeChar.getY(), 10000);
                    L2SiegeFlagInstance tw_flag = TerritoryWarManager.getInstance().getHQForClan(player.getClan());
                    if (tw_flag != null) {
                        return tw_flag.getLocation();
                    }
                    if (castle != null) {
                        List<L2Npc> flags2;
                        if (castle.getSiege().isInProgress() && (flags2 = castle.getSiege().getFlag(player.getClan())) != null && !flags2.isEmpty()) {
                            return flags2.get(0).getLocation();
                        }
                    } else if (fort != null) {
                        List<L2Npc> flags3;
                        if (fort.getSiege().isInProgress() && (flags3 = fort.getSiege().getFlag(player.getClan())) != null && !flags3.isEmpty()) {
                            return flags3.get(0).getLocation();
                        }
                    } else if (clanhall2 != null && clanhall2.isSiegableHall() && (flags = (sHall = (SiegableHall)clanhall2).getSiege().getFlag(player.getClan())) != null && !flags.isEmpty()) {
                        return flags.get(0).getLocation();
                    }
                }
            }
            if (player.getKarma() > 0) {
                try {
                    L2RespawnZone zone = ZoneManager.getInstance().getZone(player, L2RespawnZone.class);
                    if (zone != null) {
                        return this.getRestartRegion(activeChar, zone.getRespawnPoint((L2PcInstance)activeChar)).getChaoticSpawnLoc();
                    }
                    return this.getMapRegion(activeChar).getChaoticSpawnLoc();
                }
                catch (Exception e) {
                    if (player.isFlyingMounted()) {
                        return REGIONS.get("union_base_of_kserth").getChaoticSpawnLoc();
                    }
                    return REGIONS.get(DEFAULT_RESPAWN).getChaoticSpawnLoc();
                }
            }
            castle = CastleManager.getInstance().getCastle(player);
            if (castle != null && castle.getSiege().isInProgress() && (castle.getSiege().checkIsDefender(player.getClan()) || castle.getSiege().checkIsAttacker(player.getClan())) && SevenSigns.getInstance().getSealOwner(3) == 2) {
                return castle.getResidenceZone().getOtherSpawnLoc();
            }
            if (player.getInstanceId() > 0 && (inst = InstanceManager.getInstance().getInstance(player.getInstanceId())) != null && (loc = inst.getExitLoc()) != null) {
                return loc;
            }
        }
        try {
            L2RespawnZone zone = ZoneManager.getInstance().getZone(activeChar, L2RespawnZone.class);
            if (zone != null) {
                return this.getRestartRegion(activeChar, zone.getRespawnPoint((L2PcInstance)activeChar)).getSpawnLoc();
            }
            return this.getMapRegion(activeChar).getSpawnLoc();
        }
        catch (Exception e) {
            return REGIONS.get(DEFAULT_RESPAWN).getSpawnLoc();
        }
    }

    public L2MapRegion getRestartRegion(L2Character activeChar, String point) {
        try {
            L2PcInstance player = (L2PcInstance)activeChar;
            L2MapRegion region = REGIONS.get(point);
            if (region.getBannedRace().containsKey((Object)player.getRace())) {
                this.getRestartRegion(player, region.getBannedRace().get((Object)player.getRace()));
            }
            return region;
        }
        catch (Exception e) {
            return REGIONS.get(DEFAULT_RESPAWN);
        }
    }

    public L2MapRegion getMapRegionByName(String regionName) {
        return REGIONS.get(regionName);
    }

    public static MapRegionManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final MapRegionManager INSTANCE = new MapRegionManager();

        private SingletonHolder() {
        }
    }
}

