/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.holders.PunishmentHolder;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PunishmentManager {
    private static final Logger LOG = LoggerFactory.getLogger(PunishmentManager.class);
    private final Map<PunishmentAffect, PunishmentHolder> _tasks = new ConcurrentHashMap<PunishmentAffect, PunishmentHolder>();

    protected PunishmentManager() {
        this.load();
    }

    private void load() {
        for (PunishmentAffect affect : PunishmentAffect.values()) {
            this._tasks.put(affect, new PunishmentHolder());
        }
        int initiated = 0;
        int expired = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM punishments");){
            while (rs.next()) {
                int id = rs.getInt("id");
                String key = rs.getString("key");
                PunishmentAffect affect = PunishmentAffect.getByName(rs.getString("affect"));
                PunishmentType type = PunishmentType.getByName(rs.getString("type"));
                long expirationTime = rs.getLong("expiration");
                String reason = rs.getString("reason");
                String punishedBy = rs.getString("punishedBy");
                if (type == null || affect == null) continue;
                if (expirationTime > 0L && System.currentTimeMillis() > expirationTime) {
                    ++expired;
                    continue;
                }
                ++initiated;
                this._tasks.get((Object)affect).addPunishment(new PunishmentTask(id, key, affect, type, expirationTime, reason, punishedBy, true));
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while loading punishments!", ex);
        }
        LOG.info("Loaded {} active and {} expired punishments.", (Object)initiated, (Object)expired);
    }

    public void startPunishment(PunishmentTask task) {
        this._tasks.get((Object)task.getAffect()).addPunishment(task);
    }

    public void stopPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentTask task = this.getPunishment(key, affect, type);
        if (task != null) {
            this._tasks.get((Object)affect).stopPunishment(task);
        }
    }

    public boolean hasPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentHolder holder = this._tasks.get((Object)affect);
        return holder.hasPunishment(String.valueOf(key), type);
    }

    public long getPunishmentExpiration(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentTask p = this.getPunishment(key, affect, type);
        return p != null ? p.getExpirationTime() : 0L;
    }

    private PunishmentTask getPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        return this._tasks.get((Object)affect).getPunishment(String.valueOf(key), type);
    }

    public static PunishmentManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PunishmentManager _instance = new PunishmentManager();

        private SingletonHolder() {
        }
    }
}

