/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.tasks.StartMovingTask;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import com.l2jserver.gameserver.model.L2WalkRoute;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.WalkInfo;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.tasks.npc.walker.ArrivedTask;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcMoveNodeArrived;
import com.l2jserver.gameserver.model.holders.NpcRoutesHolder;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class WalkingManager
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(WalkingManager.class);
    public static final byte NO_REPEAT = -1;
    public static final byte REPEAT_GO_BACK = 0;
    public static final byte REPEAT_GO_FIRST = 1;
    public static final byte REPEAT_TELE_FIRST = 2;
    public static final byte REPEAT_RANDOM = 3;
    private final Map<String, L2WalkRoute> _routes = new HashMap<String, L2WalkRoute>();
    private final Map<Integer, WalkInfo> _activeRoutes = new HashMap<Integer, WalkInfo>();
    private final Map<Integer, NpcRoutesHolder> _routesToAttach = new HashMap<Integer, NpcRoutesHolder>();

    protected WalkingManager() {
        this.load();
    }

    @Override
    public void load() {
        this.parseDatapackFile("data/Routes.xml");
        LOG.info("Loaded {} walking routes.", (Object)this._routes.size());
    }

    @Override
    public void parseDocument(Document doc) {
        Node n = doc.getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            String repeatStyle;
            if (!d.getNodeName().equals("route")) continue;
            String routeName = this.parseString(d.getAttributes(), "name");
            boolean repeat = this.parseBoolean(d.getAttributes(), "repeat");
            byte repeatType = switch (repeatStyle = d.getAttributes().getNamedItem("repeatStyle").getNodeValue().toLowerCase()) {
                case "back" -> 0;
                case "cycle" -> 1;
                case "conveyor" -> 2;
                case "random" -> 3;
                default -> -1;
            };
            ArrayList<L2NpcWalkerNode> list = new ArrayList<L2NpcWalkerNode>();
            for (Node r = d.getFirstChild(); r != null; r = r.getNextSibling()) {
                NamedNodeMap attrs;
                if (r.getNodeName().equals("point")) {
                    attrs = r.getAttributes();
                    int x = this.parseInteger(attrs, "X");
                    int y = this.parseInteger(attrs, "Y");
                    int z = this.parseInteger(attrs, "Z");
                    int delay = this.parseInteger(attrs, "delay");
                    boolean run = this.parseBoolean(attrs, "run");
                    NpcStringId npcString = null;
                    String chatString = null;
                    Node node = attrs.getNamedItem("string");
                    if (node != null) {
                        chatString = node.getNodeValue();
                    } else {
                        node = attrs.getNamedItem("npcString");
                        if (node != null) {
                            npcString = NpcStringId.getNpcStringId(node.getNodeValue());
                            if (npcString == null) {
                                LOG.warn("Unknown NPC String {} for route {}!", (Object)node.getNodeValue(), (Object)routeName);
                                continue;
                            }
                        } else {
                            node = attrs.getNamedItem("npcStringId");
                            if (node != null) {
                                npcString = NpcStringId.getNpcStringId(Integer.parseInt(node.getNodeValue()));
                            }
                        }
                    }
                    list.add(new L2NpcWalkerNode(x, y, z, delay, run, npcString, chatString));
                    continue;
                }
                if (!r.getNodeName().equals("target")) continue;
                attrs = r.getAttributes();
                try {
                    int npcId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int x = Integer.parseInt(attrs.getNamedItem("spawnX").getNodeValue());
                    int y = Integer.parseInt(attrs.getNamedItem("spawnY").getNodeValue());
                    int z = Integer.parseInt(attrs.getNamedItem("spawnZ").getNodeValue());
                    NpcRoutesHolder holder = this._routesToAttach.containsKey(npcId) ? this._routesToAttach.get(npcId) : new NpcRoutesHolder();
                    holder.addRoute(routeName, new Location(x, y, z));
                    this._routesToAttach.put(npcId, holder);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Error in target definition for route {}!", (Object)routeName);
                }
            }
            this._routes.put(routeName, new L2WalkRoute(routeName, list, repeat, false, repeatType));
        }
    }

    public boolean isOnWalk(L2Npc npc) {
        L2MonsterInstance monster = null;
        if (npc.isMonster()) {
            monster = ((L2MonsterInstance)npc).getLeader() == null ? (L2MonsterInstance)npc : ((L2MonsterInstance)npc).getLeader();
        }
        if (monster != null && !this.isRegistered(monster) || !this.isRegistered(npc)) {
            return false;
        }
        WalkInfo walk = monster != null ? this._activeRoutes.get(monster.getObjectId()) : this._activeRoutes.get(npc.getObjectId());
        return !walk.isStoppedByAttack() && !walk.isSuspended();
    }

    public L2WalkRoute getRoute(String route) {
        return this._routes.get(route);
    }

    public boolean isRegistered(L2Npc npc) {
        return this._activeRoutes.containsKey(npc.getObjectId());
    }

    public String getRouteName(L2Npc npc) {
        return this._activeRoutes.containsKey(npc.getObjectId()) ? this._activeRoutes.get(npc.getObjectId()).getRoute().getName() : "";
    }

    public void startMoving(L2Npc npc, String routeName) {
        if (this._routes.containsKey(routeName) && npc != null && !npc.isDead()) {
            if (!this._activeRoutes.containsKey(npc.getObjectId())) {
                if (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ACTIVE || npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                    WalkInfo walk = new WalkInfo(routeName);
                    if (npc.isDebug()) {
                        walk.setLastAction(System.currentTimeMillis());
                    }
                    L2NpcWalkerNode node = walk.getCurrentNode();
                    if (npc.getX() == node.getX() && npc.getY() == node.getY()) {
                        walk.calculateNextNode(npc);
                        node = walk.getCurrentNode();
                        npc.sendDebugMessage("Route '" + routeName + "': spawn point is same with first waypoint, adjusted to next");
                    }
                    if (!npc.isInsideRadius(node, 3000, true, false)) {
                        String message = "Route '" + routeName + "': NPC (id=" + npc.getId() + ", x=" + npc.getX() + ", y=" + npc.getY() + ", z=" + npc.getZ() + ") is too far from starting point (node x=" + node.getX() + ", y=" + node.getY() + ", z=" + node.getZ() + ", range=" + npc.calculateDistance(node, true, true) + "), walking will not start!";
                        LOG.warn(message);
                        npc.sendDebugMessage(message);
                        return;
                    }
                    npc.sendDebugMessage("Starting to move at route '" + routeName + "'");
                    npc.setIsRunning(node.runToLocation());
                    npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, node);
                    walk.setWalkCheckTask(ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new StartMovingTask(npc, routeName), 60000L, 60000L));
                    npc.getKnownList().startTrackingTask();
                    this._activeRoutes.put(npc.getObjectId(), walk);
                } else {
                    npc.sendDebugMessage("Failed to start moving along route '" + routeName + "', scheduled");
                    ThreadPoolManager.getInstance().scheduleGeneral(new StartMovingTask(npc, routeName), 60000L);
                }
            } else if (this._activeRoutes.containsKey(npc.getObjectId()) && (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ACTIVE || npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE)) {
                WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
                if (walk == null) {
                    return;
                }
                if (walk.isBlocked() || walk.isSuspended()) {
                    npc.sendDebugMessage("Failed to continue moving along route '" + routeName + "' (operation is blocked)");
                    return;
                }
                walk.setBlocked(true);
                L2NpcWalkerNode node = walk.getCurrentNode();
                npc.sendDebugMessage("Route '" + routeName + "', continuing to node " + walk.getCurrentNodeId());
                npc.setIsRunning(node.runToLocation());
                npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, node);
                walk.setBlocked(false);
                walk.setStoppedByAttack(false);
            } else {
                npc.sendDebugMessage("Failed to continue moving along route '" + routeName + "' (wrong AI state - " + String.valueOf((Object)npc.getAI().getIntention()) + ")");
            }
        }
    }

    public synchronized void cancelMoving(L2Npc npc) {
        WalkInfo walk = this._activeRoutes.remove(npc.getObjectId());
        if (walk != null) {
            walk.getWalkCheckTask().cancel(true);
            npc.getKnownList().stopTrackingTask();
        }
    }

    public void resumeMoving(L2Npc npc) {
        WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
        if (walk != null) {
            walk.setSuspended(false);
            walk.setStoppedByAttack(false);
            this.startMoving(npc, walk.getRoute().getName());
        }
    }

    public void stopMoving(L2Npc npc, boolean suspend, boolean stoppedByAttack) {
        L2MonsterInstance monster = null;
        if (npc.isMonster()) {
            monster = ((L2MonsterInstance)npc).getLeader() == null ? (L2MonsterInstance)npc : ((L2MonsterInstance)npc).getLeader();
        }
        if (monster != null && !this.isRegistered(monster) || !this.isRegistered(npc)) {
            return;
        }
        WalkInfo walk = monster != null ? this._activeRoutes.get(monster.getObjectId()) : this._activeRoutes.get(npc.getObjectId());
        walk.setSuspended(suspend);
        walk.setStoppedByAttack(stoppedByAttack);
        if (monster != null) {
            monster.stopMove(null);
            monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            npc.stopMove(null);
            npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void onArrived(L2Npc npc) {
        if (this._activeRoutes.containsKey(npc.getObjectId())) {
            L2NpcWalkerNode node;
            EventDispatcher.getInstance().notifyEventAsync(new NpcMoveNodeArrived(npc), npc);
            WalkInfo walk = this._activeRoutes.get(npc.getObjectId());
            if (walk.getCurrentNodeId() >= 0 && walk.getCurrentNodeId() < walk.getRoute().getNodesCount() && npc.isInsideRadius(node = walk.getRoute().getNodeList().get(walk.getCurrentNodeId()), 10, false, false)) {
                npc.sendDebugMessage("Route '" + walk.getRoute().getName() + "', arrived to node " + walk.getCurrentNodeId());
                npc.sendDebugMessage("Done in " + (System.currentTimeMillis() - walk.getLastAction()) / 1000L + " s");
                walk.calculateNextNode(npc);
                walk.setBlocked(true);
                if (node.getNpcString() != null) {
                    Broadcast.toKnownPlayers(npc, new NpcSay(npc, 22, node.getNpcString()));
                } else if (!node.getChatText().isEmpty()) {
                    Broadcast.toKnownPlayers(npc, new NpcSay(npc, 22, node.getChatText()));
                }
                if (npc.isDebug()) {
                    walk.setLastAction(System.currentTimeMillis());
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new ArrivedTask(npc, walk), 100L + (long)node.getDelay() * 1000L);
            }
        }
    }

    public void onDeath(L2Npc npc) {
        this.cancelMoving(npc);
    }

    public void onSpawn(L2Npc npc) {
        String routeName;
        if (this._routesToAttach.containsKey(npc.getId()) && !(routeName = this._routesToAttach.get(npc.getId()).getRouteName(npc)).isEmpty()) {
            this.startMoving(npc, routeName);
        }
    }

    public static WalkingManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final WalkingManager INSTANCE = new WalkingManager();

        private SingletonHolder() {
        }
    }
}

