/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockList {
    private static final Logger LOG = LoggerFactory.getLogger(BlockList.class);
    private static final Map<Integer, List<Integer>> OFFLINE_LIST = new ConcurrentHashMap<Integer, List<Integer>>();
    private final L2PcInstance _owner;
    private List<Integer> _blockList;

    public BlockList(L2PcInstance owner) {
        this._owner = owner;
        this._blockList = OFFLINE_LIST.get(owner.getObjectId());
        if (this._blockList == null) {
            this._blockList = BlockList.loadList(this._owner.getObjectId());
        }
    }

    private void addToBlockList(int target) {
        this._blockList.add(target);
        this.persistInDB(target);
    }

    private void removeFromBlockList(int target) {
        this._blockList.remove((Object)target);
        this.removeFromDB(target);
    }

    public void playerLogout() {
        OFFLINE_LIST.put(this._owner.getObjectId(), this._blockList);
    }

    private static List<Integer> loadList(int ObjId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT friendId FROM character_friends WHERE charId=? AND relation=1");){
            ps.setInt(1, ObjId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int friendId = rs.getInt("friendId");
                    if (friendId == ObjId) continue;
                    list.add(friendId);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error found in {} FriendList while loading BlockList: {}", ObjId, e.getMessage(), e);
        }
        return list;
    }

    private void removeFromDB(int targetId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_friends WHERE charId=? AND friendId=? AND relation=1");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, targetId);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not remove blocked player: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void persistInDB(int targetId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO character_friends (charId, friendId, relation) VALUES (?, ?, 1)");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, targetId);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not add blocked player: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean isInBlockList(L2PcInstance target) {
        return this.isInBlockList(target.getObjectId());
    }

    public boolean isInBlockList(int targetId) {
        return this._blockList.contains(targetId);
    }

    private boolean isBlockAll() {
        return this._owner.getMessageRefusal();
    }

    public static boolean isBlocked(L2PcInstance listOwner, L2PcInstance target) {
        BlockList blockList = listOwner.getBlockList();
        return blockList.isBlockAll() || blockList.isInBlockList(target);
    }

    public static boolean isBlocked(L2PcInstance listOwner, int targetId) {
        BlockList blockList = listOwner.getBlockList();
        return blockList.isBlockAll() || blockList.isInBlockList(targetId);
    }

    private void setBlockAll(boolean state) {
        this._owner.setMessageRefusal(state);
    }

    private List<Integer> getBlockList() {
        return this._blockList;
    }

    public static void addToBlockList(L2PcInstance listOwner, int targetId) {
        if (listOwner == null) {
            return;
        }
        if (listOwner.getBlockList().getBlockList().size() >= Configuration.character().getBlockListLimit()) {
            listOwner.sendPacket(SystemMessageId.YOU_CAN_ONLY_ENTER_UP_TO_128_NAMES_IN_YOUR_BLOCK_LIST);
            return;
        }
        String charName = CharNameTable.getInstance().getNameById(targetId);
        if (listOwner.isFriend(targetId)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_IN_FRIENDS_LIST);
            sm.addString(charName);
            listOwner.sendPacket(sm);
            return;
        }
        if (listOwner.getBlockList().getBlockList().contains(targetId)) {
            listOwner.sendMessage("Already in ignore list.");
            return;
        }
        listOwner.getBlockList().addToBlockList(targetId);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_WAS_ADDED_TO_YOUR_IGNORE_LIST);
        sm.addString(charName);
        listOwner.sendPacket(sm);
        L2PcInstance player = L2World.getInstance().getPlayer(targetId);
        if (player != null) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addString(listOwner.getName());
            player.sendPacket(sm);
        }
    }

    public static void removeFromBlockList(L2PcInstance listOwner, int targetId) {
        if (listOwner == null) {
            return;
        }
        String charName = CharNameTable.getInstance().getNameById(targetId);
        if (!listOwner.getBlockList().getBlockList().contains(targetId)) {
            listOwner.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
            return;
        }
        listOwner.getBlockList().removeFromBlockList(targetId);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_WAS_REMOVED_FROM_YOUR_IGNORE_LIST);
        sm.addString(charName);
        listOwner.sendPacket(sm);
    }

    public static boolean isInBlockList(L2PcInstance listOwner, L2PcInstance target) {
        return listOwner.getBlockList().isInBlockList(target);
    }

    public boolean isBlockAll(L2PcInstance listOwner) {
        return listOwner.getBlockList().isBlockAll();
    }

    public static void setBlockAll(L2PcInstance listOwner, boolean newValue) {
        listOwner.getBlockList().setBlockAll(newValue);
    }

    public static void sendListToOwner(L2PcInstance listOwner) {
        int i = 1;
        listOwner.sendPacket(SystemMessageId.BLOCK_LIST_HEADER);
        for (int playerId : listOwner.getBlockList().getBlockList()) {
            listOwner.sendMessage(i++ + ". " + CharNameTable.getInstance().getNameById(playerId));
        }
        listOwner.sendPacket(SystemMessageId.FRIEND_LIST_FOOTER);
    }

    public static boolean isInBlockList(int ownerId, int targetId) {
        L2PcInstance player = L2World.getInstance().getPlayer(ownerId);
        if (player != null) {
            return BlockList.isBlocked(player, targetId);
        }
        if (!OFFLINE_LIST.containsKey(ownerId)) {
            OFFLINE_LIST.put(ownerId, BlockList.loadList(ownerId));
        }
        return OFFLINE_LIST.get(ownerId).contains(targetId);
    }
}

