/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.model.StatsSet;

public class L2AccessLevel {
    private final int _accessLevel;
    private final String _name;
    private L2AccessLevel _childrenAccessLevel = null;
    private final int _child;
    private final int _nameColor;
    private final int _titleColor;
    private final boolean _isGm;
    private final boolean _allowPeaceAttack;
    private final boolean _allowFixedRes;
    private final boolean _allowTransaction;
    private final boolean _allowAltG;
    private final boolean _giveDamage;
    private final boolean _takeAggro;
    private final boolean _gainExp;

    public L2AccessLevel(StatsSet set) {
        this._accessLevel = set.getInt("level");
        this._name = set.getString("name");
        this._nameColor = Integer.decode("0x" + set.getString("nameColor", "FFFFFF"));
        this._titleColor = Integer.decode("0x" + set.getString("titleColor", "FFFFFF"));
        this._child = set.getInt("childAccess", 0);
        this._isGm = set.getBoolean("isGM", false);
        this._allowPeaceAttack = set.getBoolean("allowPeaceAttack", false);
        this._allowFixedRes = set.getBoolean("allowFixedRes", false);
        this._allowTransaction = set.getBoolean("allowTransaction", true);
        this._allowAltG = set.getBoolean("allowAltg", false);
        this._giveDamage = set.getBoolean("giveDamage", true);
        this._takeAggro = set.getBoolean("takeAggro", true);
        this._gainExp = set.getBoolean("gainExp", true);
    }

    public L2AccessLevel() {
        this._accessLevel = 0;
        this._name = "User";
        this._nameColor = Integer.decode("0xFFFFFF");
        this._titleColor = Integer.decode("0xFFFFFF");
        this._child = 0;
        this._isGm = false;
        this._allowPeaceAttack = false;
        this._allowFixedRes = false;
        this._allowTransaction = true;
        this._allowAltG = false;
        this._giveDamage = true;
        this._takeAggro = true;
        this._gainExp = true;
    }

    public int getLevel() {
        return this._accessLevel;
    }

    public String getName() {
        return this._name;
    }

    public int getNameColor() {
        return this._nameColor;
    }

    public int getTitleColor() {
        return this._titleColor;
    }

    public boolean isGm() {
        return this._isGm;
    }

    public boolean allowPeaceAttack() {
        return this._allowPeaceAttack;
    }

    public boolean allowFixedRes() {
        return this._allowFixedRes;
    }

    public boolean allowTransaction() {
        return this._allowTransaction;
    }

    public boolean allowAltG() {
        return this._allowAltG;
    }

    public boolean canGiveDamage() {
        return this._giveDamage;
    }

    public boolean canTakeAggro() {
        return this._takeAggro;
    }

    public boolean canGainExp() {
        return this._gainExp;
    }

    public boolean hasChildAccess(L2AccessLevel accessLevel) {
        if (this._childrenAccessLevel == null) {
            if (this._child <= 0) {
                return false;
            }
            this._childrenAccessLevel = AdminData.getInstance().getAccessLevel(this._child);
        }
        return this._childrenAccessLevel.getLevel() == accessLevel.getLevel() || this._childrenAccessLevel.hasChildAccess(accessLevel);
    }
}

