/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.bbs.service.ForumsBBSManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.sql.impl.CrestTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanJoin;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLeaderChange;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLeave;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanLevelUp;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.itemcontainer.ClanWarehouse;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExSubPledgeSkillAdd;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeReceiveSubPledgeCreated;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDeleteAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillListAdd;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.EnumIntBitmask;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Clan
implements IIdentifiable,
INamable {
    private static final Logger LOG = LoggerFactory.getLogger(L2Clan.class);
    private static final String INSERT_CLAN_DATA = "INSERT INTO clan_data (clan_id,clan_name,clan_level,hasCastle,blood_alliance_count,blood_oath_count,ally_id,ally_name,leader_id,crest_id,crest_large_id,ally_crest_id,new_leader_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_CLAN_DATA = "SELECT * FROM clan_data where clan_id=?";
    public static final int PENALTY_TYPE_CLAN_LEFT = 1;
    public static final int PENALTY_TYPE_CLAN_DISMISSED = 2;
    public static final int PENALTY_TYPE_DISMISS_CLAN = 3;
    public static final int PENALTY_TYPE_DISSOLVE_ALLY = 4;
    public static final int SUBUNIT_ACADEMY = -1;
    public static final int SUBUNIT_ROYAL1 = 100;
    public static final int SUBUNIT_ROYAL2 = 200;
    public static final int SUBUNIT_KNIGHT1 = 1001;
    public static final int SUBUNIT_KNIGHT2 = 1002;
    public static final int SUBUNIT_KNIGHT3 = 2001;
    public static final int SUBUNIT_KNIGHT4 = 2002;
    private String _name;
    private int _clanId;
    private L2ClanMember _leader;
    private final Map<Integer, L2ClanMember> _members = new ConcurrentHashMap<Integer, L2ClanMember>();
    private String _allyName;
    private int _allyId;
    private int _level;
    private int _castleId;
    private int _fortId;
    private int _hideoutId;
    private int _hiredGuards;
    private int _crestId;
    private int _crestLargeId;
    private int _allyCrestId;
    private int _auctionBidAt = 0;
    private long _allyPenaltyExpiryTime;
    private int _allyPenaltyType;
    private long _charPenaltyExpiryTime;
    private long _dissolvingExpiryTime;
    private int _bloodAllianceCount;
    private int _bloodOathCount;
    private final ItemContainer _warehouse = new ClanWarehouse(this);
    private final Set<Integer> _atWarWith = ConcurrentHashMap.newKeySet();
    private final Set<Integer> _atWarAttackers = ConcurrentHashMap.newKeySet();
    private final Map<Integer, Skill> _skills = new ConcurrentHashMap<Integer, Skill>();
    private final Map<Integer, RankPrivs> _privs = new ConcurrentHashMap<Integer, RankPrivs>();
    private final Map<Integer, SubPledge> _subPledges = new ConcurrentHashMap<Integer, SubPledge>();
    private final Map<Integer, Skill> _subPledgeSkills = new ConcurrentHashMap<Integer, Skill>();
    private int _reputationScore = 0;
    private int _rank = 0;
    private String _notice;
    private boolean _noticeEnabled = false;
    private static final int MAX_NOTICE_LENGTH = 8192;
    private int _newLeaderId;
    private final AtomicInteger _siegeKills = new AtomicInteger();
    private final AtomicInteger _siegeDeaths = new AtomicInteger();

    public L2Clan(int clanId) {
        this._clanId = clanId;
        this.initializePrivs();
        this.restore();
        this.getWarehouse().restore();
    }

    public L2Clan(int clanId, String clanName) {
        this._clanId = clanId;
        this._name = clanName;
        this.initializePrivs();
    }

    @Override
    public int getId() {
        return this._clanId;
    }

    public void setClanId(int clanId) {
        this._clanId = clanId;
    }

    public int getLeaderId() {
        return this._leader != null ? this._leader.getObjectId() : 0;
    }

    public L2ClanMember getLeader() {
        return this._leader;
    }

    public void setLeader(L2ClanMember leader) {
        this._leader = leader;
        this._members.put(leader.getObjectId(), leader);
    }

    public void setNewLeader(L2ClanMember member) {
        PreparedStatement ps;
        Connection con;
        L2PcInstance newLeader = member.getPlayerInstance();
        L2ClanMember exMember = this.getLeader();
        L2PcInstance exLeader = exMember.getPlayerInstance();
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanLeaderChange(exMember, member, this), new ListenersContainer[0]);
        if (exLeader != null) {
            if (exLeader.isFlying()) {
                exLeader.dismount();
            }
            if (this.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel()) {
                SiegeManager.getInstance().removeSiegeSkills(exLeader);
            }
            exLeader.getClanPrivileges().clear();
            exLeader.broadcastUserInfo();
        } else {
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    ps = con.prepareStatement("UPDATE characters SET clan_privs = ? WHERE charId = ?");
                    try {
                        ps.setInt(1, 0);
                        ps.setInt(2, this.getLeaderId());
                        ps.execute();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Couldn't update clan privs for old clan leader", e);
            }
        }
        this.setLeader(member);
        if (this.getNewLeaderId() != 0) {
            this.setNewLeaderId(0, true);
        }
        this.updateClanInDB();
        if (exLeader != null) {
            exLeader.setPledgeClass(L2ClanMember.calculatePledgeClass(exLeader));
            exLeader.broadcastUserInfo();
            exLeader.checkItemRestriction();
        }
        if (newLeader != null) {
            newLeader.setPledgeClass(L2ClanMember.calculatePledgeClass(newLeader));
            newLeader.getClanPrivileges().setAll();
            if (this.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel()) {
                SiegeManager.getInstance().addSiegeSkills(newLeader);
            }
            newLeader.broadcastUserInfo();
        } else {
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    ps = con.prepareStatement("UPDATE characters SET clan_privs = ? WHERE charId = ?");
                    try {
                        ps.setInt(1, EnumIntBitmask.getAllBitmask(ClanPrivilege.class));
                        ps.setInt(2, this.getLeaderId());
                        ps.execute();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Couldn't update clan privs for new clan leader", e);
            }
        }
        this.broadcastClanStatus();
        this.broadcastToOnlineMembers((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.CLAN_LEADER_PRIVILEGES_HAVE_BEEN_TRANSFERRED_TO_C1).addString(member.getName())));
        LOG.info("Leader of Clan: {} changed to: {} ex leader: {}", this.getName(), member.getName(), exMember.getName());
    }

    public String getLeaderName() {
        if (this._leader == null) {
            LOG.warn("Clan {} without clan leader!", (Object)this.getName());
            return "";
        }
        return this._leader.getName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    private void addClanMember(L2ClanMember member) {
        this._members.put(member.getObjectId(), member);
    }

    public void addClanMember(L2PcInstance player) {
        L2ClanMember member = new L2ClanMember(this, player);
        member.setPlayerInstance(player);
        this.addClanMember(member);
        player.setClan(this);
        player.setPledgeClass(L2ClanMember.calculatePledgeClass(player));
        player.sendPacket(new PledgeShowMemberListUpdate(player));
        player.sendPacket(new PledgeSkillList(this));
        this.addSkillEffects(player);
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanJoin(member, this), new ListenersContainer[0]);
    }

    public void updateClanMember(L2PcInstance player) {
        L2ClanMember member = new L2ClanMember(player.getClan(), player);
        if (player.isClanLeader()) {
            this.setLeader(member);
        }
        this.addClanMember(member);
    }

    public L2ClanMember getClanMember(String name) {
        for (L2ClanMember temp : this._members.values()) {
            if (!temp.getName().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public L2ClanMember getClanMember(int objectId) {
        return this._members.get(objectId);
    }

    public void removeClanMember(int objectId, long clanJoinExpiryTime) {
        L2PcInstance player;
        L2ClanMember sponsor;
        L2ClanMember apprentice;
        L2ClanMember exMember = this._members.remove(objectId);
        if (exMember == null) {
            LOG.warn("Member Object ID: {} not found in clan while trying to remove", (Object)objectId);
            return;
        }
        int subPledgeLeader = this.getLeaderSubPledge(objectId);
        if (subPledgeLeader != 0) {
            this.getSubPledge(subPledgeLeader).setLeaderId(0);
            this.updateSubPledgeInDB(subPledgeLeader);
        }
        if (exMember.getApprentice() != 0 && (apprentice = this.getClanMember(exMember.getApprentice())) != null) {
            if (apprentice.getPlayerInstance() != null) {
                apprentice.getPlayerInstance().setSponsor(0);
            } else {
                apprentice.setApprenticeAndSponsor(0, 0);
            }
            apprentice.saveApprenticeAndSponsor(0, 0);
        }
        if (exMember.getSponsor() != 0 && (sponsor = this.getClanMember(exMember.getSponsor())) != null) {
            if (sponsor.getPlayerInstance() != null) {
                sponsor.getPlayerInstance().setApprentice(0);
            } else {
                sponsor.setApprenticeAndSponsor(0, 0);
            }
            sponsor.saveApprenticeAndSponsor(0, 0);
        }
        exMember.saveApprenticeAndSponsor(0, 0);
        if (Configuration.character().removeCastleCirclets()) {
            CastleManager.getInstance().removeCirclet(exMember, this.getCastleId());
        }
        if ((player = exMember.getPlayerInstance()) != null) {
            if (!player.isNoble()) {
                player.setTitle("");
            }
            player.setApprentice(0);
            player.setSponsor(0);
            if (player.isClanLeader()) {
                SiegeManager.getInstance().removeSiegeSkills(player);
                player.setClanCreateExpiryTime(System.currentTimeMillis() + Configuration.character().getDaysBeforeCreateAClan());
            }
            this.removeSkillEffects(player);
            if (player.getClan().getCastleId() > 0) {
                CastleManager.getInstance().getCastleByOwner(player.getClan()).removeResidentialSkills(player);
            }
            if (player.getClan().getFortId() > 0) {
                FortManager.getInstance().getFortByOwner(player.getClan()).removeResidentialSkills(player);
            }
            player.sendSkillList();
            player.setClan(null);
            if (exMember.getPledgeType() != -1) {
                player.setClanJoinExpiryTime(clanJoinExpiryTime);
            }
            player.setPledgeClass(L2ClanMember.calculatePledgeClass(player));
            player.broadcastUserInfo();
            player.sendPacket(PledgeShowMemberListDeleteAll.STATIC_PACKET);
        } else {
            this.removeMemberInDatabase(exMember.getObjectId(), clanJoinExpiryTime, this.getLeaderId() == objectId ? System.currentTimeMillis() + Configuration.character().getDaysBeforeCreateAClan() : 0L);
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanLeave(exMember, this), new ListenersContainer[0]);
    }

    public L2ClanMember[] getMembers() {
        return this._members.values().toArray(new L2ClanMember[0]);
    }

    public int getMembersCount() {
        return this._members.size();
    }

    public int getSubPledgeMembersCount(int subpl) {
        int result = 0;
        for (L2ClanMember temp : this._members.values()) {
            if (temp.getPledgeType() != subpl) continue;
            ++result;
        }
        return result;
    }

    public int getMaxNrOfMembers(int pledgeType) {
        int limit = 0;
        switch (pledgeType) {
            case 0: {
                limit = switch (this.getLevel()) {
                    case 3 -> 30;
                    case 2 -> 20;
                    case 1 -> 15;
                    case 0 -> 10;
                    default -> 40;
                };
                break;
            }
            case -1: {
                limit = 20;
                break;
            }
            case 100: 
            case 200: {
                if (this.getLevel() == 11) {
                    limit = 30;
                    break;
                }
                limit = 20;
                break;
            }
            case 1001: 
            case 1002: 
            case 2001: 
            case 2002: {
                limit = switch (this.getLevel()) {
                    case 9, 10, 11 -> 25;
                    default -> 10;
                };
                break;
            }
        }
        return limit;
    }

    public List<L2PcInstance> getOnlineMembers(int exclude) {
        ArrayList<L2PcInstance> onlineMembers = new ArrayList<L2PcInstance>();
        for (L2ClanMember temp : this._members.values()) {
            if (temp == null || !temp.isOnline() || temp.getObjectId() == exclude) continue;
            onlineMembers.add(temp.getPlayerInstance());
        }
        return onlineMembers;
    }

    public int getOnlineMembersCount() {
        int count = 0;
        for (L2ClanMember temp : this._members.values()) {
            if (temp == null || !temp.isOnline()) continue;
            ++count;
        }
        return count;
    }

    public int getAllyId() {
        return this._allyId;
    }

    public String getAllyName() {
        return this._allyName;
    }

    public void setAllyCrestId(int allyCrestId) {
        this._allyCrestId = allyCrestId;
    }

    public int getAllyCrestId() {
        return this._allyCrestId;
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public int getCastleId() {
        return this._castleId;
    }

    public int getFortId() {
        return this._fortId;
    }

    public int getHideoutId() {
        return this._hideoutId;
    }

    public void setCrestId(int crestId) {
        this._crestId = crestId;
    }

    public int getCrestId() {
        return this._crestId;
    }

    public void setCrestLargeId(int crestLargeId) {
        this._crestLargeId = crestLargeId;
    }

    public int getCrestLargeId() {
        return this._crestLargeId;
    }

    public void setAllyId(int allyId) {
        this._allyId = allyId;
    }

    public void setAllyName(String allyName) {
        this._allyName = allyName;
    }

    public void setCastleId(int castleId) {
        this._castleId = castleId;
    }

    public void setFortId(int fortId) {
        this._fortId = fortId;
    }

    public void setHideoutId(int hideoutId) {
        this._hideoutId = hideoutId;
    }

    public boolean isMember(int id) {
        return id != 0 && this._members.containsKey(id);
    }

    public int getBloodAllianceCount() {
        return this._bloodAllianceCount;
    }

    public void increaseBloodAllianceCount() {
        this._bloodAllianceCount += SiegeManager.getInstance().getBloodAllianceReward();
        this.updateBloodAllianceCountInDB();
    }

    public void resetBloodAllianceCount() {
        this._bloodAllianceCount = 0;
        this.updateBloodAllianceCountInDB();
    }

    public void updateBloodAllianceCountInDB() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET blood_alliance_count=? WHERE clan_id=?");){
            ps.setInt(1, this.getBloodAllianceCount());
            ps.setInt(2, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception on updateBloodAllianceCountInDB(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public int getBloodOathCount() {
        return this._bloodOathCount;
    }

    public void increaseBloodOathCount() {
        this._bloodOathCount += Configuration.fortress().getBloodOathCount();
        this.updateBloodOathCountInDB();
    }

    public void resetBloodOathCount() {
        this._bloodOathCount = 0;
        this.updateBloodOathCountInDB();
    }

    public void updateBloodOathCountInDB() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET blood_oath_count=? WHERE clan_id=?");){
            ps.setInt(1, this.getBloodOathCount());
            ps.setInt(2, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception on updateBloodAllianceCountInDB(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void updateClanScoreInDB() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET reputation_score=? WHERE clan_id=?");){
            ps.setInt(1, this.getReputationScore());
            ps.setInt(2, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Exception on updateClanScoreInDb(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void updateClanInDB() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET leader_id=?,ally_id=?,ally_name=?,reputation_score=?,ally_penalty_expiry_time=?,ally_penalty_type=?,char_penalty_expiry_time=?,dissolving_expiry_time=?,new_leader_id=? WHERE clan_id=?");){
            ps.setInt(1, this.getLeaderId());
            ps.setInt(2, this.getAllyId());
            ps.setString(3, this.getAllyName());
            ps.setInt(4, this.getReputationScore());
            ps.setLong(5, this.getAllyPenaltyExpiryTime());
            ps.setInt(6, this.getAllyPenaltyType());
            ps.setLong(7, this.getCharPenaltyExpiryTime());
            ps.setLong(8, this.getDissolvingExpiryTime());
            ps.setInt(9, this.getNewLeaderId());
            ps.setInt(10, this.getId());
            ps.execute();
            if (Configuration.general().debug()) {
                LOG.debug("New clan leader saved in db: {}", (Object)this.getId());
            }
        }
        catch (Exception e) {
            LOG.error("Error saving clan: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void store() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_CLAN_DATA);){
            ps.setInt(1, this.getId());
            ps.setString(2, this.getName());
            ps.setInt(3, this.getLevel());
            ps.setInt(4, this.getCastleId());
            ps.setInt(5, this.getBloodAllianceCount());
            ps.setInt(6, this.getBloodOathCount());
            ps.setInt(7, this.getAllyId());
            ps.setString(8, this.getAllyName());
            ps.setInt(9, this.getLeaderId());
            ps.setInt(10, this.getCrestId());
            ps.setInt(11, this.getCrestLargeId());
            ps.setInt(12, this.getAllyCrestId());
            ps.setInt(13, this.getNewLeaderId());
            ps.execute();
            if (Configuration.general().debug()) {
                LOG.debug("New clan saved in db: {}", (Object)this.getId());
            }
        }
        catch (Exception e) {
            LOG.error("Error saving new clan: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void removeMemberInDatabase(int playerId, long clanJoinExpiryTime, long clanCreateExpiryTime) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("UPDATE characters SET clanid=0, title=?, clan_join_expiry_time=?, clan_create_expiry_time=?, clan_privs=0, wantspeace=0, subpledge=0, lvl_joined_academy=0, apprentice=0, sponsor=0 WHERE charId=?");
             PreparedStatement ps2 = con.prepareStatement("UPDATE characters SET apprentice=0 WHERE apprentice=?");
             PreparedStatement ps3 = con.prepareStatement("UPDATE characters SET sponsor=0 WHERE sponsor=?");){
            ps1.setString(1, "");
            ps1.setLong(2, clanJoinExpiryTime);
            ps1.setLong(3, clanCreateExpiryTime);
            ps1.setInt(4, playerId);
            ps1.execute();
            ps2.setInt(1, playerId);
            ps2.execute();
            ps3.setInt(1, playerId);
            ps3.execute();
        }
        catch (Exception e) {
            LOG.error("Error removing clan member: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void restore() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_CLAN_DATA);){
            block37: {
                ps.setInt(1, this.getId());
                try (ResultSet clanData = ps.executeQuery();){
                    if (!clanData.next()) break block37;
                    this.setName(clanData.getString("clan_name"));
                    this.setLevel(clanData.getInt("clan_level"));
                    this.setCastleId(clanData.getInt("hasCastle"));
                    this._bloodAllianceCount = clanData.getInt("blood_alliance_count");
                    this._bloodOathCount = clanData.getInt("blood_oath_count");
                    this.setAllyId(clanData.getInt("ally_id"));
                    this.setAllyName(clanData.getString("ally_name"));
                    this.setAllyPenaltyExpiryTime(clanData.getLong("ally_penalty_expiry_time"), clanData.getInt("ally_penalty_type"));
                    if (this.getAllyPenaltyExpiryTime() < System.currentTimeMillis()) {
                        this.setAllyPenaltyExpiryTime(0L, 0);
                    }
                    this.setCharPenaltyExpiryTime(clanData.getLong("char_penalty_expiry_time"));
                    if (this.getCharPenaltyExpiryTime() + Configuration.character().getDaysBeforeJoinAClan() < System.currentTimeMillis()) {
                        this.setCharPenaltyExpiryTime(0L);
                    }
                    this.setDissolvingExpiryTime(clanData.getLong("dissolving_expiry_time"));
                    this.setCrestId(clanData.getInt("crest_id"));
                    this.setCrestLargeId(clanData.getInt("crest_large_id"));
                    this.setAllyCrestId(clanData.getInt("ally_crest_id"));
                    this.setReputationScore(clanData.getInt("reputation_score"), false);
                    this.setAuctionBidAt(clanData.getInt("auction_bid_at"), false);
                    this.setNewLeaderId(clanData.getInt("new_leader_id"), false);
                    int leaderId = clanData.getInt("leader_id");
                    ps.clearParameters();
                    try (PreparedStatement select = con.prepareStatement("SELECT char_name,level,classid,charId,title,power_grade,subpledge,apprentice,sponsor,sex,race FROM characters WHERE clanid=?");){
                        select.setInt(1, this.getId());
                        try (ResultSet clanMember = select.executeQuery();){
                            while (clanMember.next()) {
                                L2ClanMember member = new L2ClanMember(this, clanMember);
                                if (member.getObjectId() == leaderId) {
                                    this.setLeader(member);
                                    continue;
                                }
                                this.addClanMember(member);
                            }
                        }
                    }
                }
            }
            if (Configuration.general().debug() && this.getName() != null) {
                LOG.info("Restored clan data for \"" + this.getName() + "\" from database.");
            }
            this.restoreSubPledges();
            this.restoreRankPrivs();
            this.restoreSkills();
            this.restoreNotice();
        }
        catch (Exception ex) {
            LOG.error("Error restoring clan data for clan {}!", (Object)this.getId(), (Object)ex);
        }
    }

    private void restoreNotice() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT enabled,notice FROM clan_notices WHERE clan_id=?");){
            ps.setInt(1, this.getId());
            try (ResultSet noticeData = ps.executeQuery();){
                while (noticeData.next()) {
                    this._noticeEnabled = noticeData.getBoolean("enabled");
                    this._notice = noticeData.getString("notice");
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error restoring clan notice: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void storeNotice(String notice, boolean enabled) {
        if (notice == null) {
            notice = "";
        }
        if (notice.length() > 8192) {
            notice = notice.substring(0, 8191);
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO clan_notices (clan_id,notice,enabled) values (?,?,?) ON DUPLICATE KEY UPDATE notice=?,enabled=?");){
            ps.setInt(1, this.getId());
            ps.setString(2, notice);
            ps.setBoolean(3, enabled);
            ps.setString(4, notice);
            ps.setBoolean(5, enabled);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error could not store clan notice: {}", (Object)e.getMessage(), (Object)e);
        }
        this._notice = notice;
        this._noticeEnabled = enabled;
    }

    public void setNoticeEnabled(boolean enabled) {
        this.storeNotice(this._notice, enabled);
    }

    public void setNotice(String notice) {
        this.storeNotice(notice, this._noticeEnabled);
    }

    public boolean isNoticeEnabled() {
        return this._noticeEnabled;
    }

    public String getNotice() {
        if (this._notice == null) {
            return "";
        }
        return this._notice;
    }

    private void restoreSkills() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT skill_id,skill_level,sub_pledge_id FROM clan_skills WHERE clan_id=?");){
            ps.setInt(1, this.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("skill_id");
                    int level = rs.getInt("skill_level");
                    Skill skill = SkillData.getInstance().getSkill(id, level);
                    int subType = rs.getInt("sub_pledge_id");
                    if (subType == -2) {
                        this._skills.put(skill.getId(), skill);
                        continue;
                    }
                    if (subType == 0) {
                        this._subPledgeSkills.put(skill.getId(), skill);
                        continue;
                    }
                    SubPledge subunit = this._subPledges.get(subType);
                    if (subunit != null) {
                        subunit.addNewSkill(skill);
                        continue;
                    }
                    LOG.info("Missing subpledge " + subType + " for clan " + String.valueOf(this) + ", skill skipped.");
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error restoring clan skills: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public final Skill[] getAllSkills() {
        return this._skills.values().toArray(new Skill[0]);
    }

    public Map<Integer, Skill> getSkills() {
        return this._skills;
    }

    public Skill addSkill(Skill newSkill) {
        Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
        }
        return oldSkill;
    }

    public Skill addNewSkill(Skill newSkill) {
        return this.addNewSkill(newSkill, -2);
    }

    public Skill addNewSkill(Skill newSkill, int subType) {
        Skill oldSkill = null;
        if (newSkill != null) {
            block30: {
                if (subType == -2) {
                    oldSkill = this._skills.put(newSkill.getId(), newSkill);
                } else if (subType == 0) {
                    oldSkill = this._subPledgeSkills.put(newSkill.getId(), newSkill);
                } else {
                    SubPledge subunit = this.getSubPledge(subType);
                    if (subunit != null) {
                        oldSkill = subunit.addNewSkill(newSkill);
                    } else {
                        LOG.warn("Subpledge {} does not exist for clan {}", (Object)subType, (Object)this);
                        return null;
                    }
                }
                try (Connection con = ConnectionFactory.getInstance().getConnection();){
                    PreparedStatement ps;
                    if (oldSkill != null) {
                        ps = con.prepareStatement("UPDATE clan_skills SET skill_level=? WHERE skill_id=? AND clan_id=?");
                        try {
                            ps.setInt(1, newSkill.getLevel());
                            ps.setInt(2, oldSkill.getId());
                            ps.setInt(3, this.getId());
                            ps.execute();
                            break block30;
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
                    ps = con.prepareStatement("INSERT INTO clan_skills (clan_id,skill_id,skill_level,skill_name,sub_pledge_id) VALUES (?,?,?,?,?)");
                    try {
                        ps.setInt(1, this.getId());
                        ps.setInt(2, newSkill.getId());
                        ps.setInt(3, newSkill.getLevel());
                        ps.setString(4, newSkill.getName());
                        ps.setInt(5, subType);
                        ps.execute();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error could not store clan skills: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_SKILL_S1_ADDED);
            sm.addSkillName(newSkill.getId());
            for (L2ClanMember temp : this._members.values()) {
                if (temp == null || temp.getPlayerInstance() == null || !temp.isOnline()) continue;
                if (subType == -2) {
                    if (newSkill.getMinPledgeClass() > temp.getPlayerInstance().getPledgeClass()) continue;
                    temp.getPlayerInstance().addSkill(newSkill, false);
                    temp.getPlayerInstance().sendPacket(new PledgeSkillListAdd(newSkill.getId(), newSkill.getLevel()));
                    temp.getPlayerInstance().sendPacket(sm);
                    temp.getPlayerInstance().sendSkillList();
                    continue;
                }
                if (temp.getPledgeType() != subType) continue;
                temp.getPlayerInstance().addSkill(newSkill, false);
                temp.getPlayerInstance().sendPacket(new ExSubPledgeSkillAdd(subType, newSkill.getId(), newSkill.getLevel()));
                temp.getPlayerInstance().sendPacket(sm);
                temp.getPlayerInstance().sendSkillList();
            }
        }
        return oldSkill;
    }

    public void addSkillEffects() {
        for (Skill skill : this._skills.values()) {
            for (L2ClanMember temp : this._members.values()) {
                try {
                    if (temp == null || !temp.isOnline() || skill.getMinPledgeClass() > temp.getPlayerInstance().getPledgeClass()) continue;
                    temp.getPlayerInstance().addSkill(skill, false);
                }
                catch (NullPointerException e) {
                    LOG.warn(e.getMessage(), e);
                }
            }
        }
    }

    public void addSkillEffects(L2PcInstance player) {
        if (player == null) {
            return;
        }
        for (Skill skill : this._skills.values()) {
            if (skill.getMinPledgeClass() > player.getPledgeClass()) continue;
            player.addSkill(skill, false);
        }
        if (player.getPledgeType() == 0) {
            for (Skill skill : this._subPledgeSkills.values()) {
                player.addSkill(skill, false);
            }
        } else {
            SubPledge subunit = this.getSubPledge(player.getPledgeType());
            if (subunit == null) {
                return;
            }
            for (Skill skill : subunit.getSkills()) {
                player.addSkill(skill, false);
            }
        }
        if (this._reputationScore < 0) {
            this.skillsStatus(player, true);
        }
    }

    public void removeSkillEffects(L2PcInstance player) {
        if (player == null) {
            return;
        }
        for (Skill skill : this._skills.values()) {
            player.removeSkill(skill, false);
        }
        if (player.getPledgeType() == 0) {
            for (Skill skill : this._subPledgeSkills.values()) {
                player.removeSkill(skill, false);
            }
        } else {
            SubPledge subunit = this.getSubPledge(player.getPledgeType());
            if (subunit == null) {
                return;
            }
            for (Skill skill : subunit.getSkills()) {
                player.removeSkill(skill, false);
            }
        }
    }

    public void skillsStatus(L2PcInstance player, boolean disable) {
        block8: {
            block7: {
                if (player == null) {
                    return;
                }
                for (Skill skill : this._skills.values()) {
                    if (disable) {
                        player.disableSkill(skill, -1L);
                        continue;
                    }
                    player.enableSkill(skill);
                }
                if (player.getPledgeType() != 0) break block7;
                for (Skill skill : this._subPledgeSkills.values()) {
                    if (disable) {
                        player.disableSkill(skill, -1L);
                        continue;
                    }
                    player.enableSkill(skill);
                }
                break block8;
            }
            SubPledge subunit = this.getSubPledge(player.getPledgeType());
            if (subunit == null) break block8;
            for (Skill skill : subunit.getSkills()) {
                if (disable) {
                    player.disableSkill(skill, -1L);
                    continue;
                }
                player.enableSkill(skill);
            }
        }
    }

    public void broadcastToOnlineAllyMembers(L2GameServerPacket packet) {
        for (L2Clan clan : ClanTable.getInstance().getClanAllies(this.getAllyId())) {
            clan.broadcastToOnlineMembers(packet);
        }
    }

    public void broadcastToOnlineMembers(L2GameServerPacket packet) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline()) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public void broadcastCSToOnlineMembers(CreatureSay packet, L2PcInstance broadcaster) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline() || BlockList.isBlocked(member.getPlayerInstance(), broadcaster)) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public void broadcastToOtherOnlineMembers(L2GameServerPacket packet, L2PcInstance player) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline() || member.getPlayerInstance() == player) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public String toString() {
        return this.getName() + "[" + this.getId() + "]";
    }

    public ItemContainer getWarehouse() {
        return this._warehouse;
    }

    public boolean isAtWarWith(int id) {
        return this._atWarWith.contains(id);
    }

    public boolean isAtWarWith(L2Clan clan) {
        return this._atWarWith.contains(clan.getId());
    }

    public boolean isAtWarAttacker(int id) {
        return this._atWarAttackers.contains(id);
    }

    public void setEnemyClan(L2Clan clan) {
        this._atWarWith.add(clan.getId());
    }

    public void setEnemyClan(int id) {
        this._atWarWith.add(id);
    }

    public void setAttackerClan(L2Clan clan) {
        this._atWarAttackers.add(clan.getId());
    }

    public void setAttackerClan(int clan) {
        this._atWarAttackers.add(clan);
    }

    public void deleteEnemyClan(L2Clan clan) {
        this._atWarWith.remove(clan.getId());
    }

    public void deleteAttackerClan(L2Clan clan) {
        this._atWarAttackers.remove(clan.getId());
    }

    public int getHiredGuards() {
        return this._hiredGuards;
    }

    public void incrementHiredGuards() {
        ++this._hiredGuards;
    }

    public boolean isAtWar() {
        return !this._atWarWith.isEmpty();
    }

    public Set<Integer> getWarList() {
        return this._atWarWith;
    }

    public Set<Integer> getAttackerList() {
        return this._atWarAttackers;
    }

    public void broadcastClanStatus() {
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.sendPacket(PledgeShowMemberListDeleteAll.STATIC_PACKET);
            member.sendPacket(new PledgeShowMemberListAll(this, member));
        }
    }

    private void restoreSubPledges() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT sub_pledge_id,name,leader_id FROM clan_subpledges WHERE clan_id=?");){
            ps.setInt(1, this.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("sub_pledge_id");
                    String name = rs.getString("name");
                    int leaderId = rs.getInt("leader_id");
                    SubPledge pledge = new SubPledge(id, name, leaderId);
                    this._subPledges.put(id, pledge);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not restore clan sub-units: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public final SubPledge getSubPledge(int pledgeType) {
        return this._subPledges.get(pledgeType);
    }

    public final SubPledge getSubPledge(String pledgeName) {
        for (SubPledge sp : this._subPledges.values()) {
            if (!sp.getName().equalsIgnoreCase(pledgeName)) continue;
            return sp;
        }
        return null;
    }

    public final SubPledge[] getAllSubPledges() {
        return this._subPledges.values().toArray(new SubPledge[0]);
    }

    public SubPledge createSubPledge(L2PcInstance player, int pledgeType, int leaderId, String subPledgeName) {
        SubPledge subPledge = null;
        if ((pledgeType = this.getAvailablePledgeTypes(pledgeType)) == 0) {
            if (pledgeType == -1) {
                player.sendPacket(SystemMessageId.CLAN_HAS_ALREADY_ESTABLISHED_A_CLAN_ACADEMY);
            } else {
                player.sendMessage("You can't create any more sub-units of this type");
            }
            return null;
        }
        if (this._leader.getObjectId() == leaderId) {
            player.sendMessage("Leader is not correct");
            return null;
        }
        if (pledgeType != -1 && (this.getReputationScore() < Configuration.clan().getCreateRoyalGuardCost() && pledgeType < 1001 || this.getReputationScore() < Configuration.clan().getCreateKnightUnitCost() && pledgeType > 200)) {
            player.sendPacket(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW);
            return null;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO clan_subpledges (clan_id,sub_pledge_id,name,leader_id) values (?,?,?,?)");){
            ps.setInt(1, this.getId());
            ps.setInt(2, pledgeType);
            ps.setString(3, subPledgeName);
            ps.setInt(4, pledgeType != -1 ? leaderId : 0);
            ps.execute();
            subPledge = new SubPledge(pledgeType, subPledgeName, leaderId);
            this._subPledges.put(pledgeType, subPledge);
            if (pledgeType != -1) {
                if (pledgeType < 1001) {
                    this.setReputationScore(this.getReputationScore() - Configuration.clan().getCreateRoyalGuardCost(), true);
                } else {
                    this.setReputationScore(this.getReputationScore() - Configuration.clan().getCreateKnightUnitCost(), true);
                }
            }
            if (Configuration.general().debug()) {
                LOG.debug("New sub_clan saved in db: {}; {}", (Object)this.getId(), (Object)pledgeType);
            }
        }
        catch (Exception e) {
            LOG.error("Error saving sub clan data: {}", (Object)e.getMessage(), (Object)e);
        }
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this._leader.getClan()));
        this.broadcastToOnlineMembers(new PledgeReceiveSubPledgeCreated(subPledge, this._leader.getClan()));
        return subPledge;
    }

    public int getAvailablePledgeTypes(int pledgeType) {
        if (this._subPledges.get(pledgeType) != null) {
            switch (pledgeType) {
                case -1: 
                case 200: 
                case 2002: {
                    pledgeType = 0;
                    break;
                }
                case 100: {
                    pledgeType = this.getAvailablePledgeTypes(200);
                    break;
                }
                case 1001: {
                    pledgeType = this.getAvailablePledgeTypes(1002);
                    break;
                }
                case 1002: {
                    pledgeType = this.getAvailablePledgeTypes(2001);
                    break;
                }
                case 2001: {
                    pledgeType = this.getAvailablePledgeTypes(2002);
                }
            }
        }
        return pledgeType;
    }

    public void updateSubPledgeInDB(int pledgeType) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_subpledges SET leader_id=?, name=? WHERE clan_id=? AND sub_pledge_id=?");){
            ps.setInt(1, this.getSubPledge(pledgeType).getLeaderId());
            ps.setString(2, this.getSubPledge(pledgeType).getName());
            ps.setInt(3, this.getId());
            ps.setInt(4, pledgeType);
            ps.execute();
            if (Configuration.general().debug()) {
                LOG.debug("Subpledge updated in db: {}", (Object)this.getId());
            }
        }
        catch (Exception e) {
            LOG.error("Error updating subpledge: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void restoreRankPrivs() {
        DAOFactory.getInstance().getClanDAO().getPrivileges(this.getId()).forEach((rank, privileges) -> this._privs.get(rank).setPrivs((int)privileges));
    }

    private void initializePrivs() {
        for (int i = 1; i < 10; ++i) {
            this._privs.put(i, new RankPrivs(i, 0, new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false)));
        }
    }

    public EnumIntBitmask<ClanPrivilege> getRankPrivs(int rank) {
        if (this._privs.get(rank) != null) {
            return this._privs.get(rank).getPrivs();
        }
        return new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false);
    }

    public void setRankPrivs(int rank, int privs) {
        RankPrivs rankPrivileges = this._privs.get(rank);
        if (rankPrivileges != null) {
            rankPrivileges.setPrivs(privs);
            DAOFactory.getInstance().getClanDAO().storePrivileges(this.getId(), rank, privs);
            for (L2ClanMember cm : this.getMembers()) {
                if (!cm.isOnline() || cm.getPlayerInstance() == null || cm.getPowerGrade() != rank) continue;
                cm.getPlayerInstance().getClanPrivileges().setBitmask(privs);
                cm.getPlayerInstance().sendPacket(new UserInfo(cm.getPlayerInstance()));
                cm.getPlayerInstance().sendPacket(new ExBrExtraUserInfo(cm.getPlayerInstance()));
            }
            this.broadcastClanStatus();
        } else {
            this._privs.put(rank, new RankPrivs(rank, 0, privs));
            DAOFactory.getInstance().getClanDAO().storePrivileges(this.getId(), rank, privs);
        }
    }

    public final RankPrivs[] getAllRankPrivs() {
        return this._privs.values().toArray(new RankPrivs[0]);
    }

    public int getLeaderSubPledge(int leaderId) {
        int id = 0;
        for (SubPledge sp : this._subPledges.values()) {
            if (sp.getLeaderId() == 0 || sp.getLeaderId() != leaderId) continue;
            id = sp.getId();
        }
        return id;
    }

    public synchronized void addReputationScore(int value, boolean save) {
        this.setReputationScore(this.getReputationScore() + value, save);
    }

    public synchronized void takeReputationScore(int value, boolean save) {
        this.setReputationScore(this.getReputationScore() - value, save);
    }

    private void setReputationScore(int value, boolean save) {
        if (this._reputationScore >= 0 && value < 0) {
            this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.REPUTATION_POINTS_0_OR_LOWER_CLAN_SKILLS_DEACTIVATED));
            for (L2ClanMember member : this._members.values()) {
                if (!member.isOnline() || member.getPlayerInstance() == null) continue;
                this.skillsStatus(member.getPlayerInstance(), true);
            }
        } else if (this._reputationScore < 0 && value >= 0) {
            this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_SKILLS_WILL_BE_ACTIVATED_SINCE_REPUTATION_IS_0_OR_HIGHER));
            for (L2ClanMember member : this._members.values()) {
                if (!member.isOnline() || member.getPlayerInstance() == null) continue;
                this.skillsStatus(member.getPlayerInstance(), false);
            }
        }
        this._reputationScore = value;
        if (this._reputationScore > 100000000) {
            this._reputationScore = 100000000;
        }
        if (this._reputationScore < -100000000) {
            this._reputationScore = -100000000;
        }
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this));
        if (save) {
            this.updateClanScoreInDB();
        }
    }

    public int getReputationScore() {
        return this._reputationScore;
    }

    public void setRank(int rank) {
        this._rank = rank;
    }

    public int getRank() {
        return this._rank;
    }

    public int getAuctionBidAt() {
        return this._auctionBidAt;
    }

    public void setAuctionBidAt(int id, boolean storeInDb) {
        this._auctionBidAt = id;
        if (storeInDb) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET auction_bid_at=? WHERE clan_id=?");){
                ps.setInt(1, id);
                ps.setInt(2, this.getId());
                ps.execute();
            }
            catch (Exception e) {
                LOG.warn("Could not store auction for clan: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public boolean checkClanJoinCondition(L2PcInstance activeChar, L2PcInstance target, int pledgeType) {
        if (activeChar == null) {
            return false;
        }
        if (!activeChar.hasClanPrivilege(ClanPrivilege.CL_JOIN_CLAN)) {
            activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            return false;
        }
        if (target == null) {
            activeChar.sendPacket(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET);
            return false;
        }
        if (activeChar.getObjectId() == target.getObjectId()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_INVITE_YOURSELF);
            return false;
        }
        if (this.getCharPenaltyExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessageId.YOU_MUST_WAIT_BEFORE_ACCEPTING_A_NEW_MEMBER);
            return false;
        }
        if (target.getClanId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_WORKING_WITH_ANOTHER_CLAN);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            return false;
        }
        if (target.getClanJoinExpiryTime() > System.currentTimeMillis()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            return false;
        }
        if ((target.getLevel() > 40 || target.getClassId().level() >= 2) && pledgeType == -1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DOESNOT_MEET_REQUIREMENTS_TO_JOIN_ACADEMY);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            activeChar.sendPacket(SystemMessageId.ACADEMY_REQUIREMENTS);
            return false;
        }
        if (this.getSubPledgeMembersCount(pledgeType) >= this.getMaxNrOfMembers(pledgeType)) {
            if (pledgeType == 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_IS_FULL);
                sm.addString(this.getName());
                activeChar.sendPacket(sm);
            } else {
                activeChar.sendPacket(SystemMessageId.SUBCLAN_IS_FULL);
            }
            return false;
        }
        return true;
    }

    public boolean checkAllyJoinCondition(L2PcInstance activeChar, L2PcInstance target) {
        if (activeChar == null) {
            return false;
        }
        if (activeChar.getAllyId() == 0 || !activeChar.isClanLeader() || activeChar.getClanId() != activeChar.getAllyId()) {
            activeChar.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return false;
        }
        L2Clan leaderClan = activeChar.getClan();
        if (leaderClan.getAllyPenaltyExpiryTime() > System.currentTimeMillis() && leaderClan.getAllyPenaltyType() == 3) {
            activeChar.sendPacket(SystemMessageId.CANT_INVITE_CLAN_WITHIN_1_DAY);
            return false;
        }
        if (target == null) {
            activeChar.sendPacket(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET);
            return false;
        }
        if (activeChar.getObjectId() == target.getObjectId()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_INVITE_YOURSELF);
            return false;
        }
        if (target.getClan() == null) {
            activeChar.sendPacket(SystemMessageId.TARGET_MUST_BE_IN_CLAN);
            return false;
        }
        if (!target.isClanLeader()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_IS_NOT_A_CLAN_LEADER);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            return false;
        }
        L2Clan targetClan = target.getClan();
        if (target.getAllyId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_ALREADY_MEMBER_OF_S2_ALLIANCE);
            sm.addString(targetClan.getName());
            sm.addString(targetClan.getAllyName());
            activeChar.sendPacket(sm);
            return false;
        }
        if (targetClan.getAllyPenaltyExpiryTime() > System.currentTimeMillis()) {
            if (targetClan.getAllyPenaltyType() == 1) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANT_ENTER_ALLIANCE_WITHIN_1_DAY);
                sm.addString(target.getClan().getName());
                sm.addString(target.getClan().getAllyName());
                activeChar.sendPacket(sm);
                return false;
            }
            if (targetClan.getAllyPenaltyType() == 2) {
                activeChar.sendPacket(SystemMessageId.CANT_ENTER_ALLIANCE_WITHIN_1_DAY);
                return false;
            }
        }
        if (activeChar.isInsideZone(ZoneId.SIEGE) && target.isInsideZone(ZoneId.SIEGE)) {
            activeChar.sendPacket(SystemMessageId.OPPOSING_CLAN_IS_PARTICIPATING_IN_SIEGE);
            return false;
        }
        if (leaderClan.isAtWarWith(targetClan.getId())) {
            activeChar.sendPacket(SystemMessageId.MAY_NOT_ALLY_CLAN_BATTLE);
            return false;
        }
        if (ClanTable.getInstance().getClanAllies(activeChar.getAllyId()).size() >= Configuration.character().getMaxNumOfClansInAlly()) {
            activeChar.sendPacket(SystemMessageId.YOU_HAVE_EXCEEDED_THE_LIMIT);
            return false;
        }
        return true;
    }

    public long getAllyPenaltyExpiryTime() {
        return this._allyPenaltyExpiryTime;
    }

    public int getAllyPenaltyType() {
        return this._allyPenaltyType;
    }

    public void setAllyPenaltyExpiryTime(long expiryTime, int penaltyType) {
        this._allyPenaltyExpiryTime = expiryTime;
        this._allyPenaltyType = penaltyType;
    }

    public long getCharPenaltyExpiryTime() {
        return this._charPenaltyExpiryTime;
    }

    public void setCharPenaltyExpiryTime(long time) {
        this._charPenaltyExpiryTime = time;
    }

    public long getDissolvingExpiryTime() {
        return this._dissolvingExpiryTime;
    }

    public void setDissolvingExpiryTime(long time) {
        this._dissolvingExpiryTime = time;
    }

    public void createAlly(L2PcInstance player, String allyName) {
        if (null == player) {
            return;
        }
        if (Configuration.general().debug()) {
            LOG.debug("{}({}) requested ally creation from ", (Object)player.getObjectId(), (Object)player.getName());
        }
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessageId.ONLY_CLAN_LEADER_CREATE_ALLIANCE);
            return;
        }
        if (this.getAllyId() != 0) {
            player.sendPacket(SystemMessageId.ALREADY_JOINED_ALLIANCE);
            return;
        }
        if (this.getLevel() < 5) {
            player.sendPacket(SystemMessageId.TO_CREATE_AN_ALLY_YOU_CLAN_MUST_BE_LEVEL_5_OR_HIGHER);
            return;
        }
        if (this.getAllyPenaltyExpiryTime() > System.currentTimeMillis() && this.getAllyPenaltyType() == 4) {
            player.sendPacket(SystemMessageId.CANT_CREATE_ALLIANCE_10_DAYS_DISOLUTION);
            return;
        }
        if (this.getDissolvingExpiryTime() > System.currentTimeMillis()) {
            player.sendPacket(SystemMessageId.YOU_MAY_NOT_CREATE_ALLY_WHILE_DISSOLVING);
            return;
        }
        if (!Util.isAlphaNumeric(allyName)) {
            player.sendPacket(SystemMessageId.INCORRECT_ALLIANCE_NAME);
            return;
        }
        if (allyName.length() > 16 || allyName.length() < 2) {
            player.sendPacket(SystemMessageId.INCORRECT_ALLIANCE_NAME_LENGTH);
            return;
        }
        if (ClanTable.getInstance().isAllyExists(allyName)) {
            player.sendPacket(SystemMessageId.ALLIANCE_ALREADY_EXISTS);
            return;
        }
        this.setAllyId(this.getId());
        this.setAllyName(allyName.trim());
        this.setAllyPenaltyExpiryTime(0L, 0);
        this.updateClanInDB();
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.sendMessage("Alliance " + allyName + " has been created.");
    }

    public void dissolveAlly(L2PcInstance player) {
        if (this.getAllyId() == 0) {
            player.sendPacket(SystemMessageId.NO_CURRENT_ALLIANCES);
            return;
        }
        if (!player.isClanLeader() || this.getId() != this.getAllyId()) {
            player.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return;
        }
        if (player.isInsideZone(ZoneId.SIEGE)) {
            player.sendPacket(SystemMessageId.CANNOT_DISSOLVE_ALLY_WHILE_IN_SIEGE);
            return;
        }
        this.broadcastToOnlineAllyMembers(SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_DISOLVED));
        long currentTime = System.currentTimeMillis();
        for (L2Clan clan : ClanTable.getInstance().getClanAllies(this.getAllyId())) {
            if (clan.getId() == this.getId()) continue;
            clan.setAllyId(0);
            clan.setAllyName(null);
            clan.setAllyPenaltyExpiryTime(0L, 0);
            clan.updateClanInDB();
        }
        this.setAllyId(0);
        this.setAllyName(null);
        this.changeAllyCrest(0, false);
        this.setAllyPenaltyExpiryTime(currentTime + Configuration.character().getDaysBeforeCreateNewAllyWhenDissolved(), 4);
        this.updateClanInDB();
    }

    public boolean levelUpClan(L2PcInstance player) {
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            return false;
        }
        if (System.currentTimeMillis() < this.getDissolvingExpiryTime()) {
            player.sendPacket(SystemMessageId.CANNOT_RISE_LEVEL_WHILE_DISSOLUTION_IN_PROGRESS);
            return false;
        }
        boolean increaseClanLevel = false;
        switch (this.getLevel()) {
            case 0: {
                if (player.getSp() < 20000 || player.getAdena() < 650000L || !player.reduceAdena("ClanLvl", 650000L, player.getTarget(), true)) break;
                player.setSp(player.getSp() - 20000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addInt(20000);
                player.sendPacket(sp);
                increaseClanLevel = true;
                break;
            }
            case 1: {
                if (player.getSp() < 100000 || player.getAdena() < 2500000L || !player.reduceAdena("ClanLvl", 2500000L, player.getTarget(), true)) break;
                player.setSp(player.getSp() - 100000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addInt(100000);
                player.sendPacket(sp);
                increaseClanLevel = true;
                break;
            }
            case 2: {
                if (player.getSp() < 350000 || player.getInventory().getItemByItemId(1419) == null || !player.destroyItemByItemId("ClanLvl", 1419, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 350000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addInt(350000);
                player.sendPacket(sp);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(1419);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 3: {
                if (player.getSp() < 1000000 || player.getInventory().getItemByItemId(3874) == null || !player.destroyItemByItemId("ClanLvl", 3874, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 1000000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addInt(1000000);
                player.sendPacket(sp);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(3874);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 4: {
                if (player.getSp() < 2500000 || player.getInventory().getItemByItemId(3870) == null || !player.destroyItemByItemId("ClanLvl", 3870, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 2500000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addInt(2500000);
                player.sendPacket(sp);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(3870);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 5: {
                if (this.getReputationScore() < Configuration.clan().getClanLevel6Cost() || this.getMembersCount() < Configuration.clan().getClanLevel6Requirement()) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel6Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel6Cost());
                player.sendPacket(cr);
                increaseClanLevel = true;
                break;
            }
            case 6: {
                if (this.getReputationScore() < Configuration.clan().getClanLevel7Cost() || this.getMembersCount() < Configuration.clan().getClanLevel7Requirement()) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel7Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel7Cost());
                player.sendPacket(cr);
                increaseClanLevel = true;
                break;
            }
            case 7: {
                if (this.getReputationScore() < Configuration.clan().getClanLevel8Cost() || this.getMembersCount() < Configuration.clan().getClanLevel8Requirement()) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel8Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel8Cost());
                player.sendPacket(cr);
                increaseClanLevel = true;
                break;
            }
            case 8: {
                if (this.getReputationScore() < Configuration.clan().getClanLevel9Cost() || player.getInventory().getItemByItemId(9910) == null || this.getMembersCount() < Configuration.clan().getClanLevel9Requirement() || !player.destroyItemByItemId("ClanLvl", 9910, 150L, player.getTarget(), false)) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel9Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel9Cost());
                player.sendPacket(cr);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(9910);
                sm.addLong(150L);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 9: {
                if (this.getReputationScore() < Configuration.clan().getClanLevel10Cost() || player.getInventory().getItemByItemId(9911) == null || this.getMembersCount() < Configuration.clan().getClanLevel10Requirement() || !player.destroyItemByItemId("ClanLvl", 9911, 5L, player.getTarget(), false)) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel10Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel10Cost());
                player.sendPacket(cr);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(9911);
                sm.addLong(5L);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 10: {
                boolean hasTerritory = false;
                for (TerritoryWarManager.Territory terr : TerritoryWarManager.getInstance().getAllTerritories()) {
                    if (terr.getOwnerClan().getId() != this.getId()) continue;
                    hasTerritory = true;
                    break;
                }
                if (!hasTerritory || this.getReputationScore() < Configuration.clan().getClanLevel11Cost() || this.getMembersCount() < Configuration.clan().getClanLevel11Requirement()) break;
                this.setReputationScore(this.getReputationScore() - Configuration.clan().getClanLevel11Cost(), true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addInt(Configuration.clan().getClanLevel11Cost());
                player.sendPacket(cr);
                increaseClanLevel = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (!increaseClanLevel) {
            player.sendPacket(SystemMessageId.FAILED_TO_INCREASE_CLAN_LEVEL);
            return false;
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(13, player.getSp());
        player.sendPacket(su);
        player.sendPacket(new ItemList(player, false));
        this.changeLevel(this.getLevel() + 1);
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanLevelUp(this), new ListenersContainer[0]);
        return true;
    }

    public void changeLevel(int level) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET clan_level = ? WHERE clan_id = ?");){
            ps.setInt(1, level);
            ps.setInt(2, this.getId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not increase clan level: {}", (Object)e.getMessage(), (Object)e);
        }
        this.setLevel(level);
        ForumsBBSManager.getInstance().onClanLevel(this);
        if (this.getLeader().isOnline()) {
            L2PcInstance leader = this.getLeader().getPlayerInstance();
            if (level > 4) {
                SiegeManager.getInstance().addSiegeSkills(leader);
                leader.sendPacket(SystemMessageId.CLAN_CAN_ACCUMULATE_CLAN_REPUTATION_POINTS);
            } else {
                SiegeManager.getInstance().removeSiegeSkills(leader);
            }
        }
        this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_LEVEL_INCREASED));
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this));
    }

    public void changeClanCrest(int crestId) {
        if (this.getCrestId() != 0) {
            CrestTable.getInstance().removeCrest(this.getCrestId());
        }
        this.setCrestId(crestId);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET crest_id = ? WHERE clan_id = ?");){
            ps.setInt(1, crestId);
            ps.setInt(2, this.getId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not update crest for clan {} [{}]: {}", this.getName(), this.getId(), e.getMessage(), e);
        }
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    public void changeAllyCrest(int crestId, boolean onlyThisClan) {
        String sqlStatement = "UPDATE clan_data SET ally_crest_id = ? WHERE clan_id = ?";
        int allyId = this.getId();
        if (!onlyThisClan) {
            if (this.getAllyCrestId() != 0) {
                CrestTable.getInstance().removeCrest(this.getAllyCrestId());
            }
            sqlStatement = "UPDATE clan_data SET ally_crest_id = ? WHERE ally_id = ?";
            allyId = this.getAllyId();
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(sqlStatement);){
            ps.setInt(1, crestId);
            ps.setInt(2, allyId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not update ally crest for ally/clan id {}: {}", allyId, e.getMessage(), e);
        }
        if (onlyThisClan) {
            this.setAllyCrestId(crestId);
            for (L2PcInstance member : this.getOnlineMembers(0)) {
                member.broadcastUserInfo();
            }
        } else {
            for (L2Clan clan : ClanTable.getInstance().getClanAllies(this.getAllyId())) {
                clan.setAllyCrestId(crestId);
                for (L2PcInstance member : clan.getOnlineMembers(0)) {
                    member.broadcastUserInfo();
                }
            }
        }
    }

    public void changeLargeCrest(int crestId) {
        if (this.getCrestLargeId() != 0) {
            CrestTable.getInstance().removeCrest(this.getCrestLargeId());
        }
        this.setCrestLargeId(crestId);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET crest_large_id = ? WHERE clan_id = ?");){
            ps.setInt(1, crestId);
            ps.setInt(2, this.getId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("Could not update large crest for clan {} [{}]: {}", this.getName(), this.getId(), e.getMessage(), e);
        }
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    public boolean isLearnableSubSkill(int skillId, int skillLevel) {
        Skill current = this._subPledgeSkills.get(skillId);
        if (current != null && current.getLevel() + 1 == skillLevel) {
            return true;
        }
        if (current == null && skillLevel == 1) {
            return true;
        }
        for (SubPledge subunit : this._subPledges.values()) {
            if (subunit.getId() == -1) continue;
            current = subunit.getSkill(skillId);
            if (current != null && current.getLevel() + 1 == skillLevel) {
                return true;
            }
            if (current != null || skillLevel != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isLearnableSubPledgeSkill(Skill skill, int subType) {
        if (subType == -1) {
            return false;
        }
        int id = skill.getId();
        Skill current = subType == 0 ? this._subPledgeSkills.get(id) : this._subPledges.get(subType).getSkill(id);
        if (current != null && current.getLevel() + 1 == skill.getLevel()) {
            return true;
        }
        return current == null && skill.getLevel() == 1;
    }

    public List<PledgeSkillList.SubPledgeSkill> getAllSubSkills() {
        LinkedList<PledgeSkillList.SubPledgeSkill> list = new LinkedList<PledgeSkillList.SubPledgeSkill>();
        for (Skill skill : this._subPledgeSkills.values()) {
            list.add(new PledgeSkillList.SubPledgeSkill(0, skill.getId(), skill.getLevel()));
        }
        for (SubPledge subunit : this._subPledges.values()) {
            for (Skill skill : subunit.getSkills()) {
                list.add(new PledgeSkillList.SubPledgeSkill(subunit.getId(), skill.getId(), skill.getLevel()));
            }
        }
        return list;
    }

    public void setNewLeaderId(int objectId, boolean storeInDb) {
        this._newLeaderId = objectId;
        if (storeInDb) {
            this.updateClanInDB();
        }
    }

    public int getNewLeaderId() {
        return this._newLeaderId;
    }

    public L2PcInstance getNewLeader() {
        return L2World.getInstance().getPlayer(this._newLeaderId);
    }

    public String getNewLeaderName() {
        return CharNameTable.getInstance().getNameById(this._newLeaderId);
    }

    public int getSiegeKills() {
        return this._siegeKills.get();
    }

    public int getSiegeDeaths() {
        return this._siegeDeaths.get();
    }

    public int addSiegeKill() {
        return this._siegeKills.incrementAndGet();
    }

    public int addSiegeDeath() {
        return this._siegeDeaths.incrementAndGet();
    }

    public void clearSiegeKills() {
        this._siegeKills.set(0);
    }

    public void clearSiegeDeaths() {
        this._siegeDeaths.set(0);
    }

    public static class SubPledge {
        private final int _id;
        private String _subPledgeName;
        private int _leaderId;
        private final Map<Integer, Skill> _subPledgeSkills = new HashMap<Integer, Skill>();

        public SubPledge(int id, String name, int leaderId) {
            this._id = id;
            this._subPledgeName = name;
            this._leaderId = leaderId;
        }

        public int getId() {
            return this._id;
        }

        public String getName() {
            return this._subPledgeName;
        }

        public void setName(String name) {
            this._subPledgeName = name;
        }

        public int getLeaderId() {
            return this._leaderId;
        }

        public void setLeaderId(int leaderId) {
            this._leaderId = leaderId;
        }

        public Skill addNewSkill(Skill skill) {
            return this._subPledgeSkills.put(skill.getId(), skill);
        }

        public Collection<Skill> getSkills() {
            return this._subPledgeSkills.values();
        }

        public Skill getSkill(int id) {
            return this._subPledgeSkills.get(id);
        }
    }

    public static class RankPrivs {
        private final int _rankId;
        private final int _party;
        private final EnumIntBitmask<ClanPrivilege> _rankPrivs;

        public RankPrivs(int rank, int party, int privs) {
            this._rankId = rank;
            this._party = party;
            this._rankPrivs = new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, privs);
        }

        public RankPrivs(int rank, int party, EnumIntBitmask<ClanPrivilege> rankPrivs) {
            this._rankId = rank;
            this._party = party;
            this._rankPrivs = rankPrivs;
        }

        public int getRank() {
            return this._rankId;
        }

        public int getParty() {
            return this._party;
        }

        public EnumIntBitmask<ClanPrivilege> getPrivs() {
            return this._rankPrivs;
        }

        public void setPrivs(int privs) {
            this._rankPrivs.setBitmask(privs);
        }
    }
}

