/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.AbstractPlayerGroup;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExCloseMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExMPCCPartyInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOpenMPCC;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class L2CommandChannel
extends AbstractPlayerGroup {
    private final List<L2Party> _parties = new CopyOnWriteArrayList<L2Party>();
    private L2PcInstance _commandLeader;
    private int _channelLvl;

    public L2CommandChannel(L2PcInstance leader) {
        this._commandLeader = leader;
        L2Party party = leader.getParty();
        this._parties.add(party);
        this._channelLvl = party.getLevel();
        party.setCommandChannel(this);
        party.broadcastMessage(SystemMessageId.COMMAND_CHANNEL_FORMED);
        party.broadcastPacket(ExOpenMPCC.STATIC_PACKET);
    }

    public void addParty(L2Party party) {
        if (party == null) {
            return;
        }
        this.broadcastPacket(new ExMPCCPartyInfoUpdate(party, 1));
        this._parties.add(party);
        if (party.getLevel() > this._channelLvl) {
            this._channelLvl = party.getLevel();
        }
        party.setCommandChannel(this);
        party.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.JOINED_COMMAND_CHANNEL));
        party.broadcastPacket(ExOpenMPCC.STATIC_PACKET);
    }

    public void removeParty(L2Party party) {
        if (party == null) {
            return;
        }
        this._parties.remove(party);
        this._channelLvl = 0;
        for (L2Party pty : this._parties) {
            if (pty.getLevel() <= this._channelLvl) continue;
            this._channelLvl = pty.getLevel();
        }
        party.setCommandChannel(null);
        party.broadcastPacket(new ExCloseMPCC());
        if (this._parties.size() < 2) {
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_DISBANDED));
            this.disbandChannel();
        } else {
            this.broadcastPacket(new ExMPCCPartyInfoUpdate(party, 0));
        }
    }

    public void disbandChannel() {
        for (L2Party party : this._parties) {
            if (party == null) continue;
            this.removeParty(party);
        }
        this._parties.clear();
    }

    @Override
    public int getMemberCount() {
        int count = 0;
        for (L2Party party : this._parties) {
            if (party == null) continue;
            count += party.getMemberCount();
        }
        return count;
    }

    public List<L2Party> getParties() {
        return this._parties;
    }

    @Override
    public List<L2PcInstance> getMembers() {
        LinkedList<L2PcInstance> members = new LinkedList<L2PcInstance>();
        for (L2Party party : this.getParties()) {
            members.addAll(party.getMembers());
        }
        return members;
    }

    @Override
    public int getLevel() {
        return this._channelLvl;
    }

    @Override
    public void setLeader(L2PcInstance leader) {
        this._commandLeader = leader;
        if (leader.getLevel() > this._channelLvl) {
            this._channelLvl = leader.getLevel();
        }
    }

    public boolean meetRaidWarCondition(L2Object obj) {
        if (!(obj instanceof L2Character) || !((L2Character)obj).isRaid()) {
            return false;
        }
        return this.getMemberCount() >= Configuration.character().getRaidLootRightsCCSize();
    }

    @Override
    public L2PcInstance getLeader() {
        return this._commandLeader;
    }

    @Override
    public boolean containsPlayer(L2PcInstance player) {
        for (L2Party party : this._parties) {
            if (!party.containsPlayer(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean forEachMember(Function<L2PcInstance, Boolean> function) {
        for (L2Party party : this._parties) {
            if (party.forEachMember(function)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(L2CommandChannel cc) {
        return cc != null && this.getLeaderObjectId() == cc.getLeaderObjectId();
    }
}

