/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import java.util.Set;
import java.util.TreeMap;

public final class L2EnchantSkillLearn {
    private final int _id;
    private final int _baseLvl;
    private final TreeMap<Integer, Integer> _enchantRoutes = new TreeMap();

    public L2EnchantSkillLearn(int id, int baseLvl) {
        this._id = id;
        this._baseLvl = baseLvl;
    }

    public void addNewEnchantRoute(int route, int group) {
        this._enchantRoutes.put(route, group);
    }

    public int getId() {
        return this._id;
    }

    public int getBaseLevel() {
        return this._baseLvl;
    }

    public static int getEnchantRoute(int level) {
        return (int)Math.floor((double)level / 100.0);
    }

    public static int getEnchantIndex(int level) {
        return level % 100 - 1;
    }

    public L2EnchantSkillGroup getFirstRouteGroup() {
        return EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.firstEntry().getValue());
    }

    public Set<Integer> getAllRoutes() {
        return this._enchantRoutes.keySet();
    }

    public int getMinSkillLevel(int level) {
        if (level % 100 == 1) {
            return this._baseLvl;
        }
        return level - 1;
    }

    public boolean isMaxEnchant(int level) {
        int route = L2EnchantSkillLearn.getEnchantRoute(level);
        if (route < 1 || !this._enchantRoutes.containsKey(route)) {
            return false;
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        return index + 1 >= EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(route)).getEnchantGroupDetails().size();
    }

    public L2EnchantSkillGroup.EnchantSkillHolder getEnchantSkillHolder(int level) {
        int route = L2EnchantSkillLearn.getEnchantRoute(level);
        if (route < 1 || !this._enchantRoutes.containsKey(route)) {
            return null;
        }
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        L2EnchantSkillGroup group = EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(route));
        if (index < 0) {
            return group.getEnchantGroupDetails().get(0);
        }
        if (index >= group.getEnchantGroupDetails().size()) {
            return group.getEnchantGroupDetails().get(EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.get(route)).getEnchantGroupDetails().size() - 1);
        }
        return group.getEnchantGroupDetails().get(index);
    }
}

