/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.TerritoryTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2GroupSpawn
extends L2Spawn {
    private static final Logger LOG = LoggerFactory.getLogger(L2GroupSpawn.class);
    private final L2NpcTemplate _template;

    public L2GroupSpawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        super(mobTemplate);
        this._template = mobTemplate;
        this.setAmount(1);
    }

    public L2Npc doGroupSpawn() {
        try {
            if (this._template.isType("L2Pet") || this._template.isType("L2Minion")) {
                return null;
            }
            int newLocX = 0;
            int newLocY = 0;
            int newLocZ = 0;
            if (this.getX() == 0 && this.getY() == 0) {
                if (this.getLocationId() == 0) {
                    return null;
                }
                Location location = TerritoryTable.getInstance().getRandomPoint(this.getLocationId());
                if (location != null) {
                    newLocX = location.getX();
                    newLocY = location.getY();
                    newLocZ = location.getZ();
                }
            } else {
                newLocX = this.getX();
                newLocY = this.getY();
                newLocZ = this.getZ();
            }
            int objectId = IdFactory.getInstance().getNextId();
            L2ControllableMobInstance mob = new L2ControllableMobInstance(objectId, this._template);
            mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
            if (this.getHeading() == -1) {
                mob.setHeading(Rnd.nextInt((int)61794));
            } else {
                mob.setHeading(this.getHeading());
            }
            mob.setSpawn(this);
            mob.spawnMe(newLocX, newLocY, newLocZ);
            mob.onSpawn();
            if (Configuration.general().debug()) {
                LOG.trace("Spawned Mob Id: {} ,at: X: {} Y: {} Z: {}", this._template.getId(), mob.getX(), mob.getY(), mob.getZ());
            }
            return mob;
        }
        catch (Exception e) {
            LOG.warn("NPC class not found: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

