/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.PartyDistributionType;
import com.l2jserver.gameserver.model.AbstractPlayerGroup;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.entity.DimensionalRift;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExAskModifyPartyLooting;
import com.l2jserver.gameserver.network.serverpackets.ExCloseMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExOpenMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.ExSetPartyLooting;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PartyMemberPosition;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAll;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDeleteAll;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Party
extends AbstractPlayerGroup {
    private static final Logger LOG = LoggerFactory.getLogger(L2Party.class);
    private static final int MAXIMUM_LEVEL_DIFFERENCE = 9;
    private static final double[] BONUS_EXP_SP = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 2.0, 2.1, 2.2};
    private static final Duration PARTY_POSITION_BROADCAST_INTERVAL = Duration.ofSeconds(12L);
    private static final Duration PARTY_DISTRIBUTION_TYPE_REQUEST_TIMEOUT = Duration.ofSeconds(15L);
    private final List<L2PcInstance> _members = new CopyOnWriteArrayList<L2PcInstance>();
    private boolean _pendingInvitation = false;
    private long _pendingInviteTimeout;
    private int _partyLvl;
    private volatile PartyDistributionType _distributionType;
    private volatile PartyDistributionType _changeRequestDistributionType;
    private volatile Future<?> _changeDistributionTypeRequestTask = null;
    private volatile Set<Integer> _changeDistributionTypeAnswers = null;
    private int _itemLastLoot = 0;
    private L2CommandChannel _commandChannel = null;
    private DimensionalRift _dr;
    private Future<?> _positionBroadcastTask = null;
    private PartyMemberPosition _positionPacket;
    private boolean _disbanding = false;

    public L2Party(L2PcInstance leader, PartyDistributionType partyDistributionType) {
        this._members.add(leader);
        this._partyLvl = leader.getLevel();
        this._distributionType = partyDistributionType;
    }

    public boolean getPendingInvitation() {
        return this._pendingInvitation;
    }

    public void setPendingInvitation(boolean val) {
        this._pendingInvitation = val;
        this._pendingInviteTimeout = GameTimeController.getInstance().getGameTicks() + 150;
    }

    public boolean isInvitationRequestExpired() {
        return this._pendingInviteTimeout <= (long)GameTimeController.getInstance().getGameTicks();
    }

    private L2PcInstance getCheckedRandomMember(int itemId, L2Character target) {
        ArrayList<L2PcInstance> availableMembers = new ArrayList<L2PcInstance>();
        for (L2PcInstance member : this.getMembers()) {
            if (!member.getInventory().validateCapacityByItemId(itemId) || !Util.checkIfInRange(Configuration.character().getPartyRange2(), target, member, true)) continue;
            availableMembers.add(member);
        }
        if (!availableMembers.isEmpty()) {
            return (L2PcInstance)availableMembers.get(Rnd.get((int)availableMembers.size()));
        }
        return null;
    }

    private L2PcInstance getCheckedNextLooter(int ItemId, L2Character target) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            if (++this._itemLastLoot >= this.getMemberCount()) {
                this._itemLastLoot = 0;
            }
            try {
                L2PcInstance member = this.getMembers().get(this._itemLastLoot);
                if (!member.getInventory().validateCapacityByItemId(ItemId) || !Util.checkIfInRange(Configuration.character().getPartyRange2(), target, member, true)) continue;
                return member;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private L2PcInstance getActualLooter(L2PcInstance player, int ItemId, boolean spoil, L2Character target) {
        L2PcInstance looter = null;
        switch (this._distributionType) {
            case RANDOM: {
                if (spoil) break;
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case RANDOM_INCLUDING_SPOIL: {
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case BY_TURN: {
                if (spoil) break;
                looter = this.getCheckedNextLooter(ItemId, target);
                break;
            }
            case BY_TURN_INCLUDING_SPOIL: {
                looter = this.getCheckedNextLooter(ItemId, target);
            }
        }
        return looter != null ? looter : player;
    }

    public void broadcastToPartyMembersNewLeader() {
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) continue;
            member.sendPacket(PartySmallWindowDeleteAll.STATIC_PACKET);
            member.sendPacket(new PartySmallWindowAll(member, this));
            member.broadcastUserInfo();
        }
    }

    public void broadcastToPartyMembers(L2PcInstance player, L2GameServerPacket msg) {
        for (L2PcInstance member : this.getMembers()) {
            if (member == null || member.getObjectId() == player.getObjectId()) continue;
            member.sendPacket(msg);
        }
    }

    public void addPartyMember(L2PcInstance player) {
        if (this.getMembers().contains(player)) {
            return;
        }
        if (this._changeRequestDistributionType != null) {
            this.finishLootRequest(false);
        }
        player.sendPacket(new PartySmallWindowAll(player, this));
        for (L2PcInstance pMember : this.getMembers()) {
            if (pMember == null || !pMember.hasSummon()) continue;
            player.sendPacket(new ExPartyPetWindowAdd(pMember.getSummon()));
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_JOINED_S1_PARTY);
        msg.addString(this.getLeader().getName());
        player.sendPacket(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.C1_JOINED_PARTY);
        msg.addString(player.getName());
        this.broadcastPacket(msg);
        this.broadcastPacket(new PartySmallWindowAdd(player, this));
        if (player.hasSummon()) {
            this.broadcastPacket(new ExPartyPetWindowAdd(player.getSummon()));
        }
        this.getMembers().add(player);
        if (player.getLevel() > this._partyLvl) {
            this._partyLvl = player.getLevel();
        }
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) continue;
            member.updateEffectIcons(true);
            L2Summon summon = member.getSummon();
            member.broadcastUserInfo();
            if (summon == null) continue;
            summon.updateEffectIcons();
        }
        if (this.isInDimensionalRift()) {
            this._dr.partyMemberInvited();
        }
        if (this.isInCommandChannel()) {
            player.sendPacket(ExOpenMPCC.STATIC_PACKET);
        }
        if (this._positionBroadcastTask == null) {
            this._positionBroadcastTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(() -> {
                if (this._positionPacket == null) {
                    this._positionPacket = new PartyMemberPosition(this);
                } else {
                    this._positionPacket.reuse(this);
                }
                this.broadcastPacket(this._positionPacket);
            }, PARTY_POSITION_BROADCAST_INTERVAL.toMillis() / 2L, PARTY_POSITION_BROADCAST_INTERVAL.toMillis());
        }
    }

    public void removePartyMember(String name, messageType type) {
        this.removePartyMember(this.getPlayerByName(name), type);
    }

    public void removePartyMember(L2PcInstance player, messageType type) {
        if (this.getMembers().contains(player)) {
            SystemMessage msg;
            boolean isLeader = this.isLeader(player);
            if (!this._disbanding && (this.getMembers().size() == 2 || isLeader && !Configuration.character().leavePartyLeader() && type != messageType.Disconnected)) {
                this.disbandParty();
                return;
            }
            this.getMembers().remove(player);
            this.recalculatePartyLevel();
            if (player.isFestivalParticipant()) {
                SevenSignsFestival.getInstance().updateParticipants(player, this);
            }
            try {
                if (player.isChanneling() && player.getSkillChannelizer().hasChannelized()) {
                    player.abortCast();
                } else if (player.isChannelized()) {
                    player.getSkillChannelized().abortChannelization();
                }
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            if (type == messageType.Expelled) {
                player.sendPacket(SystemMessageId.HAVE_BEEN_EXPELLED_FROM_PARTY);
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_WAS_EXPELLED_FROM_PARTY);
                msg.addString(player.getName());
                this.broadcastPacket(msg);
            } else if (type == messageType.Left || type == messageType.Disconnected) {
                player.sendPacket(SystemMessageId.YOU_LEFT_PARTY);
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_LEFT_PARTY);
                msg.addString(player.getName());
                this.broadcastPacket(msg);
            }
            player.sendPacket(PartySmallWindowDeleteAll.STATIC_PACKET);
            player.setParty(null);
            this.broadcastPacket(new PartySmallWindowDelete(player));
            if (player.hasSummon()) {
                this.broadcastPacket(new ExPartyPetWindowDelete(player.getSummon()));
            }
            if (this.isInDimensionalRift()) {
                this._dr.partyMemberExited(player);
            }
            if (this.isInCommandChannel()) {
                player.sendPacket(new ExCloseMPCC());
            }
            if (isLeader && this.getMembers().size() > 1 && (Configuration.character().leavePartyLeader() || type == messageType.Disconnected)) {
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                msg.addString(this.getLeader().getName());
                this.broadcastPacket(msg);
                this.broadcastToPartyMembersNewLeader();
            } else if (this.getMembers().size() == 1) {
                if (this.isInCommandChannel()) {
                    if (this.getCommandChannel().getLeader().getObjectId() == this.getLeader().getObjectId()) {
                        this.getCommandChannel().disbandChannel();
                    } else {
                        this.getCommandChannel().removeParty(this);
                    }
                }
                if (this.getLeader() != null) {
                    this.getLeader().setParty(null);
                }
                if (this._changeDistributionTypeRequestTask != null) {
                    this._changeDistributionTypeRequestTask.cancel(true);
                    this._changeDistributionTypeRequestTask = null;
                }
                if (this._positionBroadcastTask != null) {
                    this._positionBroadcastTask.cancel(false);
                    this._positionBroadcastTask = null;
                }
                this._members.clear();
            }
        }
    }

    public void disbandParty() {
        this._disbanding = true;
        this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_DISPERSED));
        for (L2PcInstance member : this._members) {
            if (member == null) continue;
            this.removePartyMember(member, messageType.None);
        }
    }

    public void changePartyLeader(String name) {
        this.setLeader(this.getPlayerByName(name));
    }

    @Override
    public void setLeader(L2PcInstance player) {
        if (player != null && !player.isInDuel()) {
            if (this.getMembers().contains(player)) {
                if (this.isLeader(player)) {
                    player.sendPacket(SystemMessageId.YOU_CANNOT_TRANSFER_RIGHTS_TO_YOURSELF);
                } else {
                    L2PcInstance temp = this.getLeader();
                    int p1 = this.getMembers().indexOf(player);
                    this.getMembers().set(0, player);
                    this.getMembers().set(p1, temp);
                    SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                    msg.addString(this.getLeader().getName());
                    this.broadcastPacket(msg);
                    this.broadcastToPartyMembersNewLeader();
                    if (this.isInCommandChannel() && this._commandChannel.isLeader(temp)) {
                        this._commandChannel.setLeader(this.getLeader());
                        msg = SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_LEADER_NOW_C1);
                        msg.addString(this._commandChannel.getLeader().getName());
                        this._commandChannel.broadcastPacket(msg);
                    }
                    if (player.isInPartyMatchRoom()) {
                        PartyMatchRoom room = PartyMatchRoomList.getInstance().getPlayerRoom(player);
                        room.changeLeader(player);
                    }
                }
            } else {
                player.sendPacket(SystemMessageId.YOU_CAN_TRANSFER_RIGHTS_ONLY_TO_ANOTHER_PARTY_MEMBER);
            }
        }
    }

    private L2PcInstance getPlayerByName(String name) {
        for (L2PcInstance member : this.getMembers()) {
            if (!member.getName().equalsIgnoreCase(name)) continue;
            return member;
        }
        return null;
    }

    private boolean isItemToEvenlyDistribute(int itemId) {
        L2Item item = ItemTable.getInstance().getTemplate(itemId);
        if (item != null && (Configuration.character().getPartyEvenlyDistributeAllStackableItems() && item.isStackable() || Configuration.character().getPartyEvenlyDistributeAllOtherItems() && !item.isStackable())) {
            return true;
        }
        return Configuration.character().getPartyEvenlyDistributeItems().contains(itemId);
    }

    public void distributeItem(L2PcInstance player, L2ItemInstance item) {
        if (this.isItemToEvenlyDistribute(item.getId())) {
            this.distributeItemEvenly(player, item.getId(), item.getCount(), player);
            ItemTable.getInstance().destroyItem("Party", item, player, null);
            return;
        }
        L2PcInstance target = this.getActualLooter(player, item.getId(), false, player);
        target.addItem("Party", item, (L2Object)player, true);
        if (item.getCount() > 0L) {
            if (item.getCount() > 1L) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
                msg.addString(target.getName());
                msg.addItemName(item);
                msg.addLong(item.getCount());
                this.broadcastToPartyMembers(target, msg);
            } else {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S2);
                msg.addString(target.getName());
                msg.addItemName(item);
                this.broadcastToPartyMembers(target, msg);
            }
        }
    }

    public void distributeItem(L2PcInstance player, int itemId, long itemCount, boolean spoil, L2Attackable target) {
        if (this.isItemToEvenlyDistribute(itemId)) {
            this.distributeItemEvenly(player, itemId, itemCount, target);
            return;
        }
        L2PcInstance looter = this.getActualLooter(player, itemId, spoil, target);
        looter.addItem(spoil ? "Sweeper Party" : "Party", itemId, itemCount, target, true);
        if (itemCount > 0L) {
            if (itemCount > 1L) {
                SystemMessage msg = spoil ? SystemMessage.getSystemMessage(SystemMessageId.C1_SWEEPED_UP_S3_S2) : SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
                msg.addString(looter.getName());
                msg.addItemName(itemId);
                msg.addLong(itemCount);
                this.broadcastToPartyMembers(looter, msg);
            } else {
                SystemMessage msg = spoil ? SystemMessage.getSystemMessage(SystemMessageId.C1_SWEEPED_UP_S2) : SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S2);
                msg.addString(looter.getName());
                msg.addItemName(itemId);
                this.broadcastToPartyMembers(looter, msg);
            }
        }
    }

    public void distributeItem(L2PcInstance player, ItemHolder item, boolean spoil, L2Attackable target) {
        this.distributeItem(player, item.getId(), item.getCount(), spoil, target);
    }

    public void distributeItemEvenly(L2PcInstance player, int itemId, long itemAmount, L2Character target) {
        HashMap<L2PcInstance, Long> toReward = new HashMap<L2PcInstance, Long>(9);
        for (L2PcInstance member : this.getMembers()) {
            if (!Util.checkIfInRange(Configuration.character().getPartyRange2(), target, member, true)) continue;
            toReward.put(member, 0L);
        }
        if (!toReward.isEmpty()) {
            long leftOver = itemAmount % (long)toReward.size();
            long count = itemAmount / (long)toReward.size();
            if (count > 0L) {
                for (L2PcInstance l2PcInstance : toReward.keySet()) {
                    toReward.put(l2PcInstance, count);
                }
            }
            if (leftOver > 0L) {
                ArrayList keys = new ArrayList(toReward.keySet());
                while (leftOver-- > 0L) {
                    int n2 = Rnd.get((int)0, (int)(toReward.size() - 1));
                    L2PcInstance rndMember = (L2PcInstance)keys.get(n2);
                    toReward.compute(rndMember, (m, n) -> n + 1L);
                }
            }
            for (Map.Entry entry : toReward.entrySet()) {
                if ((Long)entry.getValue() <= 0L) continue;
                if (itemId == 57) {
                    ((L2PcInstance)entry.getKey()).addAdena("Party", (Long)entry.getValue(), player, true);
                    continue;
                }
                ((L2PcInstance)entry.getKey()).addItem("Party", itemId, (Long)entry.getValue(), target, true);
            }
        }
    }

    public void distributeXpAndSp(long xpReward, int spReward, List<L2PcInstance> rewardedMembers, int topLvl, int partyDmg, L2Attackable target) {
        List<L2PcInstance> validMembers = this.getValidMembers(rewardedMembers, topLvl);
        xpReward = (long)((double)xpReward * this.getExpBonus(validMembers.size()));
        spReward = (int)((double)spReward * this.getSpBonus(validMembers.size()));
        int sqLevelSum = 0;
        for (L2PcInstance member : validMembers) {
            sqLevelSum += member.getLevel() * member.getLevel();
        }
        float vitalityPoints = target.getVitalityPoints(partyDmg) * Configuration.rates().getRatePartyXp() / (float)validMembers.size();
        boolean useVitalityRate = target.useVitalityRate();
        for (L2PcInstance member : rewardedMembers) {
            if (member.isDead()) continue;
            if (validMembers.contains(member)) {
                float penalty = member.hasServitor() ? ((L2ServitorInstance)member.getSummon()).getExpMultiplier() : 1.0f;
                double sqLevel = member.getLevel() * member.getLevel();
                double preCalculation = sqLevel / (double)sqLevelSum * (double)penalty;
                long addexp = Math.round((double)xpReward * preCalculation);
                int addsp = (int)((double)spReward * preCalculation);
                addexp = this.calculateExpSpPartyCutoff(member.getActingPlayer(), topLvl, addexp, addsp, useVitalityRate);
                if (addexp <= 0L) continue;
                member.updateVitalityPoints(vitalityPoints, true, false);
                if (member.isInsideZone(ZoneId.PEACE) || member.getLevel() - target.getLevel() > 9) continue;
                if (Configuration.hunting().getNevitEnable()) {
                    member.getHuntingSystem().startHuntingSystemTask();
                    if (member.getHuntingSystem().getHuntingBonusTime() < Configuration.hunting().getHuntingBonusMaxTime() || !Configuration.hunting().getHuntingBonusLimit()) {
                        member.getHuntingSystem().addPoints(Configuration.hunting().getNevitNormalPoints());
                    }
                }
                member.getRecSystem().startBonusTask(true);
                continue;
            }
            member.addExpAndSp(0L, 0);
        }
    }

    private long calculateExpSpPartyCutoff(L2PcInstance player, int topLvl, long addExp, int addSp, boolean vit) {
        long xp = addExp;
        if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("highfive")) {
            int i = 0;
            int lvlDiff = topLvl - player.getLevel();
            for (Map.Entry<Integer, Integer> gap : Configuration.character().getPartyXpCutoffGaps().entrySet()) {
                if (lvlDiff >= gap.getKey() && lvlDiff <= gap.getValue()) {
                    xp = addExp * (long)Configuration.character().getPartyXpCutoffGapPercent().get(i).intValue() / 100L;
                    int sp = addSp * Configuration.character().getPartyXpCutoffGapPercent().get(i) / 100;
                    player.addExpAndSp(xp, sp, vit);
                    break;
                }
                ++i;
            }
        } else {
            player.addExpAndSp(addExp, addSp, vit);
        }
        return xp;
    }

    public void recalculatePartyLevel() {
        int newLevel = 0;
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) {
                this.getMembers().remove(member);
                continue;
            }
            if (member.getLevel() <= newLevel) continue;
            newLevel = member.getLevel();
        }
        this._partyLvl = newLevel;
    }

    private List<L2PcInstance> getValidMembers(List<L2PcInstance> members, int topLvl) {
        ArrayList<L2PcInstance> validMembers = new ArrayList<L2PcInstance>();
        if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("level")) {
            for (L2PcInstance member : members) {
                if (topLvl - member.getLevel() > Configuration.character().getPartyXpCutoffLevel()) continue;
                validMembers.add(member);
            }
        } else if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("percentage")) {
            int sqLevelSum = 0;
            for (L2PcInstance member : members) {
                sqLevelSum += member.getLevel() * member.getLevel();
            }
            for (L2PcInstance member : members) {
                int sqLevel = member.getLevel() * member.getLevel();
                if (!((double)(sqLevel * 100) >= (double)sqLevelSum * Configuration.character().getPartyXpCutoffPercent())) continue;
                validMembers.add(member);
            }
        } else if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("auto")) {
            int sqLevelSum = 0;
            for (L2PcInstance member : members) {
                sqLevelSum += member.getLevel() * member.getLevel();
            }
            int i = members.size() - 1;
            if (i < 1) {
                return members;
            }
            if (i >= BONUS_EXP_SP.length) {
                i = BONUS_EXP_SP.length - 1;
            }
            for (L2PcInstance member : members) {
                int sqLevel = member.getLevel() * member.getLevel();
                if (sqLevel < sqLevelSum / (members.size() * members.size())) continue;
                validMembers.add(member);
            }
        } else if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("highfive")) {
            validMembers.addAll(members);
        } else if (Configuration.character().getPartyXpCutoffMethod().equalsIgnoreCase("none")) {
            validMembers.addAll(members);
        }
        return validMembers;
    }

    private double getBaseExpSpBonus(int membersCount) {
        int i = membersCount - 1;
        if (i < 1) {
            return 1.0;
        }
        if (i >= BONUS_EXP_SP.length) {
            i = BONUS_EXP_SP.length - 1;
        }
        return BONUS_EXP_SP[i];
    }

    private double getExpBonus(int membersCount) {
        return membersCount < 2 ? this.getBaseExpSpBonus(membersCount) : this.getBaseExpSpBonus(membersCount) * (double)Configuration.rates().getRatePartyXp();
    }

    private double getSpBonus(int membersCount) {
        return membersCount < 2 ? this.getBaseExpSpBonus(membersCount) : this.getBaseExpSpBonus(membersCount) * (double)Configuration.rates().getRatePartySp();
    }

    @Override
    public int getLevel() {
        return this._partyLvl;
    }

    public PartyDistributionType getDistributionType() {
        return this._distributionType;
    }

    public boolean isInCommandChannel() {
        return this._commandChannel != null;
    }

    public L2CommandChannel getCommandChannel() {
        return this._commandChannel;
    }

    public void setCommandChannel(L2CommandChannel channel) {
        this._commandChannel = channel;
    }

    public boolean isInDimensionalRift() {
        return this._dr != null;
    }

    public void setDimensionalRift(DimensionalRift dr) {
        this._dr = dr;
    }

    public DimensionalRift getDimensionalRift() {
        return this._dr;
    }

    @Override
    public L2PcInstance getLeader() {
        return this._members.getFirst();
    }

    public synchronized void requestLootChange(PartyDistributionType partyDistributionType) {
        if (this._changeRequestDistributionType != null) {
            return;
        }
        this._changeRequestDistributionType = partyDistributionType;
        this._changeDistributionTypeAnswers = new HashSet<Integer>();
        this._changeDistributionTypeRequestTask = ThreadPoolManager.getInstance().scheduleGeneral(() -> this.finishLootRequest(false), PARTY_DISTRIBUTION_TYPE_REQUEST_TIMEOUT.toMillis());
        this.broadcastToPartyMembers(this.getLeader(), new ExAskModifyPartyLooting(this.getLeader().getName(), partyDistributionType));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REQUESTING_APPROVAL_CHANGE_PARTY_LOOT_S1);
        sm.addSystemString(partyDistributionType.getSysStringId());
        this.getLeader().sendPacket(sm);
    }

    public synchronized void answerLootChangeRequest(L2PcInstance member, boolean answer) {
        if (this._changeRequestDistributionType == null) {
            return;
        }
        if (this._changeDistributionTypeAnswers.contains(member.getObjectId())) {
            return;
        }
        if (!answer) {
            this.finishLootRequest(false);
            return;
        }
        this._changeDistributionTypeAnswers.add(member.getObjectId());
        if (this._changeDistributionTypeAnswers.size() >= this.getMemberCount() - 1) {
            this.finishLootRequest(true);
        }
    }

    private synchronized void finishLootRequest(boolean success) {
        if (this._changeRequestDistributionType == null) {
            return;
        }
        if (this._changeDistributionTypeRequestTask != null) {
            this._changeDistributionTypeRequestTask.cancel(false);
            this._changeDistributionTypeRequestTask = null;
        }
        if (success) {
            this.broadcastPacket(new ExSetPartyLooting(1, this._changeRequestDistributionType));
            this._distributionType = this._changeRequestDistributionType;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PARTY_LOOT_CHANGED_S1);
            sm.addSystemString(this._changeRequestDistributionType.getSysStringId());
            this.broadcastPacket(sm);
        } else {
            this.broadcastPacket(new ExSetPartyLooting(0, this._distributionType));
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_LOOT_CHANGE_CANCELLED));
        }
        this._changeRequestDistributionType = null;
        this._changeDistributionTypeAnswers = null;
    }

    @Override
    public List<L2PcInstance> getMembers() {
        return this._members;
    }

    public boolean equals(L2Party party) {
        return party != null && this.getLeaderObjectId() == party.getLeaderObjectId();
    }

    public static enum messageType {
        Expelled,
        Left,
        None,
        Disconnected;

    }
}

