/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.TerritoryTable;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.SpawnListener;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.model.zone.type.NpcSpawnTerritory;
import java.lang.reflect.Constructor;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2Spawn
implements IPositionable,
IIdentifiable,
INamable {
    private static final Logger LOG = LoggerFactory.getLogger(L2Spawn.class);
    private String _name;
    private final L2NpcTemplate _template;
    private int _maximumCount;
    private int _currentCount;
    private int _scheduledCount;
    private int _locationId;
    private Location _location = new Location(0, 0, 0, 0, 0);
    private NpcSpawnTerritory _spawnTerritory = null;
    private int _respawnMinDelay;
    private int _respawnMaxDelay;
    private Constructor<? extends L2Npc> _constructor;
    private boolean _doRespawn;
    private boolean _customSpawn;
    private static final List<SpawnListener> _spawnListeners = new CopyOnWriteArrayList<SpawnListener>();
    private final Deque<L2Npc> _spawnedNpcs = new ConcurrentLinkedDeque<L2Npc>();
    private Map<Integer, Location> _lastSpawnPoints;
    private boolean _isNoRndWalk = false;
    private String _areaName;
    private int _globalMapId;

    public L2Spawn(L2NpcTemplate template) throws SecurityException, ClassNotFoundException, NoSuchMethodException, ClassCastException {
        this._template = template;
        if (this._template == null) {
            return;
        }
        String className = "com.l2jserver.gameserver.model.actor.instance." + this._template.getType() + "Instance";
        this._constructor = Class.forName(className).asSubclass(L2Npc.class).getConstructor(Integer.TYPE, L2NpcTemplate.class);
    }

    public L2Spawn(int npcId) throws SecurityException, ClassNotFoundException, NoSuchMethodException, ClassCastException {
        this(NpcData.getInstance().getTemplate(npcId));
    }

    public int getAmount() {
        return this._maximumCount;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getLocationId() {
        return this._locationId;
    }

    @Override
    public Location getLocation() {
        return this._location;
    }

    public Location getLocation(L2Object obj) {
        return this._lastSpawnPoints == null || obj == null || !this._lastSpawnPoints.containsKey(obj.getObjectId()) ? this._location : this._lastSpawnPoints.get(obj.getObjectId());
    }

    @Override
    public int getX() {
        return this._location.getX();
    }

    public int getX(L2Object obj) {
        return this.getLocation(obj).getX();
    }

    @Override
    public void setX(int x) {
        this._location.setX(x);
    }

    @Override
    public int getY() {
        return this._location.getY();
    }

    public int getY(L2Object obj) {
        return this.getLocation(obj).getY();
    }

    @Override
    public void setY(int y) {
        this._location.setY(y);
    }

    @Override
    public int getZ() {
        return this._location.getZ();
    }

    public int getZ(L2Object obj) {
        return this.getLocation(obj).getZ();
    }

    @Override
    public void setZ(int z) {
        this._location.setZ(z);
    }

    @Override
    public void setXYZ(int x, int y, int z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    @Override
    public void setXYZ(ILocational loc) {
        this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public int getHeading() {
        return this._location.getHeading();
    }

    @Override
    public void setHeading(int heading) {
        this._location.setHeading(heading);
    }

    @Override
    public void setLocation(Location loc) {
        this._location = loc;
    }

    @Override
    public int getId() {
        return this._template.getId();
    }

    public int getRespawnMinDelay() {
        return this._respawnMinDelay;
    }

    public int getRespawnMaxDelay() {
        return this._respawnMaxDelay;
    }

    public void setAmount(int amount) {
        this._maximumCount = amount;
    }

    public void setLocationId(int id) {
        this._locationId = id;
    }

    public void setRespawnMinDelay(int date) {
        this._respawnMinDelay = date;
    }

    public void setRespawnMaxDelay(int date) {
        this._respawnMaxDelay = date;
    }

    public void setCustom(boolean custom) {
        this._customSpawn = custom;
    }

    public boolean isCustom() {
        return this._customSpawn;
    }

    public void decreaseCount(L2Npc oldNpc) {
        if (this._currentCount <= 0) {
            return;
        }
        --this._currentCount;
        this._spawnedNpcs.remove(oldNpc);
        if (this._lastSpawnPoints != null) {
            this._lastSpawnPoints.remove(oldNpc.getObjectId());
        }
        if (this._doRespawn && this._scheduledCount + this._currentCount < this._maximumCount) {
            ++this._scheduledCount;
            ThreadPoolManager.getInstance().scheduleGeneral(new SpawnTask(oldNpc), this.hasRespawnRandom() ? (long)Rnd.get((int)this._respawnMinDelay, (int)this._respawnMaxDelay) : (long)this._respawnMinDelay);
        }
    }

    public int init() {
        while (this._currentCount < this._maximumCount) {
            this.doSpawn();
        }
        this._doRespawn = this._respawnMinDelay != 0;
        return this._currentCount;
    }

    public L2Npc spawnOne(boolean val) {
        return this.doSpawn(val);
    }

    public boolean isRespawnEnabled() {
        return this._doRespawn;
    }

    public void stopRespawn() {
        this._doRespawn = false;
    }

    public void startRespawn() {
        this._doRespawn = true;
    }

    public L2Npc doSpawn() {
        return this.doSpawn(false);
    }

    public L2Npc doSpawn(boolean isSummonSpawn) {
        try {
            if (this._template.isType("L2Pet") || this._template.isType("L2Decoy") || this._template.isType("L2Trap")) {
                ++this._currentCount;
                return null;
            }
            int objectId = IdFactory.getInstance().getNextId();
            L2Npc npc = this._constructor.newInstance(objectId, this._template);
            npc.setInstanceId(this.getInstanceId());
            if (isSummonSpawn) {
                npc.setShowSummonAnimation(isSummonSpawn);
            }
            if (this._name != null) {
                NpcPersonalAIData.getInstance().initializeNpcParameters(npc, this, this._name);
            }
            return this.initializeNpcInstance(npc);
        }
        catch (Exception e) {
            LOG.warn("NPC {} class not found", (Object)this._template.getId(), (Object)e);
            return null;
        }
    }

    private L2Npc initializeNpcInstance(L2Npc mob) {
        int newlocx = 0;
        int newlocy = 0;
        int newlocz = 0;
        if (this.isTerritoryBased()) {
            int[] p = this._spawnTerritory.getRandomPoint();
            newlocx = p[0];
            newlocy = p[1];
            newlocz = p[2];
        } else if (this.getX() == 0 && this.getY() == 0) {
            if (this.getLocationId() == 0) {
                return mob;
            }
            Location location = TerritoryTable.getInstance().getRandomPoint(this.getLocationId());
            if (location != null) {
                newlocx = location.getX();
                newlocy = location.getY();
                newlocz = location.getZ();
            }
        } else {
            newlocx = this.getX();
            newlocy = this.getY();
            newlocz = this.getZ();
        }
        if (!mob.isFlying()) {
            newlocz = GeoData.getInstance().getSpawnHeight(newlocx, newlocy, newlocz);
        }
        mob.stopAllEffects();
        mob.setIsDead(false);
        mob.setDecayed(false);
        if (mob.hasVariables()) {
            mob.getVariables().getSet().clear();
        }
        mob.setIsNoRndWalk(this.isNoRndWalk());
        if (this.getHeading() == -1) {
            mob.setHeading(Rnd.nextInt((int)61794));
        } else {
            mob.setHeading(this.getHeading());
        }
        if (mob instanceof L2Attackable) {
            ((L2Attackable)mob).setChampion(false);
        }
        if (Configuration.customs().championEnable() && mob.isMonster() && !this.getTemplate().isUndying() && !mob.isRaid() && !mob.isRaidMinion() && Configuration.customs().getChampionFrequency() > 0 && mob.getLevel() >= Configuration.customs().getChampionMinLevel() && mob.getLevel() <= Configuration.customs().getChampionMaxLevel() && (Configuration.customs().championEnableInInstances() || this.getInstanceId() == 0) && Rnd.get((int)100) < Configuration.customs().getChampionFrequency()) {
            ((L2Attackable)mob).setChampion(true);
        }
        mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
        mob.setSummoner(null);
        mob.resetSummonedNpcs();
        mob.setSpawn(this);
        mob.spawnMe(newlocx, newlocy, newlocz);
        L2Spawn.notifyNpcSpawned(mob);
        this._spawnedNpcs.add(mob);
        if (this._lastSpawnPoints != null) {
            this._lastSpawnPoints.put(mob.getObjectId(), new Location(newlocx, newlocy, newlocz));
        }
        if (Configuration.general().debug()) {
            LOG.trace("Spawned Mob Id: {} , at: X: {} Y: {} Z: {}", this._template.getId(), mob.getX(), mob.getY(), mob.getZ());
        }
        ++this._currentCount;
        return mob;
    }

    public static void addSpawnListener(SpawnListener listener) {
        _spawnListeners.add(listener);
    }

    public static void removeSpawnListener(SpawnListener listener) {
        _spawnListeners.remove(listener);
    }

    public static void notifyNpcSpawned(L2Npc npc) {
        for (SpawnListener listener : _spawnListeners) {
            listener.npcSpawned(npc);
        }
    }

    public void setRespawnDelay(int delay, int randomInterval) {
        if (delay != 0) {
            if (delay < 0) {
                LOG.warn("Respawn delay is negative for spawn: {}", (Object)this);
            }
            int minDelay = delay - randomInterval;
            int maxDelay = delay + randomInterval;
            this._respawnMinDelay = Math.max(10, minDelay) * 1000;
            this._respawnMaxDelay = Math.max(10, maxDelay) * 1000;
        } else {
            this._respawnMinDelay = 0;
            this._respawnMaxDelay = 0;
        }
    }

    public void setRespawnDelay(int delay) {
        this.setRespawnDelay(delay, 0);
    }

    public int getRespawnDelay() {
        return (this._respawnMinDelay + this._respawnMaxDelay) / 2;
    }

    public boolean hasRespawnRandom() {
        return this._respawnMinDelay != this._respawnMaxDelay;
    }

    public void setSpawnTerritory(NpcSpawnTerritory territory) {
        this._spawnTerritory = territory;
        this._lastSpawnPoints = new ConcurrentHashMap<Integer, Location>();
    }

    public NpcSpawnTerritory getSpawnTerritory() {
        return this._spawnTerritory;
    }

    public boolean isTerritoryBased() {
        return this._spawnTerritory != null && this._location.getX() == 0 && this._location.getY() == 0;
    }

    public L2Npc getLastSpawn() {
        return this._spawnedNpcs.peekLast();
    }

    public final Deque<L2Npc> getSpawnedNpcs() {
        return this._spawnedNpcs;
    }

    public void respawnNpc(L2Npc oldNpc) {
        if (this._doRespawn) {
            oldNpc.refreshID();
            this.initializeNpcInstance(oldNpc);
        }
    }

    public L2NpcTemplate getTemplate() {
        return this._template;
    }

    @Override
    public int getInstanceId() {
        return this._location.getInstanceId();
    }

    @Override
    public void setInstanceId(int instanceId) {
        this._location.setInstanceId(instanceId);
    }

    public final boolean isNoRndWalk() {
        return this._isNoRndWalk;
    }

    public final void setIsNoRndWalk(boolean value) {
        this._isNoRndWalk = value;
    }

    public String getAreaName() {
        return this._areaName;
    }

    public void setAreaName(String areaName) {
        this._areaName = areaName;
    }

    public int getGlobalMapId() {
        return this._globalMapId;
    }

    public void setGlobalMapId(int globalMapId) {
        this._globalMapId = globalMapId;
    }

    public String toString() {
        return "L2Spawn ID: " + this.getId() + " " + String.valueOf(this.getLocation());
    }

    class SpawnTask
    implements Runnable {
        private final L2Npc _oldNpc;

        public SpawnTask(L2Npc pOldNpc) {
            this._oldNpc = pOldNpc;
        }

        @Override
        public void run() {
            try {
                L2Spawn.this.respawnNpc(this._oldNpc);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            --L2Spawn.this._scheduledCount;
        }
    }
}

