/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2World {
    private static final Logger LOG = LoggerFactory.getLogger(L2World.class);
    public static final int GRACIA_MAX_X = -166168;
    public static final int GRACIA_MAX_Z = 6105;
    public static final int GRACIA_MIN_Z = -895;
    public static final int SHIFT_BY = 12;
    private static final int TILE_SIZE = 32768;
    public static final int TILE_X_MIN = 11;
    public static final int TILE_Y_MIN = 10;
    public static final int TILE_X_MAX = 26;
    public static final int TILE_Y_MAX = 26;
    public static final int TILE_ZERO_COORD_X = 20;
    public static final int TILE_ZERO_COORD_Y = 18;
    public static final int MAP_MIN_X = -294912;
    public static final int MAP_MIN_Y = -262144;
    public static final int MAP_MAX_X = 229376;
    public static final int MAP_MAX_Y = 294912;
    public static final int OFFSET_X = Math.abs(-72);
    public static final int OFFSET_Y = Math.abs(-64);
    private static final int REGIONS_X = 56 + OFFSET_X;
    private static final int REGIONS_Y = 72 + OFFSET_Y;
    private final Map<Integer, L2PcInstance> _allPlayers = new ConcurrentHashMap<Integer, L2PcInstance>();
    private final Map<Integer, L2Object> _allObjects = new ConcurrentHashMap<Integer, L2Object>();
    private final Map<Integer, L2PetInstance> _petsInstance = new ConcurrentHashMap<Integer, L2PetInstance>();
    private L2WorldRegion[][] _worldRegions;

    protected L2World() {
        this.initRegions();
    }

    public void storeObject(L2Object object) {
        if (this._allObjects.containsKey(object.getObjectId())) {
            LOG.warn("Current object: {} already exist in OID map!", (Object)object);
            return;
        }
        this._allObjects.put(object.getObjectId(), object);
    }

    public void removeObject(L2Object object) {
        this._allObjects.remove(object.getObjectId());
    }

    public L2Object findObject(int objectId) {
        return this._allObjects.get(objectId);
    }

    public Collection<L2Object> getVisibleObjects() {
        return this._allObjects.values();
    }

    public int getVisibleObjectsCount() {
        return this._allObjects.size();
    }

    public List<L2PcInstance> getAllGMs() {
        return AdminData.getInstance().getAllGms(true);
    }

    public Collection<L2PcInstance> getPlayers() {
        return this._allPlayers.values();
    }

    public L2PcInstance[] getPlayersSortedBy(Comparator<L2PcInstance> comparator) {
        L2PcInstance[] players = this._allPlayers.values().toArray(new L2PcInstance[this._allPlayers.size()]);
        Arrays.sort(players, comparator);
        return players;
    }

    public int getAllPlayersCount() {
        return this._allPlayers.size();
    }

    public L2PcInstance getPlayer(String name) {
        return this.getPlayer(CharNameTable.getInstance().getIdByName(name));
    }

    public L2PcInstance getPlayer(int objectId) {
        return this._allPlayers.get(objectId);
    }

    public L2PetInstance getPet(int ownerId) {
        return this._petsInstance.get(ownerId);
    }

    public L2PetInstance addPet(int ownerId, L2PetInstance pet) {
        return this._petsInstance.put(ownerId, pet);
    }

    public void removePet(int ownerId) {
        this._petsInstance.remove(ownerId);
    }

    public void removePet(L2PetInstance pet) {
        this._petsInstance.remove(pet.getOwner().getObjectId());
    }

    public void addVisibleObject(L2Object object, L2WorldRegion newRegion) {
        if (!newRegion.isActive()) {
            return;
        }
        List<L2Object> visibles = this.getVisibleObjects(object, 2000);
        if (Configuration.general().debug()) {
            LOG.debug("Objects in range {}.", (Object)visibles.size());
        }
        for (L2Object visible : visibles) {
            if (visible == null) continue;
            visible.getKnownList().addKnownObject(object);
            object.getKnownList().addKnownObject(visible);
        }
    }

    public void addPlayerToWorld(L2PcInstance player) {
        this._allPlayers.put(player.getObjectId(), player);
    }

    public void removeFromAllPlayers(L2PcInstance player) {
        this._allPlayers.remove(player.getObjectId());
    }

    public void removeVisibleObject(L2Object object, L2WorldRegion oldWorldRegion) {
        if (object == null) {
            return;
        }
        if (oldWorldRegion == null) {
            return;
        }
        oldWorldRegion.removeVisibleObject(object);
        for (L2WorldRegion worldRegion : oldWorldRegion.getSurroundingRegions()) {
            for (L2Object obj : worldRegion.getVisibleObjects().values()) {
                if (obj == null) continue;
                obj.getKnownList().removeKnownObject(object);
            }
        }
        object.getKnownList().removeAllKnownObjects();
    }

    public List<L2Object> getVisibleObjects(L2Object object) {
        LinkedList<L2Object> result = new LinkedList<L2Object>();
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            for (L2Object visibleObject : regi.getVisibleObjects().values()) {
                if (visibleObject == null || visibleObject.equals(object) || !visibleObject.isVisible()) continue;
                result.add(visibleObject);
            }
        }
        return result;
    }

    public List<L2Object> getVisibleObjects(L2Object object, int radius) {
        return this.getVisibleObjects(object, radius, true);
    }

    public List<L2Object> getVisibleObjects(L2Object object, int radius, boolean excludeTarget) {
        return this.getVisibleObjectsStream(object, radius, excludeTarget).toList();
    }

    public Stream<L2Object> getVisibleObjectsStream(L2Object object, int radius, boolean excludeTarget) {
        if (object == null || !object.isVisible()) {
            return Stream.of(new L2Object[0]);
        }
        int sqRadius = radius * radius;
        return object.getWorldRegion().getSurroundingRegions().stream().flatMap(r -> r.getVisibleObjects().values().stream()).filter(Objects::nonNull).filter(o -> !excludeTarget || !o.equals(object)).filter(o -> (double)sqRadius > object.calculateDistance((ILocational)o, false, true));
    }

    public List<L2Object> getVisibleObjects3D(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new ArrayList<L2Object>();
        }
        int sqRadius = radius * radius;
        LinkedList<L2Object> result = new LinkedList<L2Object>();
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            for (L2Object _object : regi.getVisibleObjects().values()) {
                if (_object == null || _object.equals(object) || !((double)sqRadius > object.calculateDistance(_object, true, true))) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Playable> getVisiblePlayable(L2Object object) {
        L2WorldRegion reg = object.getWorldRegion();
        if (reg == null) {
            return null;
        }
        LinkedList<L2Playable> result = new LinkedList<L2Playable>();
        for (L2WorldRegion regi : reg.getSurroundingRegions()) {
            Map<Integer, L2Playable> _allpls = regi.getVisiblePlayable();
            Collection<L2Playable> _playables = _allpls.values();
            for (L2Playable _object : _playables) {
                if (_object == null || _object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public L2WorldRegion getRegion(Location point) {
        return this._worldRegions[(point.getX() >> 12) + OFFSET_X][(point.getY() >> 12) + OFFSET_Y];
    }

    public L2WorldRegion getRegion(int x, int y) {
        return this._worldRegions[(x >> 12) + OFFSET_X][(y >> 12) + OFFSET_Y];
    }

    public L2WorldRegion[][] getWorldRegions() {
        return this._worldRegions;
    }

    private boolean validRegion(int x, int y) {
        return x >= 0 && x <= REGIONS_X && y >= 0 && y <= REGIONS_Y;
    }

    private void initRegions() {
        this._worldRegions = new L2WorldRegion[REGIONS_X + 1][REGIONS_Y + 1];
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j] = new L2WorldRegion(i, j);
            }
        }
        for (int x = 0; x <= REGIONS_X; ++x) {
            for (int y = 0; y <= REGIONS_Y; ++y) {
                for (int a = -1; a <= 1; ++a) {
                    for (int b = -1; b <= 1; ++b) {
                        if (!this.validRegion(x + a, y + b)) continue;
                        this._worldRegions[x + a][y + b].addSurroundingRegion(this._worldRegions[x][y]);
                    }
                }
            }
        }
        LOG.info("{} by {} world region grid set up.", (Object)REGIONS_X, (Object)REGIONS_Y);
    }

    public void deleteVisibleNpcSpawns() {
        LOG.info("Deleting all visible NPCs.");
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j].deleteVisibleNpcSpawns();
            }
        }
        LOG.info("All visible NPCs deleted.");
    }

    public static L2World getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final L2World INSTANCE = new L2World();

        private SingletonHolder() {
        }
    }
}

