/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2ControllableMobAI;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2GroupSpawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class MobGroup {
    private final L2NpcTemplate _npcTemplate;
    private final int _groupId;
    private final int _maxMobCount;
    private List<L2ControllableMobInstance> _mobs;

    public MobGroup(int groupId, L2NpcTemplate npcTemplate, int maxMobCount) {
        this._groupId = groupId;
        this._npcTemplate = npcTemplate;
        this._maxMobCount = maxMobCount;
    }

    public int getActiveMobCount() {
        return this.getMobs().size();
    }

    public int getGroupId() {
        return this._groupId;
    }

    public int getMaxMobCount() {
        return this._maxMobCount;
    }

    public List<L2ControllableMobInstance> getMobs() {
        if (this._mobs == null) {
            this._mobs = new CopyOnWriteArrayList<L2ControllableMobInstance>();
        }
        return this._mobs;
    }

    public String getStatus() {
        try {
            L2ControllableMobAI mobGroupAI = (L2ControllableMobAI)this.getMobs().get(0).getAI();
            return switch (mobGroupAI.getAlternateAI()) {
                case 3 -> "Force Attacking";
                case 4 -> "Following";
                case 5 -> "Casting";
                case 6 -> "Attacking Group";
                default -> "Idle";
            };
        }
        catch (Exception e) {
            return "Unspawned";
        }
    }

    public L2NpcTemplate getTemplate() {
        return this._npcTemplate;
    }

    public boolean isGroupMember(L2ControllableMobInstance mobInst) {
        for (L2ControllableMobInstance groupMember : this.getMobs()) {
            if (groupMember == null || groupMember.getObjectId() != mobInst.getObjectId()) continue;
            return true;
        }
        return false;
    }

    public void spawnGroup(int x, int y, int z) {
        if (this.getActiveMobCount() > 0) {
            return;
        }
        try {
            for (int i = 0; i < this.getMaxMobCount(); ++i) {
                L2GroupSpawn spawn = new L2GroupSpawn(this.getTemplate());
                int signX = Rnd.nextInt((int)2) == 0 ? -1 : 1;
                int signY = Rnd.nextInt((int)2) == 0 ? -1 : 1;
                int randX = Rnd.nextInt((int)300);
                int randY = Rnd.nextInt((int)300);
                spawn.setX(x + signX * randX);
                spawn.setY(y + signY * randY);
                spawn.setZ(z);
                spawn.stopRespawn();
                SpawnTable.getInstance().addNewSpawn(spawn, false);
                this.getMobs().add((L2ControllableMobInstance)spawn.doGroupSpawn());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void spawnGroup(L2PcInstance activeChar) {
        this.spawnGroup(activeChar.getX(), activeChar.getY(), activeChar.getZ());
    }

    public void teleportGroup(L2PcInstance player) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null || mobInst.isDead()) continue;
            int x = player.getX() + Rnd.nextInt((int)50);
            int y = player.getY() + Rnd.nextInt((int)50);
            mobInst.teleToLocation((ILocational)new Location(x, y, player.getZ()), true);
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.follow(player);
        }
    }

    public L2ControllableMobInstance getRandomMob() {
        this.removeDead();
        if (this.getActiveMobCount() == 0) {
            return null;
        }
        int choice = Rnd.nextInt((int)this.getActiveMobCount());
        return this.getMobs().get(choice);
    }

    public void unspawnGroup() {
        this.removeDead();
        if (this.getActiveMobCount() == 0) {
            return;
        }
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            if (!mobInst.isDead()) {
                mobInst.deleteMe();
            }
            SpawnTable.getInstance().deleteSpawn(mobInst.getSpawn(), false);
        }
        this.getMobs().clear();
    }

    public void killGroup(L2PcInstance activeChar) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            if (!mobInst.isDead()) {
                mobInst.reduceCurrentHp(mobInst.getMaxHp() + 1, activeChar, null);
            }
            SpawnTable.getInstance().deleteSpawn(mobInst.getSpawn(), false);
        }
        this.getMobs().clear();
    }

    public void setAttackRandom() {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.setAlternateAI(2);
            ai.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void setAttackTarget(L2Character target) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.forceAttack(target);
        }
    }

    public void setIdleMode() {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.stop();
        }
    }

    public void returnGroup(L2Character activeChar) {
        this.setIdleMode();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            int signX = Rnd.nextInt((int)2) == 0 ? -1 : 1;
            int signY = Rnd.nextInt((int)2) == 0 ? -1 : 1;
            int randX = Rnd.nextInt((int)300);
            int randY = Rnd.nextInt((int)300);
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.move(activeChar.getX() + signX * randX, activeChar.getY() + signY * randY, activeChar.getZ());
        }
    }

    public void setFollowMode(L2Character character) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.follow(character);
        }
    }

    public void setCastMode() {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.setAlternateAI(5);
        }
    }

    public void setNoMoveMode(boolean enabled) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.setNotMoving(enabled);
        }
    }

    protected void removeDead() {
        LinkedList<L2ControllableMobInstance> deadMobs = new LinkedList<L2ControllableMobInstance>();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null || !mobInst.isDead()) continue;
            deadMobs.add(mobInst);
        }
        this.getMobs().removeAll(deadMobs);
    }

    public void setInvul(boolean invulState) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            mobInst.setInvul(invulState);
        }
    }

    public void setAttackGroup(MobGroup otherGrp) {
        this.removeDead();
        for (L2ControllableMobInstance mobInst : this.getMobs()) {
            if (mobInst == null) continue;
            L2ControllableMobAI ai = (L2ControllableMobAI)mobInst.getAI();
            ai.forceAttackGroup(otherGrp);
            ai.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }
}

