/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.holders.MinionHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.IParserAdvUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsSet
implements IParserAdvUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StatsSet.class);
    public static final StatsSet EMPTY_STATSET = new StatsSet(Collections.emptyMap());
    private final Map<String, Object> _set;

    public StatsSet() {
        this(new LinkedHashMap<String, Object>());
    }

    public StatsSet(Map<String, Object> map) {
        this._set = map;
    }

    public final Map<String, Object> getSet() {
        return this._set;
    }

    public void add(StatsSet newSet) {
        this._set.putAll(newSet.getSet());
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public boolean containsKey(String key) {
        return this._set.containsKey(key);
    }

    @Override
    public boolean getBoolean(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Boolean value required, but not specified");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public byte getByte(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + String.valueOf(val));
        }
    }

    public byte[] getByteArray(String key, String splitOn) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            return new byte[]{((Number)val).byteValue()};
        }
        int c = 0;
        String[] values = ((String)val).split(splitOn);
        byte[] result = new byte[values.length];
        for (String v : values) {
            try {
                result[c++] = Byte.parseByte(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Byte value required, but found: " + String.valueOf(val));
            }
        }
        return result;
    }

    public List<Byte> getByteList(String key, String splitOn) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        byte[] byArray = this.getByteArray(key, splitOn);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte i2 = byArray[i];
            result.add(i2);
        }
        return result;
    }

    @Override
    public short getShort(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Short value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public short getShort(String key, short defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public int getInt(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified: " + key + "!");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + String.valueOf(val) + "!");
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + String.valueOf(val));
        }
    }

    public int[] getIntArray(String key, String splitOn) {
        return this.getIntArray(key, null, splitOn);
    }

    public int[] getIntArray(String key, String defaultValue, String splitOn) {
        Object val = this._set.getOrDefault(key, defaultValue);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return new int[]{((Number)val).intValue()};
        }
        int c = 0;
        String[] values = ((String)val).split(splitOn);
        int[] result = new int[values.length];
        for (String v : values) {
            try {
                result[c++] = Integer.parseInt(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Integer value required, but found: " + String.valueOf(val));
            }
        }
        return result;
    }

    public List<Integer> getIntegerList(String key, String splitOn) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i : this.getIntArray(key, splitOn)) {
            result.add(i);
        }
        return result;
    }

    @Override
    public long getLong(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Long value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Long value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Long value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public float getFloat(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return Float.parseFloat((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return Float.parseFloat((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public double getDouble(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Double value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Double value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Double value required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public String getString(String key) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("String value required, but not specified");
        }
        return String.valueOf(val);
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        return String.valueOf(val);
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass) {
        Object val = this._set.get(key);
        if (val == null) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but not specified");
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but found: " + String.valueOf(val));
        }
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass, T defaultValue) {
        Object val = this._set.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but found: " + String.valueOf(val));
        }
    }

    public final <A> A getObject(String name, Class<A> type) {
        Object obj = this._set.get(name);
        if (obj == null || !type.isAssignableFrom(obj.getClass())) {
            return null;
        }
        return (A)obj;
    }

    public SkillHolder getSkillHolder(String key) {
        Object obj = this._set.get(key);
        if (!(obj instanceof SkillHolder)) {
            return null;
        }
        return (SkillHolder)obj;
    }

    public List<MinionHolder> getMinionList(String key) {
        Object obj = this._set.get(key);
        if (!(obj instanceof List)) {
            return Collections.emptyList();
        }
        return (List)obj;
    }

    public void set(String name, Object value) {
        this._set.put(name, value);
    }

    public void set(String key, boolean value) {
        this._set.put(key, value);
    }

    public void set(String key, byte value) {
        this._set.put(key, value);
    }

    public void set(String key, short value) {
        this._set.put(key, value);
    }

    public void set(String key, int value) {
        this._set.put(key, value);
    }

    public void set(String key, long value) {
        this._set.put(key, value);
    }

    public void set(String key, float value) {
        this._set.put(key, Float.valueOf(value));
    }

    public void set(String key, double value) {
        this._set.put(key, value);
    }

    public void set(String key, String value) {
        this._set.put(key, value);
    }

    public void set(String key, Enum<?> value) {
        this._set.put(key, value);
    }

    public void safeSet(String key, int value, int min, int max, String reference) {
        assert (min > max || value >= min && value < max);
        if (min <= max && (value < min || value >= max)) {
            LOG.error("Incorrect value: {} for: {} Ref: {}", value, key, reference);
        }
        this.set(key, value);
    }
}

