/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.data.xml.impl.UIData;
import com.l2jserver.gameserver.model.ActionKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIKeysSettings {
    private static final Logger LOG = LoggerFactory.getLogger(UIKeysSettings.class);
    private final int _playerObjId;
    private Map<Integer, List<ActionKey>> _storedKeys;
    private Map<Integer, List<Integer>> _storedCategories;
    private boolean _saved = true;

    public UIKeysSettings(int playerObjId) {
        this._playerObjId = playerObjId;
        this.loadFromDB();
    }

    public void storeAll(Map<Integer, List<Integer>> catMap, Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedCategories = catMap;
        this._storedKeys = keyMap;
    }

    public void storeCategories(Map<Integer, List<Integer>> catMap) {
        this._saved = false;
        this._storedCategories = catMap;
    }

    public Map<Integer, List<Integer>> getCategories() {
        return this._storedCategories;
    }

    public void storeKeys(Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedKeys = keyMap;
    }

    public Map<Integer, List<ActionKey>> getKeys() {
        return this._storedKeys;
    }

    private void loadFromDB() {
        this.getCatsFromDB();
        this.getKeysFromDB();
    }

    public void saveInDB() {
        Connection con;
        int order;
        if (this._saved) {
            return;
        }
        StringBuilder query = new StringBuilder("REPLACE INTO character_ui_categories (`charId`, `catId`, `order`, `cmdId`) VALUES ");
        for (int category : this._storedCategories.keySet()) {
            order = 0;
            Iterator<Object> iterator = this._storedCategories.get(category).iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                query.append("(").append(this._playerObjId).append(", ").append(category).append(", ").append(order++).append(", ").append(key).append("),");
            }
        }
        query = new StringBuilder(query.substring(0, query.length() - 1) + "; ");
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try (PreparedStatement statement = con.prepareStatement(query.toString());){
                statement.execute();
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: saveInDB(): {}", (Object)e.getMessage(), (Object)e);
        }
        query = new StringBuilder("REPLACE INTO character_ui_actions (`charId`, `cat`, `order`, `cmd`, `key`, `tgKey1`, `tgKey2`, `show`) VALUES");
        for (List<ActionKey> keyLst : this._storedKeys.values()) {
            order = 0;
            for (ActionKey key : keyLst) {
                query.append(key.getSqlSaveString(this._playerObjId, order++)).append(",");
            }
        }
        query = new StringBuilder(query.substring(0, query.length() - 1) + ";");
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try (PreparedStatement statement = con.prepareStatement(query.toString());){
                statement.execute();
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: saveInDB(): {}", (Object)e.getMessage(), (Object)e);
        }
        this._saved = true;
    }

    private void getCatsFromDB() {
        if (this._storedCategories != null) {
            return;
        }
        this._storedCategories = new HashMap<Integer, List<Integer>>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM character_ui_categories WHERE `charId` = ? ORDER BY `catId`, `order`");){
            ps.setInt(1, this._playerObjId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    UIData.addCategory(this._storedCategories, rs.getInt("catId"), rs.getInt("cmdId"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: getCatsFromDB(): {}", (Object)e.getMessage(), (Object)e);
        }
        if (this._storedCategories.isEmpty()) {
            this._storedCategories = UIData.getInstance().getCategories();
        }
    }

    private void getKeysFromDB() {
        if (this._storedKeys != null) {
            return;
        }
        this._storedKeys = new HashMap<Integer, List<ActionKey>>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM character_ui_actions WHERE `charId` = ? ORDER BY `cat`, `order`");){
            ps.setInt(1, this._playerObjId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cat = rs.getInt("cat");
                    int cmd = rs.getInt("cmd");
                    int key = rs.getInt("key");
                    int tgKey1 = rs.getInt("tgKey1");
                    int tgKey2 = rs.getInt("tgKey2");
                    int show = rs.getInt("show");
                    UIData.addKey(this._storedKeys, cat, new ActionKey(cat, cmd, key, tgKey1, tgKey2, show));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: getKeysFromDB(): {}", (Object)e.getMessage(), (Object)e);
        }
        if (this._storedKeys.isEmpty()) {
            this._storedKeys = UIData.getInstance().getKeys();
        }
    }

    public boolean isSaved() {
        return this._saved;
    }
}

