/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Tower;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2ControlTowerInstance
extends L2Tower {
    private static final Logger LOG = LoggerFactory.getLogger(L2ControlTowerInstance.class);
    private volatile List<L2Spawn> _guards;

    public L2ControlTowerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ControlTowerInstance);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (this.getCastle().getSiege().isInProgress()) {
            this.getCastle().getSiege().killedCT(this);
            if (this._guards != null && !this._guards.isEmpty()) {
                for (L2Spawn spawn : this._guards) {
                    try {
                        spawn.stopRespawn();
                    }
                    catch (Exception e) {
                        LOG.warn("Error at L2ControlTowerInstance {}", e);
                    }
                }
                this._guards.clear();
            }
        }
        return super.doDie(killer);
    }

    public void registerGuard(L2Spawn guard) {
        this.getGuards().add(guard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<L2Spawn> getGuards() {
        if (this._guards == null) {
            L2ControlTowerInstance l2ControlTowerInstance = this;
            synchronized (l2ControlTowerInstance) {
                if (this._guards == null) {
                    this._guards = new CopyOnWriteArrayList<L2Spawn>();
                }
            }
        }
        return this._guards;
    }
}

