/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.data.sql.impl.TeleportLocationTable;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2DoormenInstance
extends L2NpcInstance {
    private static final Logger LOG = LoggerFactory.getLogger(L2DoormenInstance.class);

    public L2DoormenInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2DoormenInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            this.showChatWindow(player);
            return;
        }
        if (command.startsWith("open_doors")) {
            if (this.isOwnerClan(player)) {
                if (this.isUnderSiege()) {
                    this.cannotManageDoors(player);
                } else {
                    this.openDoors(player, command);
                }
            }
            return;
        }
        if (command.startsWith("close_doors")) {
            if (this.isOwnerClan(player)) {
                if (this.isUnderSiege()) {
                    this.cannotManageDoors(player);
                } else {
                    this.closeDoors(player, command);
                }
            }
            return;
        }
        if (command.startsWith("tele")) {
            if (this.isOwnerClan(player)) {
                this.doTeleport(player, command);
            }
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (!this.isOwnerClan(player)) {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getId() + "-no.htm");
        } else {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getId() + ".htm");
        }
        html.replace("%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    protected void openDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(10), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            DoorData.getInstance().getDoor(Integer.parseInt(st.nextToken())).openMe();
        }
    }

    protected void closeDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(11), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            DoorData.getInstance().getDoor(Integer.parseInt(st.nextToken())).closeMe();
        }
    }

    protected void cannotManageDoors(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().getId() + "-busy.htm");
        player.sendPacket(html);
    }

    protected void doTeleport(L2PcInstance player, String command) {
        int whereTo = Integer.parseInt(command.substring(5).trim());
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(whereTo);
        if (list != null) {
            if (!player.isAlikeDead()) {
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), false);
            }
        } else {
            LOG.warn("No teleport destination with id: {}", (Object)whereTo);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected boolean isOwnerClan(L2PcInstance player) {
        return true;
    }

    protected boolean isUnderSiege() {
        return false;
    }
}

