/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.FortSiegeSpawn;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2FortCommanderInstance
extends L2DefenderInstance {
    private static final Logger LOG = LoggerFactory.getLogger(L2FortCommanderInstance.class);
    private boolean _canTalk;

    public L2FortCommanderInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2FortCommanderInstance);
        this._canTalk = true;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (!(attacker instanceof L2PcInstance)) {
            return false;
        }
        return this.getFort() != null && this.getFort().getResidenceId() > 0 && this.getFort().getSiege().isInProgress() && !this.getFort().getSiege().checkIsDefender(attacker.getClan());
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, long aggro) {
        if (attacker == null) {
            return;
        }
        if (!(attacker instanceof L2FortCommanderInstance)) {
            super.addDamageHate(attacker, damage, aggro);
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this.getFort().getSiege().isInProgress()) {
            this.getFort().getSiege().killedCommander(this);
        }
        return true;
    }

    @Override
    public void returnHome() {
        if (!this.isInsideRadius(this.getSpawn(), 200, false, false)) {
            if (Configuration.general().debug()) {
                LOG.debug("{} moving home", (Object)this.getObjectId());
            }
            this.setisReturningToSpawnPoint(true);
            this.clearAggroList();
            if (this.hasAI()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this.getSpawn().getLocation());
            }
        }
    }

    @Override
    public final void addDamage(L2Character attacker, int damage, Skill skill) {
        L2Spawn spawn = this.getSpawn();
        if (spawn != null && this.canTalk()) {
            List<FortSiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getResidenceId());
            for (FortSiegeSpawn spawn2 : commanders) {
                if (spawn2.getId() != spawn.getId()) continue;
                NpcStringId npcString = null;
                switch (spawn2.getMessageId()) {
                    case 1: {
                        npcString = NpcStringId.ATTACKING_THE_ENEMYS_REINFORCEMENTS_IS_NECESSARY_TIME_TO_DIE;
                        break;
                    }
                    case 2: {
                        if (attacker instanceof L2Summon) {
                            attacker = ((L2Summon)attacker).getOwner();
                        }
                        npcString = NpcStringId.EVERYONE_CONCENTRATE_YOUR_ATTACKS_ON_S1_SHOW_THE_ENEMY_YOUR_RESOLVE;
                        break;
                    }
                    case 3: {
                        npcString = NpcStringId.SPIRIT_OF_FIRE_UNLEASH_YOUR_POWER_BURN_THE_ENEMY;
                    }
                }
                if (npcString == null) continue;
                NpcSay ns = new NpcSay(this.getObjectId(), 23, this.getId(), npcString);
                if (npcString.getParamCount() == 1) {
                    ns.addStringParameter(attacker.getName());
                }
                this.broadcastPacket(ns);
                this.setCanTalk(false);
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTalkTask(), 10000L);
            }
        }
        super.addDamage(attacker, damage, skill);
    }

    void setCanTalk(boolean val) {
        this._canTalk = val;
    }

    private boolean canTalk() {
        return this._canTalk;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    private class ScheduleTalkTask
    implements Runnable {
        @Override
        public void run() {
            L2FortCommanderInstance.this.setCanTalk(true);
        }
    }
}

