/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.GuardKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcFirstTalk;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L2GuardInstance
extends L2Attackable {
    private static final Logger LOG = LoggerFactory.getLogger(L2GuardInstance.class);

    public L2GuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2GuardInstance);
    }

    @Override
    public final GuardKnownList getKnownList() {
        return (GuardKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new GuardKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker instanceof L2MonsterInstance;
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
        L2WorldRegion region = L2World.getInstance().getRegion(this.getX(), this.getY());
        if (region != null && !region.isActive()) {
            this.getAI().stopAITask();
        }
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        String pom = val == 0 ? "" + npcId : npcId + "-" + val;
        return "data/html/guard/" + pom + ".htm";
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this.getObjectId() != player.getTargetId()) {
            player.setTarget(this);
        } else if (interact) {
            if (this.isInAggroList(player)) {
                if (Configuration.general().debug()) {
                    LOG.debug("{}: Attacked guard {}", (Object)player.getObjectId(), (Object)this.getObjectId());
                }
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else if (!this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            } else {
                this.broadcastPacket(new SocialAction(this.getObjectId(), Rnd.nextInt((int)8)));
                player.setLastFolkNPC(this);
                if (this.hasListener(EventType.NPC_QUEST_START)) {
                    player.setLastQuestNpcObject(this.getObjectId());
                }
                if (this.hasListener(EventType.NPC_FIRST_TALK)) {
                    EventDispatcher.getInstance().notifyEventAsync(new NpcFirstTalk(this, player), this);
                } else {
                    this.showChatWindow(player, 0);
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

