/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import java.util.concurrent.Future;

public class L2SepulcherMonsterInstance
extends L2MonsterInstance {
    protected static final SkillHolder FAKE_PETRIFICATION = new SkillHolder(4616, 1);
    public int mysteriousBoxId = 0;
    protected Future<?> _victimSpawnKeyBoxTask = null;
    protected Future<?> _victimShout = null;
    protected Future<?> _changeImmortalTask = null;
    protected Future<?> _onDeadEventTask = null;

    public L2SepulcherMonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2SepulcherMonsterInstance);
        this.setShowSummonAnimation(true);
        switch (template.getId()) {
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                this.setIsRaid(true);
            }
        }
    }

    @Override
    public void onSpawn() {
        this.setShowSummonAnimation(false);
        switch (this.getId()) {
            case 18150: 
            case 18151: 
            case 18152: 
            case 18153: 
            case 18154: 
            case 18155: 
            case 18156: 
            case 18157: {
                if (this._victimSpawnKeyBoxTask != null) {
                    this._victimSpawnKeyBoxTask.cancel(true);
                }
                this._victimSpawnKeyBoxTask = ThreadPoolManager.getInstance().scheduleEffect(new VictimSpawnKeyBox(this), 300000L);
                if (this._victimShout != null) {
                    this._victimShout.cancel(true);
                }
                this._victimShout = ThreadPoolManager.getInstance().scheduleEffect(new VictimShout(this), 5000L);
                break;
            }
            case 18196: 
            case 18197: 
            case 18198: 
            case 18199: 
            case 18200: 
            case 18201: 
            case 18202: 
            case 18203: 
            case 18204: 
            case 18205: 
            case 18206: 
            case 18207: 
            case 18208: 
            case 18209: 
            case 18210: 
            case 18211: 
            case 18256: {
                break;
            }
            case 18231: 
            case 18232: 
            case 18233: 
            case 18234: 
            case 18235: 
            case 18236: 
            case 18237: 
            case 18238: 
            case 18239: 
            case 18240: 
            case 18241: 
            case 18242: 
            case 18243: {
                if (this._changeImmortalTask != null) {
                    this._changeImmortalTask.cancel(true);
                }
                this._changeImmortalTask = ThreadPoolManager.getInstance().scheduleEffect(new ChangeImmortal(this), 1600L);
                break;
            }
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                this.setIsRaid(true);
            }
        }
        super.onSpawn();
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        switch (this.getId()) {
            case 18120: 
            case 18121: 
            case 18122: 
            case 18123: 
            case 18124: 
            case 18125: 
            case 18126: 
            case 18127: 
            case 18128: 
            case 18129: 
            case 18130: 
            case 18131: 
            case 18149: 
            case 18158: 
            case 18159: 
            case 18160: 
            case 18161: 
            case 18162: 
            case 18163: 
            case 18164: 
            case 18165: 
            case 18183: 
            case 18184: 
            case 18212: 
            case 18213: 
            case 18214: 
            case 18215: 
            case 18216: 
            case 18217: 
            case 18218: 
            case 18219: {
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18150: 
            case 18151: 
            case 18152: 
            case 18153: 
            case 18154: 
            case 18155: 
            case 18156: 
            case 18157: {
                if (this._victimSpawnKeyBoxTask != null) {
                    this._victimSpawnKeyBoxTask.cancel(true);
                    this._victimSpawnKeyBoxTask = null;
                }
                if (this._victimShout != null) {
                    this._victimShout.cancel(true);
                    this._victimShout = null;
                }
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18141: 
            case 18142: 
            case 18143: 
            case 18144: 
            case 18145: 
            case 18146: 
            case 18147: 
            case 18148: {
                if (!FourSepulchersManager.getInstance().isViscountMobsAnnihilated(this.mysteriousBoxId)) break;
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18220: 
            case 18221: 
            case 18222: 
            case 18223: 
            case 18224: 
            case 18225: 
            case 18226: 
            case 18227: 
            case 18228: 
            case 18229: 
            case 18230: 
            case 18231: 
            case 18232: 
            case 18233: 
            case 18234: 
            case 18235: 
            case 18236: 
            case 18237: 
            case 18238: 
            case 18239: 
            case 18240: {
                if (!FourSepulchersManager.getInstance().isDukeMobsAnnihilated(this.mysteriousBoxId)) break;
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 8500L);
            }
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        if (this._victimSpawnKeyBoxTask != null) {
            this._victimSpawnKeyBoxTask.cancel(true);
            this._victimSpawnKeyBoxTask = null;
        }
        if (this._onDeadEventTask != null) {
            this._onDeadEventTask.cancel(true);
            this._onDeadEventTask = null;
        }
        return super.deleteMe();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return true;
    }

    private class VictimSpawnKeyBox
    implements Runnable {
        private final L2SepulcherMonsterInstance _activeChar;

        public VictimSpawnKeyBox(L2SepulcherMonsterInstance activeChar) {
            this._activeChar = activeChar;
        }

        @Override
        public void run() {
            if (this._activeChar.isDead()) {
                return;
            }
            if (!this._activeChar.isVisible()) {
                return;
            }
            FourSepulchersManager.getInstance().spawnKeyBox(this._activeChar);
            L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), "Many thanks for rescue me."));
            if (L2SepulcherMonsterInstance.this._victimShout != null) {
                L2SepulcherMonsterInstance.this._victimShout.cancel(true);
            }
        }
    }

    private class VictimShout
    implements Runnable {
        private final L2SepulcherMonsterInstance _activeChar;

        public VictimShout(L2SepulcherMonsterInstance activeChar) {
            this._activeChar = activeChar;
        }

        @Override
        public void run() {
            if (this._activeChar.isDead()) {
                return;
            }
            if (!this._activeChar.isVisible()) {
                return;
            }
            L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), "forgive me!!"));
        }
    }

    private static class ChangeImmortal
    implements Runnable {
        L2SepulcherMonsterInstance activeChar;

        public ChangeImmortal(L2SepulcherMonsterInstance mob) {
            this.activeChar = mob;
        }

        @Override
        public void run() {
            FAKE_PETRIFICATION.getSkill().applyEffects(this.activeChar, this.activeChar);
        }
    }

    private static class OnDeadEvent
    implements Runnable {
        L2SepulcherMonsterInstance _activeChar;

        public OnDeadEvent(L2SepulcherMonsterInstance activeChar) {
            this._activeChar = activeChar;
        }

        @Override
        public void run() {
            switch (this._activeChar.getId()) {
                case 18120: 
                case 18121: 
                case 18122: 
                case 18123: 
                case 18124: 
                case 18125: 
                case 18126: 
                case 18127: 
                case 18128: 
                case 18129: 
                case 18130: 
                case 18131: 
                case 18149: 
                case 18158: 
                case 18159: 
                case 18160: 
                case 18161: 
                case 18162: 
                case 18163: 
                case 18164: 
                case 18165: 
                case 18183: 
                case 18184: 
                case 18212: 
                case 18213: 
                case 18214: 
                case 18215: 
                case 18216: 
                case 18217: 
                case 18218: 
                case 18219: {
                    FourSepulchersManager.getInstance().spawnKeyBox(this._activeChar);
                    break;
                }
                case 18150: 
                case 18151: 
                case 18152: 
                case 18153: 
                case 18154: 
                case 18155: 
                case 18156: 
                case 18157: {
                    FourSepulchersManager.getInstance().spawnExecutionerOfHalisha(this._activeChar);
                    break;
                }
                case 18141: 
                case 18142: 
                case 18143: 
                case 18144: 
                case 18145: 
                case 18146: 
                case 18147: 
                case 18148: {
                    FourSepulchersManager.getInstance().spawnMonster(this._activeChar.mysteriousBoxId);
                    break;
                }
                case 18220: 
                case 18221: 
                case 18222: 
                case 18223: 
                case 18224: 
                case 18225: 
                case 18226: 
                case 18227: 
                case 18228: 
                case 18229: 
                case 18230: 
                case 18231: 
                case 18232: 
                case 18233: 
                case 18234: 
                case 18235: 
                case 18236: 
                case 18237: 
                case 18238: 
                case 18239: 
                case 18240: {
                    FourSepulchersManager.getInstance().spawnArchonOfHalisha(this._activeChar.mysteriousBoxId);
                    break;
                }
                case 25339: 
                case 25342: 
                case 25346: 
                case 25349: {
                    FourSepulchersManager.getInstance().spawnEmperorsGraveNpc(this._activeChar.mysteriousBoxId);
                }
            }
        }
    }
}

