/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.StaticObjectKnownList;
import com.l2jserver.gameserver.model.actor.stat.StaticObjStat;
import com.l2jserver.gameserver.model.actor.status.StaticObjStatus;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.ShowTownMap;
import com.l2jserver.gameserver.network.serverpackets.StaticObject;

public final class L2StaticObjectInstance
extends L2Character {
    public static final int INTERACTION_DISTANCE = 150;
    public static final int MAP = 0;
    public static final int CHAIR_THRONE = 1;
    public static final int SIGNBOARD = 2;
    public static final int FLAGPOLE = 3;
    private final int _staticObjectId;
    private int _meshIndex = 0;
    private int _type = -1;
    private ShowTownMap _map;

    public L2StaticObjectInstance(int objectId, L2CharTemplate template, int staticId) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2StaticObjectInstance);
        this._staticObjectId = staticId;
    }

    @Override
    protected L2CharacterAI initAI() {
        return null;
    }

    @Override
    public int getId() {
        return this._staticObjectId;
    }

    @Override
    public StaticObjectKnownList getKnownList() {
        return (StaticObjectKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new StaticObjectKnownList(this));
    }

    @Override
    public StaticObjStat getStat() {
        return (StaticObjStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new StaticObjStat(this));
    }

    @Override
    public StaticObjStatus getStatus() {
        return (StaticObjStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new StaticObjStatus(this));
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void setMap(String texture, int x, int y) {
        this._map = new ShowTownMap("town_map." + texture, x, y);
    }

    public ShowTownMap getMap() {
        return this._map;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public void setMeshIndex(int meshIndex) {
        this._meshIndex = meshIndex;
        this.broadcastPacket(new StaticObject(this));
    }

    public int getMeshIndex() {
        return this._meshIndex;
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new StaticObject(this));
    }

    @Override
    public void moveToLocation(int x, int y, int z, int offset) {
    }

    @Override
    public void stopMove(Location loc) {
    }

    @Override
    public void doAttack(L2Character target) {
    }

    @Override
    public void doCast(Skill skill) {
    }
}

